/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.ErrorReporter;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.StaticScope;
import com.google.javascript.rhino.jstype.StaticSlot;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class Scope
implements StaticScope<JSType> {
    private final Map<String, Var> vars = new LinkedHashMap<String, Var>();
    private final Scope parent;
    private final Node rootNode;
    private final ObjectType thisType;
    private final boolean isBottom;

    Scope(Scope scope, Node node) {
        Preconditions.checkNotNull((Object)scope);
        Preconditions.checkArgument((node != scope.rootNode ? 1 : 0) != 0);
        this.parent = scope;
        this.rootNode = node;
        JSType jSType = node.getJSType();
        this.thisType = jSType != null && jSType instanceof FunctionType ? ((FunctionType)jSType).getTypeOfThis() : scope.thisType;
        this.isBottom = false;
    }

    Scope(Node node, AbstractCompiler abstractCompiler) {
        this.parent = null;
        this.rootNode = node;
        this.thisType = abstractCompiler.getTypeRegistry().getNativeObjectType(JSTypeNative.GLOBAL_THIS);
        this.isBottom = false;
    }

    Scope(Node node, ObjectType objectType) {
        this.parent = null;
        this.rootNode = node;
        this.thisType = objectType;
        this.isBottom = true;
    }

    boolean isBottom() {
        return this.isBottom;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public Scope getParent() {
        return this.parent;
    }

    Scope getGlobalScope() {
        Scope scope = this;
        while (scope.getParent() != null) {
            scope = scope.getParent();
        }
        return scope;
    }

    @Override
    public StaticScope<JSType> getParentScope() {
        return this.parent;
    }

    @Override
    public ObjectType getTypeOfThis() {
        return this.thisType;
    }

    Var declare(String string, Node node, JSType jSType, CompilerInput compilerInput) {
        return this.declare(string, node, jSType, compilerInput, true);
    }

    Var declare(String string, Node node, JSType jSType, CompilerInput compilerInput, boolean bl) {
        Preconditions.checkState((string != null && string.length() > 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(string) == null ? 1 : 0) != 0);
        Var var = new Var(bl);
        var.name = string;
        var.nameNode = node;
        var.type = jSType;
        var.scope = this;
        var.index = this.vars.size();
        var.input = compilerInput;
        JSDocInfo jSDocInfo = NodeUtil.getInfoForNameNode(node);
        var.isDefine = jSDocInfo != null && jSDocInfo.isDefine();
        var.info = jSDocInfo;
        this.vars.put(string, var);
        return var;
    }

    void undeclare(Var var) {
        Preconditions.checkState((var.scope == this ? 1 : 0) != 0);
        Preconditions.checkState((this.vars.get(var.name) == var ? 1 : 0) != 0);
        this.vars.remove(var.name);
    }

    @Override
    public StaticSlot<JSType> getSlot(String string) {
        return this.getVar(string);
    }

    @Override
    public StaticSlot<JSType> getOwnSlot(String string) {
        return this.vars.get(string);
    }

    public Var getVar(String string) {
        Var var = this.vars.get(string);
        if (var != null) {
            return var;
        }
        if (this.parent != null) {
            return this.parent.getVar(string);
        }
        return null;
    }

    public boolean isDeclared(String string, boolean bl) {
        Scope scope = this;
        if (scope.vars.containsKey(string)) {
            return true;
        }
        if (scope.parent != null && bl) {
            return scope.parent.isDeclared(string, bl);
        }
        return false;
    }

    public Iterator<Var> getVars() {
        return this.vars.values().iterator();
    }

    public int getVarCount() {
        return this.vars.size();
    }

    public boolean isGlobal() {
        return this.parent == null;
    }

    public boolean isLocal() {
        return !this.isGlobal();
    }

    public static class Var
    implements StaticSlot<JSType> {
        String name;
        Node nameNode;
        private JSType type;
        private JSDocInfo info = null;
        private final boolean typeInferred;
        CompilerInput input;
        boolean isDefine;
        int index;
        Scope scope;

        private Var(boolean bl) {
            this.typeInferred = bl;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Node getParentNode() {
            return this.nameNode == null ? null : this.nameNode.getParent();
        }

        Scope getScope() {
            return this.scope;
        }

        int getLocalVarIndex() {
            int n = this.index;
            Scope scope = this.scope.getParent();
            if (scope == null) {
                throw new IllegalArgumentException("Var is not local");
            }
            while (scope.getParent() != null) {
                n += scope.getVarCount();
                scope = scope.getParent();
            }
            return n;
        }

        public boolean isGlobal() {
            return this.scope.isGlobal();
        }

        public boolean isLocal() {
            return this.scope.isLocal();
        }

        boolean isExtern() {
            return this.input == null || this.input.isExtern();
        }

        public boolean isConst() {
            return NodeUtil.isConstantName(this.nameNode);
        }

        public boolean isDefine() {
            return this.isDefine;
        }

        public Node getInitialValue() {
            Node node = this.getParentNode();
            int n = node.getType();
            if (n == 105) {
                return node;
            }
            if (n == 86) {
                return node.getLastChild();
            }
            if (n == 118) {
                return this.nameNode.getFirstChild();
            }
            return null;
        }

        @Override
        public JSType getType() {
            return this.type;
        }

        public Node getNameNode() {
            return this.nameNode;
        }

        public JSDocInfo getJSDocInfo() {
            return this.info;
        }

        void setType(JSType jSType) {
            Preconditions.checkState((boolean)this.isTypeInferred());
            this.type = jSType;
        }

        void resolveType(ErrorReporter errorReporter) {
            if (this.type != null) {
                this.type = this.type.resolve(errorReporter, this.scope);
            }
        }

        @Override
        public boolean isTypeInferred() {
            return this.typeInferred;
        }

        public String getInputName() {
            if (this.input == null) {
                return "<non-file>";
            }
            return this.input.getName();
        }

        public boolean isNoShadow() {
            return this.info != null && this.info.isNoShadow();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Var)) {
                return false;
            }
            Var var = (Var)object;
            return var.nameNode == this.nameNode;
        }

        public int hashCode() {
            return this.nameNode.hashCode();
        }

        public String toString() {
            return "Scope.Var " + this.name;
        }
    }
}

