/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.CodeConsumer;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.TokenStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

class CodeGenerator {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final CodeConsumer cc;
    private final CharsetEncoder outputCharsetEncoder;

    CodeGenerator(CodeConsumer codeConsumer, Charset charset) {
        this.cc = codeConsumer;
        this.outputCharsetEncoder = charset == null || charset == Charsets.US_ASCII ? null : charset.newEncoder();
    }

    CodeGenerator(CodeConsumer codeConsumer) {
        this(codeConsumer, null);
    }

    void add(String string) {
        this.cc.add(string);
    }

    private void addIdentifier(String string) {
        this.cc.addIdentifier(CodeGenerator.identifierEscape(string));
    }

    void add(Node node) {
        this.add(node, Context.OTHER);
    }

    void add(Node node, Context context) {
        if (!this.cc.continueProcessing()) {
            return;
        }
        int n = node.getType();
        String string = NodeUtil.opToStr(n);
        int n2 = node.getChildCount();
        Node node2 = node.getFirstChild();
        Node node3 = node.getLastChild();
        if (string != null && node2 != node3) {
            Preconditions.checkState((n2 == 2 ? 1 : 0) != 0, (String)"Bad binary operator \"%s\": expected 2 arguments but got %s", (Object[])new Object[]{string, n2});
            int n3 = NodeUtil.precedence(n);
            this.addLeftExpr(node2, n3, context);
            this.cc.addOp(string, true);
            Context context2 = this.getContextForNoInOperator(context);
            if (node3.getType() == n && NodeUtil.isAssociative(n)) {
                this.addExpr(node3, n3, context2);
            } else if (NodeUtil.isAssignmentOp(node) && NodeUtil.isAssignmentOp(node3)) {
                this.addExpr(node3, n3, context2);
            } else {
                this.addExpr(node3, n3 + 1, context2);
            }
            return;
        }
        this.cc.startSourceMapping(node);
        switch (n) {
            case 77: {
                Preconditions.checkState((node2.getNext().getType() == 125 && !node2.getNext().hasMoreThanOneChild() ? 1 : 0) != 0);
                Preconditions.checkState((n2 >= 2 && n2 <= 3 ? 1 : 0) != 0);
                this.add("try");
                this.add(node2, Context.PRESERVE_BLOCK);
                Node node4 = node2.getNext().getFirstChild();
                if (node4 != null) {
                    this.add(node4);
                }
                if (n2 != 3) break;
                this.add("finally");
                this.add(node3, Context.PRESERVE_BLOCK);
                break;
            }
            case 120: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                this.add("catch(");
                this.add(node2);
                this.add(")");
                this.add(node3, Context.PRESERVE_BLOCK);
                break;
            }
            case 49: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.add("throw");
                this.add(node2);
                this.cc.endStatement(true);
                break;
            }
            case 4: {
                this.add("return");
                if (n2 == 1) {
                    this.add(node2);
                } else {
                    Preconditions.checkState((n2 == 0 ? 1 : 0) != 0);
                }
                this.cc.endStatement();
                break;
            }
            case 118: {
                if (node2 == null) break;
                this.add("var ");
                this.addList(node2, false, this.getContextForNoInOperator(context));
                break;
            }
            case 153: {
                Preconditions.checkState((!node.getString().isEmpty() ? 1 : 0) != 0);
                this.addIdentifier(node.getString());
                break;
            }
            case 38: {
                if (node2 == null || node2.getType() == 124) {
                    this.addIdentifier(node.getString());
                    break;
                }
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.addIdentifier(node.getString());
                this.cc.addOp("=", true);
                if (node2.getType() == 85) {
                    this.addExpr(node2, NodeUtil.precedence(86));
                    break;
                }
                this.addExpr(node2, 0, this.getContextForNoInOperator(context));
                break;
            }
            case 63: {
                this.add("[");
                this.addList(node2, (int[])node.getProp(30));
                this.add("]");
                break;
            }
            case 83: {
                this.add("(");
                this.addList(node2);
                this.add(")");
                break;
            }
            case 85: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                this.addList(node2, false, context);
                break;
            }
            case 39: {
                Preconditions.checkState((n2 == (node.getParent() != null && node.getParent().getType() == 64 ? 1 : 0) ? 1 : 0) != 0);
                this.cc.addNumber(node.getDouble());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 122: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.cc.addOp(NodeUtil.opToStrNoFail(n), false);
                this.addExpr(node2, NodeUtil.precedence(n));
                break;
            }
            case 29: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                if (node.getFirstChild().getType() == 39) {
                    this.cc.addNumber(-node.getFirstChild().getDouble());
                    break;
                }
                this.cc.addOp(NodeUtil.opToStrNoFail(n), false);
                this.addExpr(node2, NodeUtil.precedence(n));
                break;
            }
            case 98: {
                Preconditions.checkState((n2 == 3 ? 1 : 0) != 0);
                int n4 = NodeUtil.precedence(n);
                this.addLeftExpr(node2, n4 + 1, context);
                this.cc.addOp("?", true);
                this.addExpr(node2.getNext(), 1);
                this.cc.addOp(":", true);
                this.addExpr(node3, 1);
                break;
            }
            case 47: {
                if (node2.getType() != 40 || node3.getType() != 40) {
                    throw new Error("Expected children to be strings");
                }
                String string2 = CodeGenerator.regexpEscape(node2.getString(), this.outputCharsetEncoder);
                if (n2 == 2) {
                    this.add(string2 + node3.getString());
                    break;
                }
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.add(string2);
                break;
            }
            case 65: {
                this.add(node2);
                break;
            }
            case 69: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.add(node2);
                this.add(".");
                this.add((String)node.getProp(33));
                break;
            }
            case 105: {
                boolean bl;
                if (node.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                Preconditions.checkState((n2 == 3 ? 1 : 0) != 0);
                boolean bl2 = bl = context == Context.START_OF_EXPR;
                if (bl) {
                    this.add("(");
                }
                this.add("function");
                this.add(node2);
                this.add(node2.getNext());
                this.add(node3, Context.PRESERVE_BLOCK);
                this.cc.endFunction(context == Context.STATEMENT);
                if (!bl) break;
                this.add(")");
                break;
            }
            case 147: 
            case 148: {
                Preconditions.checkState((node.getParent().getType() == 64 ? 1 : 0) != 0);
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                Preconditions.checkState((node2.getType() == 105 ? 1 : 0) != 0);
                Preconditions.checkState((boolean)node2.getFirstChild().getString().isEmpty());
                if (n == 147) {
                    Preconditions.checkState((!node2.getChildAtIndex(1).hasChildren() ? 1 : 0) != 0);
                    this.add("get ");
                } else {
                    Preconditions.checkState((boolean)node2.getChildAtIndex(1).hasOneChild());
                    this.add("set ");
                }
                String string3 = node.getString();
                Node node5 = node2;
                Node node6 = node5.getChildAtIndex(1);
                Node node7 = node5.getLastChild();
                if (TokenStream.isJSIdentifier(string3) && NodeUtil.isLatin(string3)) {
                    this.add(string3);
                } else {
                    this.add(CodeGenerator.jsString(node.getString(), this.outputCharsetEncoder));
                }
                this.add(node6);
                this.add(node7, Context.PRESERVE_BLOCK);
                break;
            }
            case 125: 
            case 132: {
                boolean bl;
                if (node.getClass() != Node.class) {
                    throw new Error("Unexpected Node subclass.");
                }
                boolean bl3 = bl = context == Context.PRESERVE_BLOCK;
                if (bl) {
                    this.cc.beginBlock();
                }
                boolean bl4 = n == 132 || n == 125 && !bl && node.getParent() != null && node.getParent().getType() == 132;
                for (Node node8 = node2; node8 != null; node8 = node8.getNext()) {
                    this.add(node8, Context.STATEMENT);
                    if (node8.getType() == 118) {
                        this.cc.endStatement();
                    }
                    if (node8.getType() == 105) {
                        this.cc.maybeLineBreak();
                    }
                    if (!bl4) continue;
                    this.cc.notePreferredLineBreak();
                }
                if (!bl) break;
                this.cc.endBlock(this.cc.breakAfterBlockFor(node, context == Context.STATEMENT));
                break;
            }
            case 115: {
                if (n2 == 4) {
                    this.add("for(");
                    if (node2.getType() == 118) {
                        this.add(node2, Context.IN_FOR_INIT_CLAUSE);
                    } else {
                        this.addExpr(node2, 0, Context.IN_FOR_INIT_CLAUSE);
                    }
                    this.add(";");
                    this.add(node2.getNext());
                    this.add(";");
                    this.add(node2.getNext().getNext());
                    this.add(")");
                    this.addNonEmptyStatement(node3, this.getContextForNonEmptyExpression(context), false);
                    break;
                }
                Preconditions.checkState((n2 == 3 ? 1 : 0) != 0);
                this.add("for(");
                this.add(node2);
                this.add("in");
                this.add(node2.getNext());
                this.add(")");
                this.addNonEmptyStatement(node3, this.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 114: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                this.add("do");
                this.addNonEmptyStatement(node2, Context.OTHER, false);
                this.add("while(");
                this.add(node3);
                this.add(")");
                this.cc.endStatement();
                break;
            }
            case 113: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                this.add("while(");
                this.add(node2);
                this.add(")");
                this.addNonEmptyStatement(node3, this.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 124: {
                Preconditions.checkState((n2 == 0 ? 1 : 0) != 0);
                break;
            }
            case 33: {
                boolean bl;
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0, (String)"Bad GETPROP: expected 2 children, but got %s", (Object[])new Object[]{n2});
                Preconditions.checkState((node3.getType() == 40 ? 1 : 0) != 0, (Object)"Bad GETPROP: RHS should be STRING");
                boolean bl5 = bl = node2.getType() == 39;
                if (bl) {
                    this.add("(");
                }
                this.addLeftExpr(node2, NodeUtil.precedence(n), context);
                if (bl) {
                    this.add(")");
                }
                this.add(".");
                this.addIdentifier(node3.getString());
                break;
            }
            case 35: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0, (String)"Bad GETELEM: expected 2 children but got %s", (Object[])new Object[]{n2});
                this.addLeftExpr(node2, NodeUtil.precedence(n), context);
                this.add("[");
                this.add(node2.getNext());
                this.add("]");
                break;
            }
            case 119: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                this.add("with(");
                this.add(node2);
                this.add(")");
                this.addNonEmptyStatement(node3, this.getContextForNonEmptyExpression(context), false);
                break;
            }
            case 102: 
            case 103: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                String string4 = n == 102 ? "++" : "--";
                int n5 = node.getIntProp(31);
                if (n5 != 0) {
                    this.addLeftExpr(node2, NodeUtil.precedence(n), context);
                    this.cc.addOp(string4, false);
                    break;
                }
                this.cc.addOp(string4, false);
                this.add(node2);
                break;
            }
            case 37: {
                if (this.isIndirectEval(node2) || node.getBooleanProp(49) && NodeUtil.isGet(node2)) {
                    this.add("(0,");
                    this.addExpr(node2, NodeUtil.precedence(85));
                    this.add(")");
                } else {
                    this.addLeftExpr(node2, NodeUtil.precedence(n), context);
                }
                this.add("(");
                this.addList(node2.getNext());
                this.add(")");
                break;
            }
            case 108: {
                boolean bl;
                boolean bl6 = n2 == 3;
                boolean bl7 = bl = context == Context.BEFORE_DANGLING_ELSE && !bl6;
                if (bl) {
                    this.cc.beginBlock();
                }
                this.add("if(");
                this.add(node2);
                this.add(")");
                if (bl6) {
                    this.addNonEmptyStatement(node2.getNext(), Context.BEFORE_DANGLING_ELSE, false);
                    this.add("else");
                    this.addNonEmptyStatement(node3, this.getContextForNonEmptyExpression(context), false);
                } else {
                    this.addNonEmptyStatement(node2.getNext(), Context.OTHER, false);
                    Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                }
                if (!bl) break;
                this.cc.endBlock();
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                Preconditions.checkState((n2 == 0 ? 1 : 0) != 0);
                this.add(Node.tokenToName(n));
                break;
            }
            case 117: {
                Preconditions.checkState((n2 <= 1 ? 1 : 0) != 0);
                this.add("continue");
                if (n2 == 1) {
                    if (node2.getType() != 153) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(node2);
                }
                this.cc.endStatement();
                break;
            }
            case 152: {
                Preconditions.checkState((n2 == 0 ? 1 : 0) != 0);
                this.add("debugger");
                this.cc.endStatement();
                break;
            }
            case 116: {
                Preconditions.checkState((n2 <= 1 ? 1 : 0) != 0);
                this.add("break");
                if (n2 == 1) {
                    if (node2.getType() != 153) {
                        throw new Error("Unexpected token type. Should be LABEL_NAME.");
                    }
                    this.add(" ");
                    this.add(node2);
                }
                this.cc.endStatement();
                break;
            }
            case 129: {
                throw new Error("Unexpected EXPR_VOID. Should be EXPR_RESULT.");
            }
            case 130: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.add(node2, Context.START_OF_EXPR);
                this.cc.endStatement();
                break;
            }
            case 30: {
                this.add("new ");
                int n6 = NodeUtil.precedence(n);
                if (NodeUtil.containsType(node2, 37, new NodeUtil.MatchNotFunction())) {
                    n6 = NodeUtil.precedence(node2.getType()) + 1;
                }
                this.addExpr(node2, n6);
                Node node9 = node2.getNext();
                if (node9 == null) break;
                this.add("(");
                this.addList(node9);
                this.add(")");
                break;
            }
            case 40: {
                if (n2 != (node.getParent() != null && node.getParent().getType() == 64 ? 1 : 0)) {
                    throw new IllegalStateException("Unexpected String children: " + node.getParent().toStringTree());
                }
                this.add(CodeGenerator.jsString(node.getString(), this.outputCharsetEncoder));
                break;
            }
            case 31: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.add("delete ");
                this.add(node2);
                break;
            }
            case 64: {
                boolean bl;
                boolean bl8 = bl = context == Context.START_OF_EXPR;
                if (bl) {
                    this.add("(");
                }
                this.add("{");
                for (Node node10 = node2; node10 != null; node10 = node10.getNext()) {
                    if (node10 != node2) {
                        this.cc.listSeparator();
                    }
                    if (node10.getType() == 147 || node10.getType() == 148) {
                        this.add(node10);
                        continue;
                    }
                    if (node10.getType() == 40 && !TokenStream.isKeyword(node10.getString()) && TokenStream.isJSIdentifier(node10.getString()) && NodeUtil.isLatin(node10.getString())) {
                        this.add(node10.getString());
                    } else {
                        this.addExpr(node10, 1);
                    }
                    this.add(":");
                    this.addExpr(node10.getFirstChild(), 1);
                }
                this.add("}");
                if (!bl) break;
                this.add(")");
                break;
            }
            case 110: {
                this.add("switch(");
                this.add(node2);
                this.add(")");
                this.cc.beginBlock();
                this.addAllSiblings(node2.getNext());
                this.cc.endBlock(context == Context.STATEMENT);
                break;
            }
            case 111: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                this.add("case ");
                this.add(node2);
                this.addCaseBody(node3);
                break;
            }
            case 112: {
                Preconditions.checkState((n2 == 1 ? 1 : 0) != 0);
                this.add("default");
                this.addCaseBody(node2);
                break;
            }
            case 126: {
                Preconditions.checkState((n2 == 2 ? 1 : 0) != 0);
                if (node2.getType() != 153) {
                    throw new Error("Unexpected token type. Should be LABEL_NAME.");
                }
                this.add(node2);
                this.add(":");
                this.addNonEmptyStatement(node3, this.getContextForNonEmptyExpression(context), true);
                break;
            }
            case 8: {
                break;
            }
            default: {
                throw new Error("Unknown type " + n + "\n" + node.toStringTree());
            }
        }
        this.cc.endSourceMapping(node);
    }

    private boolean isIndirectEval(Node node) {
        return node.getType() == 38 && "eval".equals(node.getString()) && !node.getBooleanProp(48);
    }

    private void addNonEmptyStatement(Node node, Context context, boolean bl) {
        Node node2 = node;
        if (!bl && node.getType() != 125) {
            throw new Error("Missing BLOCK child.");
        }
        if (node.getType() == 125) {
            int n = CodeGenerator.getNonEmptyChildCount(node, 2);
            if (n == 0) {
                if (this.cc.shouldPreserveExtraBlocks()) {
                    this.cc.beginBlock();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(node, context == Context.STATEMENT));
                } else {
                    this.cc.endStatement(true);
                }
                return;
            }
            if (n == 1) {
                Node node3 = CodeGenerator.getFirstNonEmptyChild(node);
                boolean bl2 = this.cc.shouldPreserveExtraBlocks();
                if (bl2 || this.isOneExactlyFunctionOrDo(node3)) {
                    this.cc.beginBlock();
                    this.add(node3, Context.STATEMENT);
                    this.cc.maybeLineBreak();
                    this.cc.endBlock(this.cc.breakAfterBlockFor(node, context == Context.STATEMENT));
                    return;
                }
                node2 = node3;
            }
            if (n > 1) {
                context = Context.PRESERVE_BLOCK;
            }
        }
        if (node2.getType() == 124) {
            this.cc.endStatement(true);
        } else {
            this.add(node2, context);
            if (node2.getType() == 118) {
                this.cc.endStatement();
            }
        }
    }

    private boolean isOneExactlyFunctionOrDo(Node node) {
        if (node.getType() == 126) {
            Node node2 = node.getLastChild();
            if (node2.getType() != 125) {
                return this.isOneExactlyFunctionOrDo(node2);
            }
            if (CodeGenerator.getNonEmptyChildCount(node, 2) == 1) {
                return this.isOneExactlyFunctionOrDo(CodeGenerator.getFirstNonEmptyChild(node));
            }
            return false;
        }
        return node.getType() == 105 || node.getType() == 114;
    }

    void addLeftExpr(Node node, int n, Context context) {
        this.addExpr(node, n, context);
    }

    void addExpr(Node node, int n) {
        this.addExpr(node, n, Context.OTHER);
    }

    private void addExpr(Node node, int n, Context context) {
        if (NodeUtil.precedence(node.getType()) < n || context == Context.IN_FOR_INIT_CLAUSE && node.getType() == 51) {
            this.add("(");
            this.add(node, this.clearContextForNoInOperator(context));
            this.add(")");
        } else {
            this.add(node, context);
        }
    }

    void addList(Node node) {
        this.addList(node, true, Context.OTHER);
    }

    void addList(Node node, boolean bl) {
        this.addList(node, bl, Context.OTHER);
    }

    void addList(Node node, boolean bl, Context context) {
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            boolean bl2;
            boolean bl3 = bl2 = node2 == node;
            if (bl2) {
                this.addLeftExpr(node2, bl ? 1 : 0, context);
                continue;
            }
            this.cc.listSeparator();
            this.addExpr(node2, bl ? 1 : 0);
        }
    }

    void addList(Node node, int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            while (nArray != null && n2 < nArray.length && n == nArray[n2]) {
                this.cc.listSeparator();
                ++n;
                ++n2;
            }
            if (node2 != node) {
                this.cc.listSeparator();
            }
            this.addExpr(node2, 1);
            ++n;
        }
    }

    void addCaseBody(Node node) {
        this.cc.beginCaseBody();
        this.add(node);
        this.cc.endCaseBody();
    }

    void addAllSiblings(Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            this.add(node2);
        }
    }

    static String jsString(String string, CharsetEncoder charsetEncoder) {
        String string2;
        String string3;
        char c;
        int n = 0;
        int n2 = 0;
        block4: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\"': {
                    ++n2;
                    continue block4;
                }
                case '\'': {
                    ++n;
                }
            }
        }
        if (n < n2) {
            c = '\'';
            string3 = "\"";
            string2 = "\\'";
        } else {
            c = '\"';
            string3 = "\\\"";
            string2 = "'";
        }
        return CodeGenerator.strEscape(string, c, string3, string2, "\\\\", charsetEncoder);
    }

    static String regexpEscape(String string, CharsetEncoder charsetEncoder) {
        return CodeGenerator.strEscape(string, '/', "\"", "'", "\\", charsetEncoder);
    }

    static String escapeToDoubleQuotedJsString(String string) {
        return CodeGenerator.strEscape(string, '\"', "\\\"", "'", "\\\\", null);
    }

    static String regexpEscape(String string) {
        return CodeGenerator.regexpEscape(string, null);
    }

    static String strEscape(String string, char c, String string2, String string3, String string4, CharsetEncoder charsetEncoder) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 2);
        stringBuilder.append(c);
        block10: for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            switch (c2) {
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append(string4);
                    continue block10;
                }
                case '\"': {
                    stringBuilder.append(string2);
                    continue block10;
                }
                case '\'': {
                    stringBuilder.append(string3);
                    continue block10;
                }
                case '>': {
                    if (i >= 2 && (string.charAt(i - 1) == '-' && string.charAt(i - 2) == '-' || string.charAt(i - 1) == ']' && string.charAt(i - 2) == ']')) {
                        stringBuilder.append("\\>");
                        continue block10;
                    }
                    stringBuilder.append(c2);
                    continue block10;
                }
                case '<': {
                    if (string.regionMatches(true, i + 1, "/script", 0, "/script".length())) {
                        stringBuilder.append("<\\");
                        continue block10;
                    }
                    if (string.regionMatches(false, i + 1, "!--", 0, "!--".length())) {
                        stringBuilder.append("<\\");
                        continue block10;
                    }
                    stringBuilder.append(c2);
                    continue block10;
                }
                default: {
                    if (charsetEncoder != null) {
                        if (charsetEncoder.canEncode(c2)) {
                            stringBuilder.append(c2);
                            continue block10;
                        }
                        CodeGenerator.appendHexJavaScriptRepresentation(stringBuilder, c2);
                        continue block10;
                    }
                    if (c2 > '\u001f' && c2 <= '\u007f') {
                        stringBuilder.append(c2);
                        continue block10;
                    }
                    CodeGenerator.appendHexJavaScriptRepresentation(stringBuilder, c2);
                }
            }
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    static String identifierEscape(String string) {
        if (NodeUtil.isLatin(string)) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u001f' && c < '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            CodeGenerator.appendHexJavaScriptRepresentation(stringBuilder, c);
        }
        return stringBuilder.toString();
    }

    private static int getNonEmptyChildCount(Node node, int n) {
        int n2 = 0;
        for (Node node2 = node.getFirstChild(); node2 != null && n2 < n; node2 = node2.getNext()) {
            if (node2.getType() == 125) {
                n2 += CodeGenerator.getNonEmptyChildCount(node2, n - n2);
                continue;
            }
            if (node2.getType() == 124) continue;
            ++n2;
        }
        return n2;
    }

    private static Node getFirstNonEmptyChild(Node node) {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
            if (node2.getType() == 125) {
                Node node3 = CodeGenerator.getFirstNonEmptyChild(node2);
                if (node3 == null) continue;
                return node3;
            }
            if (node2.getType() == 124) continue;
            return node2;
        }
        return null;
    }

    private Context getContextForNonEmptyExpression(Context context) {
        return context == Context.BEFORE_DANGLING_ELSE ? Context.BEFORE_DANGLING_ELSE : Context.OTHER;
    }

    private Context getContextForNoInOperator(Context context) {
        return context == Context.IN_FOR_INIT_CLAUSE ? Context.IN_FOR_INIT_CLAUSE : Context.OTHER;
    }

    private Context clearContextForNoInOperator(Context context) {
        return context == Context.IN_FOR_INIT_CLAUSE ? Context.OTHER : context;
    }

    private static void appendHexJavaScriptRepresentation(StringBuilder stringBuilder, char c) {
        try {
            CodeGenerator.appendHexJavaScriptRepresentation(c, stringBuilder);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static void appendHexJavaScriptRepresentation(int n, Appendable appendable) throws IOException {
        if (Character.isSupplementaryCodePoint(n)) {
            char[] cArray = Character.toChars(n);
            CodeGenerator.appendHexJavaScriptRepresentation(cArray[0], appendable);
            CodeGenerator.appendHexJavaScriptRepresentation(cArray[1], appendable);
            return;
        }
        appendable.append("\\u").append(HEX_CHARS[n >>> 12 & 0xF]).append(HEX_CHARS[n >>> 8 & 0xF]).append(HEX_CHARS[n >>> 4 & 0xF]).append(HEX_CHARS[n & 0xF]);
    }

    static enum Context {
        STATEMENT,
        BEFORE_DANGLING_ELSE,
        START_OF_EXPR,
        PRESERVE_BLOCK,
        IN_FOR_INIT_CLAUSE,
        OTHER;

    }
}

