/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpResponse;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private int writeTimeout;
    private static final OutputWriter DEFAULT_CONNECTION_WRITER = new DefaultOutputWriter();

    NetHttpRequest(HttpURLConnection connection) {
        this.connection = connection;
        this.writeTimeout = 0;
        connection.setInstanceFollowRedirects(false);
    }

    @Override
    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connection.setReadTimeout(readTimeout);
        this.connection.setConnectTimeout(connectTimeout);
    }

    @Override
    public void setWriteTimeout(int writeTimeout) throws IOException {
        this.writeTimeout = writeTimeout;
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        return this.execute(DEFAULT_CONNECTION_WRITER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    LowLevelHttpResponse execute(OutputWriter outputWriter) throws IOException {
        HttpURLConnection connection = this.connection;
        if (this.getStreamingContent() != null) {
            String requestMethod;
            long contentLength;
            String contentEncoding;
            String contentType = this.getContentType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.getContentEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = this.getContentLength()) >= 0L) {
                connection.setRequestProperty("Content-Length", Long.toString(contentLength));
            }
            if ("POST".equals(requestMethod = connection.getRequestMethod()) || "PUT".equals(requestMethod)) {
                connection.setDoOutput(true);
                if (contentLength >= 0L && contentLength <= Integer.MAX_VALUE) {
                    connection.setFixedLengthStreamingMode((int)contentLength);
                } else {
                    connection.setChunkedStreamingMode(0);
                }
                OutputStream out = connection.getOutputStream();
                boolean threw = true;
                try {
                    this.writeContentToOutputStream(outputWriter, out);
                    threw = false;
                }
                finally {
                    block18: {
                        try {
                            out.close();
                        }
                        catch (IOException exception) {
                            if (threw) break block18;
                            throw exception;
                        }
                    }
                }
            }
            Preconditions.checkArgument(contentLength == 0L, "%s with non-zero content length is not supported", requestMethod);
        }
        boolean successfulConnection = false;
        try {
            connection.connect();
            NetHttpResponse response = new NetHttpResponse(connection);
            successfulConnection = true;
            NetHttpResponse netHttpResponse = response;
            return netHttpResponse;
        }
        finally {
            if (!successfulConnection) {
                connection.disconnect();
            }
        }
    }

    private void writeContentToOutputStream(final OutputWriter outputWriter, final OutputStream out) throws IOException {
        if (this.writeTimeout == 0) {
            outputWriter.write(out, this.getStreamingContent());
        } else {
            final StreamingContent content = this.getStreamingContent();
            Callable<Boolean> writeContent = new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    outputWriter.write(out, content);
                    return Boolean.TRUE;
                }
            };
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Object> future = executor.submit(new FutureTask<Boolean>(writeContent), null);
            executor.shutdown();
            try {
                future.get(this.writeTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new IOException("Socket write interrupted", e);
            }
            catch (ExecutionException e) {
                throw new IOException("Exception in socket write", e);
            }
            catch (TimeoutException e) {
                throw new IOException("Socket write timed out", e);
            }
            if (!executor.isTerminated()) {
                executor.shutdown();
            }
        }
    }

    static class DefaultOutputWriter
    implements OutputWriter {
        DefaultOutputWriter() {
        }

        @Override
        public void write(OutputStream outputStream, StreamingContent content) throws IOException {
            content.writeTo(outputStream);
        }
    }

    static interface OutputWriter {
        public void write(OutputStream var1, StreamingContent var2) throws IOException;
    }
}

