/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safehtml.shared;

import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.SafeHtmlHostedModeUtils;
import com.google.gwt.safehtml.shared.SafeHtmlString;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;

public final class SafeHtmlBuilder {
    private final StringBuilder sb = new StringBuilder();

    public SafeHtmlBuilder append(boolean b) {
        this.sb.append(b);
        return this;
    }

    public SafeHtmlBuilder append(byte num) {
        this.sb.append(num);
        return this;
    }

    public SafeHtmlBuilder append(char c) {
        this.sb.append(SafeHtmlUtils.htmlEscape(c));
        return this;
    }

    public SafeHtmlBuilder append(double num) {
        this.sb.append(num);
        return this;
    }

    public SafeHtmlBuilder append(float num) {
        this.sb.append(num);
        return this;
    }

    public SafeHtmlBuilder append(int num) {
        this.sb.append(num);
        return this;
    }

    public SafeHtmlBuilder append(long num) {
        this.sb.append(num);
        return this;
    }

    public SafeHtmlBuilder append(SafeHtml html) {
        this.sb.append(html.asString());
        return this;
    }

    public SafeHtmlBuilder appendEscaped(String text) {
        this.sb.append(SafeHtmlUtils.htmlEscape(text));
        return this;
    }

    public SafeHtmlBuilder appendEscapedLines(String text) {
        this.sb.append(SafeHtmlUtils.htmlEscape(text).replaceAll("\n", "<br>"));
        return this;
    }

    public SafeHtmlBuilder appendHtmlConstant(String html) {
        SafeHtmlHostedModeUtils.maybeCheckCompleteHtml(html);
        this.sb.append(html);
        return this;
    }

    public SafeHtml toSafeHtml() {
        return new SafeHtmlString(this.sb.toString());
    }
}

