/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.secretmanager;

import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.secretmanager.SecretManagerSyntaxUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

final class SecretManagerPropertyUtils {
    private static final Logger logger = LoggerFactory.getLogger(SecretManagerPropertyUtils.class);

    private SecretManagerPropertyUtils() {
    }

    static SecretVersionName getSecretVersionName(String input, GcpProjectIdProvider projectIdProvider) {
        Optional<String> usedPrefix = SecretManagerSyntaxUtils.getMatchedPrefixes(input::startsWith);
        boolean isAttemptingFullStringMatch = input.replace("sm://", "").contains(":");
        if (usedPrefix.isEmpty() || isAttemptingFullStringMatch) {
            return null;
        }
        SecretManagerSyntaxUtils.warnIfUsingDeprecatedSyntax(logger, usedPrefix.orElse(""));
        String resourcePath = input.substring(usedPrefix.get().length());
        String[] tokens = resourcePath.split("/");
        String projectId = projectIdProvider.getProjectId();
        String secretId = null;
        String version = "latest";
        if (tokens.length == 1) {
            secretId = tokens[0];
        } else if (tokens.length == 2) {
            secretId = tokens[0];
            version = tokens[1];
        } else if (tokens.length == 3) {
            projectId = tokens[0];
            secretId = tokens[1];
            version = tokens[2];
        } else if (tokens.length == 4 && tokens[0].equals("projects") && tokens[2].equals("secrets")) {
            projectId = tokens[1];
            secretId = tokens[3];
        } else if (tokens.length == 6 && tokens[0].equals("projects") && tokens[2].equals("secrets") && tokens[4].equals("versions")) {
            projectId = tokens[1];
            secretId = tokens[3];
            version = tokens[5];
        } else {
            throw new IllegalArgumentException("Unrecognized format for specifying a GCP Secret Manager secret: " + input);
        }
        Assert.hasText((String)secretId, (String)("The GCP Secret Manager secret id must not be empty: " + input));
        Assert.hasText((String)projectId, (String)("The GCP Secret Manager project id must not be empty: " + input));
        Assert.hasText((String)version, (String)("The GCP Secret Manager secret version must not be empty: " + input));
        return SecretVersionName.newBuilder().setProject(projectId).setSecret(secretId).setSecretVersion(version).build();
    }
}

