/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Entity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.DatastoreQuery;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProjectionResultTransformer
implements Utils.Function<Entity, Object> {
    private final Utils.Function<Entity, Object> entityToPojoFunc;
    private final ObjectManager objectManager;
    private final List<String> projectionFields;
    private final String alias;

    ProjectionResultTransformer(Utils.Function<Entity, Object> entityToPojoFunc, ObjectManager objectManager, List<String> projectionFields, String alias) {
        this.entityToPojoFunc = entityToPojoFunc;
        this.objectManager = objectManager;
        this.projectionFields = projectionFields;
        this.alias = alias;
    }

    @Override
    public Object apply(Entity from) {
        PersistenceCapable pc = (PersistenceCapable)this.entityToPojoFunc.apply(from);
        StateManager sm = this.objectManager.findStateManager((Object)pc);
        ArrayList<Object> values = Utils.newArrayList(new Object[0]);
        for (String projectionField : this.projectionFields) {
            StateManager currentStateManager = sm;
            DatastoreManager storeMgr = (DatastoreManager)this.objectManager.getStoreManager();
            ClassLoaderResolver clr = this.objectManager.getClassLoaderResolver();
            List<String> fieldNames = ProjectionResultTransformer.getTuples(projectionField, this.alias);
            Object curValue = null;
            boolean shouldBeDone = false;
            for (String fieldName : fieldNames) {
                if (shouldBeDone) {
                    throw new RuntimeException("Unable to extract field " + projectionField + " from " + sm.getClassMetaData().getFullClassName() + ".  This is most likely an App Engine bug.");
                }
                DatastoreTable table = storeMgr.getDatastoreClass(currentStateManager.getClassMetaData().getFullClassName(), clr);
                JavaTypeMapping typeMapping = table.getMappingForSimpleFieldName(fieldName);
                if (typeMapping instanceof EmbeddedMapping) {
                    typeMapping = table.getMappingForSimpleFieldName(fieldName);
                } else {
                    shouldBeDone = true;
                }
                AbstractMemberMetaData curMemberMetaData = typeMapping.getMemberMetaData();
                curValue = currentStateManager.provideField(curMemberMetaData.getAbsoluteFieldNumber());
                if (curValue == null) break;
                currentStateManager = this.objectManager.findStateManager(curValue);
            }
            values.add(curValue);
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return values.toArray(new Object[values.size()]);
    }

    private static List<String> getTuples(String dotDelimitedFieldName, String alias) {
        List<String> tuples = Arrays.asList(dotDelimitedFieldName.split("\\."));
        return DatastoreQuery.getTuples(tuples, alias);
    }
}

