/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.2
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * A directive to publish Pub/Sub notifications upon changes to a bucket.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.NotificationConfig}
 */
public final class NotificationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.NotificationConfig)
    NotificationConfigOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use NotificationConfig.newBuilder() to construct.
  private NotificationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NotificationConfig() {
    name_ = "";
    topic_ = "";
    etag_ = "";
    eventTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
    objectNamePrefix_ = "";
    payloadFormat_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NotificationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_NotificationConfig_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 4:
        return internalGetCustomAttributes();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_NotificationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.NotificationConfig.class,
            com.google.storage.v2.NotificationConfig.Builder.class);
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   *
   *
   * <pre>
   * Required. The resource name of this NotificationConfig.
   * Format:
   * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
   * The `{project}` portion may be `_` for globally unique buckets.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The resource name of this NotificationConfig.
   * Format:
   * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
   * The `{project}` portion may be `_` for globally unique buckets.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TOPIC_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object topic_ = "";
  /**
   *
   *
   * <pre>
   * Required. The Pub/Sub topic to which this subscription publishes. Formatted
   * as:
   * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
   * </pre>
   *
   * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The topic.
   */
  @java.lang.Override
  public java.lang.String getTopic() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      topic_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The Pub/Sub topic to which this subscription publishes. Formatted
   * as:
   * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
   * </pre>
   *
   * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for topic.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getTopicBytes() {
    java.lang.Object ref = topic_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      topic_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";
  /**
   *
   *
   * <pre>
   * The etag of the NotificationConfig.
   * If included in the metadata of GetNotificationConfigRequest, the operation
   * will only be performed if the etag matches that of the NotificationConfig.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * The etag of the NotificationConfig.
   * If included in the metadata of GetNotificationConfigRequest, the operation
   * will only be performed if the etag matches that of the NotificationConfig.
   * </pre>
   *
   * <code>string etag = 7;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EVENT_TYPES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList eventTypes_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * If present, only send notifications about listed event types. If
   * empty, sent notifications for all event types.
   * </pre>
   *
   * <code>repeated string event_types = 3;</code>
   *
   * @return A list containing the eventTypes.
   */
  public com.google.protobuf.ProtocolStringList getEventTypesList() {
    return eventTypes_;
  }
  /**
   *
   *
   * <pre>
   * If present, only send notifications about listed event types. If
   * empty, sent notifications for all event types.
   * </pre>
   *
   * <code>repeated string event_types = 3;</code>
   *
   * @return The count of eventTypes.
   */
  public int getEventTypesCount() {
    return eventTypes_.size();
  }
  /**
   *
   *
   * <pre>
   * If present, only send notifications about listed event types. If
   * empty, sent notifications for all event types.
   * </pre>
   *
   * <code>repeated string event_types = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The eventTypes at the given index.
   */
  public java.lang.String getEventTypes(int index) {
    return eventTypes_.get(index);
  }
  /**
   *
   *
   * <pre>
   * If present, only send notifications about listed event types. If
   * empty, sent notifications for all event types.
   * </pre>
   *
   * <code>repeated string event_types = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the eventTypes at the given index.
   */
  public com.google.protobuf.ByteString getEventTypesBytes(int index) {
    return eventTypes_.getByteString(index);
  }

  public static final int CUSTOM_ATTRIBUTES_FIELD_NUMBER = 4;

  private static final class CustomAttributesDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.storage.v2.StorageProto
                .internal_static_google_storage_v2_NotificationConfig_CustomAttributesEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> customAttributes_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetCustomAttributes() {
    if (customAttributes_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          CustomAttributesDefaultEntryHolder.defaultEntry);
    }
    return customAttributes_;
  }

  public int getCustomAttributesCount() {
    return internalGetCustomAttributes().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * A list of additional attributes to attach to each Pub/Sub
   * message published for this NotificationConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
   */
  @java.lang.Override
  public boolean containsCustomAttributes(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetCustomAttributes().getMap().containsKey(key);
  }
  /** Use {@link #getCustomAttributesMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
    return getCustomAttributesMap();
  }
  /**
   *
   *
   * <pre>
   * A list of additional attributes to attach to each Pub/Sub
   * message published for this NotificationConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getCustomAttributesMap() {
    return internalGetCustomAttributes().getMap();
  }
  /**
   *
   *
   * <pre>
   * A list of additional attributes to attach to each Pub/Sub
   * message published for this NotificationConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getCustomAttributesOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetCustomAttributes().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * A list of additional attributes to attach to each Pub/Sub
   * message published for this NotificationConfig.
   * </pre>
   *
   * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
   */
  @java.lang.Override
  public java.lang.String getCustomAttributesOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetCustomAttributes().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int OBJECT_NAME_PREFIX_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object objectNamePrefix_ = "";
  /**
   *
   *
   * <pre>
   * If present, only apply this NotificationConfig to object names that
   * begin with this prefix.
   * </pre>
   *
   * <code>string object_name_prefix = 5;</code>
   *
   * @return The objectNamePrefix.
   */
  @java.lang.Override
  public java.lang.String getObjectNamePrefix() {
    java.lang.Object ref = objectNamePrefix_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      objectNamePrefix_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * If present, only apply this NotificationConfig to object names that
   * begin with this prefix.
   * </pre>
   *
   * <code>string object_name_prefix = 5;</code>
   *
   * @return The bytes for objectNamePrefix.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getObjectNamePrefixBytes() {
    java.lang.Object ref = objectNamePrefix_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      objectNamePrefix_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PAYLOAD_FORMAT_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object payloadFormat_ = "";
  /**
   *
   *
   * <pre>
   * Required. The desired content of the Payload.
   * </pre>
   *
   * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The payloadFormat.
   */
  @java.lang.Override
  public java.lang.String getPayloadFormat() {
    java.lang.Object ref = payloadFormat_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      payloadFormat_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The desired content of the Payload.
   * </pre>
   *
   * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for payloadFormat.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getPayloadFormatBytes() {
    java.lang.Object ref = payloadFormat_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      payloadFormat_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, topic_);
    }
    for (int i = 0; i < eventTypes_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, eventTypes_.getRaw(i));
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetCustomAttributes(), CustomAttributesDefaultEntryHolder.defaultEntry, 4);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectNamePrefix_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, objectNamePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payloadFormat_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, payloadFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, etag_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(topic_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, topic_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < eventTypes_.size(); i++) {
        dataSize += computeStringSizeNoTag(eventTypes_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getEventTypesList().size();
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetCustomAttributes().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> customAttributes__ =
          CustomAttributesDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, customAttributes__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(objectNamePrefix_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, objectNamePrefix_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(payloadFormat_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, payloadFormat_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(etag_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, etag_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.NotificationConfig)) {
      return super.equals(obj);
    }
    com.google.storage.v2.NotificationConfig other = (com.google.storage.v2.NotificationConfig) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getTopic().equals(other.getTopic())) return false;
    if (!getEtag().equals(other.getEtag())) return false;
    if (!getEventTypesList().equals(other.getEventTypesList())) return false;
    if (!internalGetCustomAttributes().equals(other.internalGetCustomAttributes())) return false;
    if (!getObjectNamePrefix().equals(other.getObjectNamePrefix())) return false;
    if (!getPayloadFormat().equals(other.getPayloadFormat())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TOPIC_FIELD_NUMBER;
    hash = (53 * hash) + getTopic().hashCode();
    hash = (37 * hash) + ETAG_FIELD_NUMBER;
    hash = (53 * hash) + getEtag().hashCode();
    if (getEventTypesCount() > 0) {
      hash = (37 * hash) + EVENT_TYPES_FIELD_NUMBER;
      hash = (53 * hash) + getEventTypesList().hashCode();
    }
    if (!internalGetCustomAttributes().getMap().isEmpty()) {
      hash = (37 * hash) + CUSTOM_ATTRIBUTES_FIELD_NUMBER;
      hash = (53 * hash) + internalGetCustomAttributes().hashCode();
    }
    hash = (37 * hash) + OBJECT_NAME_PREFIX_FIELD_NUMBER;
    hash = (53 * hash) + getObjectNamePrefix().hashCode();
    hash = (37 * hash) + PAYLOAD_FORMAT_FIELD_NUMBER;
    hash = (53 * hash) + getPayloadFormat().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.NotificationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.NotificationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.NotificationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.NotificationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A directive to publish Pub/Sub notifications upon changes to a bucket.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.NotificationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.NotificationConfig)
      com.google.storage.v2.NotificationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_NotificationConfig_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetCustomAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableCustomAttributes();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_NotificationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.NotificationConfig.class,
              com.google.storage.v2.NotificationConfig.Builder.class);
    }

    // Construct using com.google.storage.v2.NotificationConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      topic_ = "";
      etag_ = "";
      eventTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      internalGetMutableCustomAttributes().clear();
      objectNamePrefix_ = "";
      payloadFormat_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_NotificationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.NotificationConfig getDefaultInstanceForType() {
      return com.google.storage.v2.NotificationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.NotificationConfig build() {
      com.google.storage.v2.NotificationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.NotificationConfig buildPartial() {
      com.google.storage.v2.NotificationConfig result =
          new com.google.storage.v2.NotificationConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.NotificationConfig result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.topic_ = topic_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.etag_ = etag_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        eventTypes_.makeImmutable();
        result.eventTypes_ = eventTypes_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.customAttributes_ = internalGetCustomAttributes();
        result.customAttributes_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.objectNamePrefix_ = objectNamePrefix_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.payloadFormat_ = payloadFormat_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.NotificationConfig) {
        return mergeFrom((com.google.storage.v2.NotificationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.NotificationConfig other) {
      if (other == com.google.storage.v2.NotificationConfig.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getTopic().isEmpty()) {
        topic_ = other.topic_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getEtag().isEmpty()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.eventTypes_.isEmpty()) {
        if (eventTypes_.isEmpty()) {
          eventTypes_ = other.eventTypes_;
          bitField0_ |= 0x00000008;
        } else {
          ensureEventTypesIsMutable();
          eventTypes_.addAll(other.eventTypes_);
        }
        onChanged();
      }
      internalGetMutableCustomAttributes().mergeFrom(other.internalGetCustomAttributes());
      bitField0_ |= 0x00000010;
      if (!other.getObjectNamePrefix().isEmpty()) {
        objectNamePrefix_ = other.objectNamePrefix_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      if (!other.getPayloadFormat().isEmpty()) {
        payloadFormat_ = other.payloadFormat_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                topic_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureEventTypesIsMutable();
                eventTypes_.add(s);
                break;
              } // case 26
            case 34:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    customAttributes__ =
                        input.readMessage(
                            CustomAttributesDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableCustomAttributes()
                    .getMutableMap()
                    .put(customAttributes__.getKey(), customAttributes__.getValue());
                bitField0_ |= 0x00000010;
                break;
              } // case 34
            case 42:
              {
                objectNamePrefix_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 50:
              {
                payloadFormat_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 50
            case 58:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 58
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     *
     *
     * <pre>
     * Required. The resource name of this NotificationConfig.
     * Format:
     * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
     * The `{project}` portion may be `_` for globally unique buckets.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of this NotificationConfig.
     * Format:
     * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
     * The `{project}` portion may be `_` for globally unique buckets.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of this NotificationConfig.
     * Format:
     * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
     * The `{project}` portion may be `_` for globally unique buckets.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of this NotificationConfig.
     * Format:
     * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
     * The `{project}` portion may be `_` for globally unique buckets.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The resource name of this NotificationConfig.
     * Format:
     * `projects/{project}/buckets/{bucket}/notificationConfigs/{notificationConfig}`
     * The `{project}` portion may be `_` for globally unique buckets.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object topic_ = "";
    /**
     *
     *
     * <pre>
     * Required. The Pub/Sub topic to which this subscription publishes. Formatted
     * as:
     * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The topic.
     */
    public java.lang.String getTopic() {
      java.lang.Object ref = topic_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        topic_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Pub/Sub topic to which this subscription publishes. Formatted
     * as:
     * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for topic.
     */
    public com.google.protobuf.ByteString getTopicBytes() {
      java.lang.Object ref = topic_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        topic_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The Pub/Sub topic to which this subscription publishes. Formatted
     * as:
     * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopic(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      topic_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Pub/Sub topic to which this subscription publishes. Formatted
     * as:
     * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTopic() {
      topic_ = getDefaultInstance().getTopic();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The Pub/Sub topic to which this subscription publishes. Formatted
     * as:
     * '//pubsub.googleapis.com/projects/{project-identifier}/topics/{my-topic}'
     * </pre>
     *
     * <code>string topic = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for topic to set.
     * @return This builder for chaining.
     */
    public Builder setTopicBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      topic_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";
    /**
     *
     *
     * <pre>
     * The etag of the NotificationConfig.
     * If included in the metadata of GetNotificationConfigRequest, the operation
     * will only be performed if the etag matches that of the NotificationConfig.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag of the NotificationConfig.
     * If included in the metadata of GetNotificationConfigRequest, the operation
     * will only be performed if the etag matches that of the NotificationConfig.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * The etag of the NotificationConfig.
     * If included in the metadata of GetNotificationConfigRequest, the operation
     * will only be performed if the etag matches that of the NotificationConfig.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag of the NotificationConfig.
     * If included in the metadata of GetNotificationConfigRequest, the operation
     * will only be performed if the etag matches that of the NotificationConfig.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The etag of the NotificationConfig.
     * If included in the metadata of GetNotificationConfigRequest, the operation
     * will only be performed if the etag matches that of the NotificationConfig.
     * </pre>
     *
     * <code>string etag = 7;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList eventTypes_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureEventTypesIsMutable() {
      if (!eventTypes_.isModifiable()) {
        eventTypes_ = new com.google.protobuf.LazyStringArrayList(eventTypes_);
      }
      bitField0_ |= 0x00000008;
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @return A list containing the eventTypes.
     */
    public com.google.protobuf.ProtocolStringList getEventTypesList() {
      eventTypes_.makeImmutable();
      return eventTypes_;
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @return The count of eventTypes.
     */
    public int getEventTypesCount() {
      return eventTypes_.size();
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The eventTypes at the given index.
     */
    public java.lang.String getEventTypes(int index) {
      return eventTypes_.get(index);
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the eventTypes at the given index.
     */
    public com.google.protobuf.ByteString getEventTypesBytes(int index) {
      return eventTypes_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The eventTypes to set.
     * @return This builder for chaining.
     */
    public Builder setEventTypes(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEventTypesIsMutable();
      eventTypes_.set(index, value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @param value The eventTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEventTypes(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureEventTypesIsMutable();
      eventTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @param values The eventTypes to add.
     * @return This builder for chaining.
     */
    public Builder addAllEventTypes(java.lang.Iterable<java.lang.String> values) {
      ensureEventTypesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, eventTypes_);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEventTypes() {
      eventTypes_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000008);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, only send notifications about listed event types. If
     * empty, sent notifications for all event types.
     * </pre>
     *
     * <code>repeated string event_types = 3;</code>
     *
     * @param value The bytes of the eventTypes to add.
     * @return This builder for chaining.
     */
    public Builder addEventTypesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureEventTypesIsMutable();
      eventTypes_.add(value);
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> customAttributes_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetCustomAttributes() {
      if (customAttributes_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            CustomAttributesDefaultEntryHolder.defaultEntry);
      }
      return customAttributes_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableCustomAttributes() {
      if (customAttributes_ == null) {
        customAttributes_ =
            com.google.protobuf.MapField.newMapField(
                CustomAttributesDefaultEntryHolder.defaultEntry);
      }
      if (!customAttributes_.isMutable()) {
        customAttributes_ = customAttributes_.copy();
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return customAttributes_;
    }

    public int getCustomAttributesCount() {
      return internalGetCustomAttributes().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    @java.lang.Override
    public boolean containsCustomAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetCustomAttributes().getMap().containsKey(key);
    }
    /** Use {@link #getCustomAttributesMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getCustomAttributes() {
      return getCustomAttributesMap();
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getCustomAttributesMap() {
      return internalGetCustomAttributes().getMap();
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getCustomAttributesOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetCustomAttributes().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    @java.lang.Override
    public java.lang.String getCustomAttributesOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetCustomAttributes().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearCustomAttributes() {
      bitField0_ = (bitField0_ & ~0x00000010);
      internalGetMutableCustomAttributes().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    public Builder removeCustomAttributes(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableCustomAttributes().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableCustomAttributes() {
      bitField0_ |= 0x00000010;
      return internalGetMutableCustomAttributes().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    public Builder putCustomAttributes(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableCustomAttributes().getMutableMap().put(key, value);
      bitField0_ |= 0x00000010;
      return this;
    }
    /**
     *
     *
     * <pre>
     * A list of additional attributes to attach to each Pub/Sub
     * message published for this NotificationConfig.
     * </pre>
     *
     * <code>map&lt;string, string&gt; custom_attributes = 4;</code>
     */
    public Builder putAllCustomAttributes(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableCustomAttributes().getMutableMap().putAll(values);
      bitField0_ |= 0x00000010;
      return this;
    }

    private java.lang.Object objectNamePrefix_ = "";
    /**
     *
     *
     * <pre>
     * If present, only apply this NotificationConfig to object names that
     * begin with this prefix.
     * </pre>
     *
     * <code>string object_name_prefix = 5;</code>
     *
     * @return The objectNamePrefix.
     */
    public java.lang.String getObjectNamePrefix() {
      java.lang.Object ref = objectNamePrefix_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        objectNamePrefix_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, only apply this NotificationConfig to object names that
     * begin with this prefix.
     * </pre>
     *
     * <code>string object_name_prefix = 5;</code>
     *
     * @return The bytes for objectNamePrefix.
     */
    public com.google.protobuf.ByteString getObjectNamePrefixBytes() {
      java.lang.Object ref = objectNamePrefix_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        objectNamePrefix_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * If present, only apply this NotificationConfig to object names that
     * begin with this prefix.
     * </pre>
     *
     * <code>string object_name_prefix = 5;</code>
     *
     * @param value The objectNamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setObjectNamePrefix(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      objectNamePrefix_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, only apply this NotificationConfig to object names that
     * begin with this prefix.
     * </pre>
     *
     * <code>string object_name_prefix = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObjectNamePrefix() {
      objectNamePrefix_ = getDefaultInstance().getObjectNamePrefix();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If present, only apply this NotificationConfig to object names that
     * begin with this prefix.
     * </pre>
     *
     * <code>string object_name_prefix = 5;</code>
     *
     * @param value The bytes for objectNamePrefix to set.
     * @return This builder for chaining.
     */
    public Builder setObjectNamePrefixBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      objectNamePrefix_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    private java.lang.Object payloadFormat_ = "";
    /**
     *
     *
     * <pre>
     * Required. The desired content of the Payload.
     * </pre>
     *
     * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The payloadFormat.
     */
    public java.lang.String getPayloadFormat() {
      java.lang.Object ref = payloadFormat_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        payloadFormat_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired content of the Payload.
     * </pre>
     *
     * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for payloadFormat.
     */
    public com.google.protobuf.ByteString getPayloadFormatBytes() {
      java.lang.Object ref = payloadFormat_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        payloadFormat_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The desired content of the Payload.
     * </pre>
     *
     * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The payloadFormat to set.
     * @return This builder for chaining.
     */
    public Builder setPayloadFormat(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      payloadFormat_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired content of the Payload.
     * </pre>
     *
     * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPayloadFormat() {
      payloadFormat_ = getDefaultInstance().getPayloadFormat();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The desired content of the Payload.
     * </pre>
     *
     * <code>string payload_format = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for payloadFormat to set.
     * @return This builder for chaining.
     */
    public Builder setPayloadFormatBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      payloadFormat_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.NotificationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.NotificationConfig)
  private static final com.google.storage.v2.NotificationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.NotificationConfig();
  }

  public static com.google.storage.v2.NotificationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NotificationConfig> PARSER =
      new com.google.protobuf.AbstractParser<NotificationConfig>() {
        @java.lang.Override
        public NotificationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NotificationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NotificationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.NotificationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
