/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FolderLocationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String folder;
    private final String location;

    public String getFolder() {
        return this.folder;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FolderLocationName(Builder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public static FolderLocationName of(String folder, String location) {
        return FolderLocationName.newBuilder().setFolder(folder).setLocation(location).build();
    }

    public static String format(String folder, String location) {
        return FolderLocationName.newBuilder().setFolder(folder).setLocation(location).build().toString();
    }

    public static FolderLocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FolderLocationName.parse: formattedString not in valid format");
        return FolderLocationName.of((String)matchMap.get("folder"), (String)matchMap.get("location"));
    }

    public static List<FolderLocationName> parseList(List<String> formattedStrings) {
        ArrayList<FolderLocationName> list = new ArrayList<FolderLocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FolderLocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FolderLocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FolderLocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FolderLocationName folderLocationName = this;
            synchronized (folderLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"folder", this.folder, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FolderLocationName) {
            FolderLocationName that = (FolderLocationName)o;
            return this.folder.equals(that.folder) && this.location.equals(that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.folder.hashCode();
        h *= 1000003;
        return h ^= this.location.hashCode();
    }

    public static class Builder {
        private String folder;
        private String location;

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder() {
        }

        private Builder(FolderLocationName folderLocationName) {
            this.folder = folderLocationName.folder;
            this.location = folderLocationName.location;
        }

        public FolderLocationName build() {
            return new FolderLocationName(this);
        }
    }
}

