/*
 * Decompiled with CFR 0.152.
 */
package com.google.logging.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BillingAccountLocationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/locations/{location}");
    private volatile Map<String, String> fieldValuesMap;
    private final String billingAccount;
    private final String location;

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private BillingAccountLocationName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public static BillingAccountLocationName of(String billingAccount, String location) {
        return BillingAccountLocationName.newBuilder().setBillingAccount(billingAccount).setLocation(location).build();
    }

    public static String format(String billingAccount, String location) {
        return BillingAccountLocationName.newBuilder().setBillingAccount(billingAccount).setLocation(location).build().toString();
    }

    public static BillingAccountLocationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "BillingAccountLocationName.parse: formattedString not in valid format");
        return BillingAccountLocationName.of((String)matchMap.get("billing_account"), (String)matchMap.get("location"));
    }

    public static List<BillingAccountLocationName> parseList(List<String> formattedStrings) {
        ArrayList<BillingAccountLocationName> list = new ArrayList<BillingAccountLocationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BillingAccountLocationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BillingAccountLocationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BillingAccountLocationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BillingAccountLocationName billingAccountLocationName = this;
            synchronized (billingAccountLocationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"billingAccount", (Object)this.billingAccount);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"billing_account", this.billingAccount, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BillingAccountLocationName) {
            BillingAccountLocationName that = (BillingAccountLocationName)o;
            return this.billingAccount.equals(that.billingAccount) && this.location.equals(that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.billingAccount.hashCode();
        h *= 1000003;
        return h ^= this.location.hashCode();
    }

    public static class Builder {
        private String billingAccount;
        private String location;

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder() {
        }

        private Builder(BillingAccountLocationName billingAccountLocationName) {
            this.billingAccount = billingAccountLocationName.billingAccount;
            this.location = billingAccountLocationName.location;
        }

        public BillingAccountLocationName build() {
            return new BillingAccountLocationName(this);
        }
    }
}

