package com.cybelia.sandra.migration;

import com.cybelia.sandra.SandraDAOHelper;
import java.util.List;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

/**
 * Migration callback by class for all sandra database migration.
 *
 * @author sletellier
 */
public class SandraMigrationCallback extends TopiaMigrationCallbackByClass {

    public static final Version VERSION_10 = new Version("1.0");
    public static final Version VERSION_13 = new Version("1.3");
    public static final Version VERSION_14 = new Version("1.4");
    public static final Version VERSION_15 = new Version("1.5");
    public static final Version VERSION_16 = new Version("1.6");
    public static final Version VERSION_20 = new Version("2.0");

    public SandraMigrationCallback() {
        super(new MigrationResolver());
    }

    protected static class MigrationResolver implements MigrationCallBackForVersionResolver {
        /*
         * @see org.nuiton.topia.migration.TopiaMigrationCallbackByClass.MigrationCallBackForVersionResolver#getCallBack(org.nuiton.util.Version)
         */
        @Override
        public Class<? extends MigrationCallBackForVersion> getCallBack(Version version) {
            Class<? extends MigrationCallBackForVersion> result = null;

            if (version.equals(VERSION_10)) {
                result = MigrationV0V10.class;
            }
            if (version.equals(VERSION_13)) {
                result = MigrationV10V13.class;
            }
            if (version.equals(VERSION_14)) {
                result = MigrationV13V14.class;
            }
            if (version.equals(VERSION_15)) {
                result = MigrationV14V15.class;
            }
            if (version.equals(VERSION_16)) {
                result = MigrationV15V16.class;
            }
            if (version.equals(VERSION_20)) {
                result = MigrationV16V20.class;
            }
            return result;
        }
    }

    @Override
    public Version[] getAvailableVersions() {
        return new Version[]{VERSION_10, VERSION_13, VERSION_14, VERSION_15, VERSION_16, VERSION_20};
    }

    @Override
    public Version getApplicationVersion() {
        Version appVersion = new Version(SandraDAOHelper.getModelVersion());
        return appVersion;
    }

    @Override
    public boolean askUser(Version dbVersion, List<Version> versions) {
        return true;
    }
}
