package com.cybelia.sandra.migration;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TopiaMigrationCallbackByClass;
import org.nuiton.util.Version;

/**
 * @author sletellier <letellier@codelutin.com>
 */
public class MigrationV16V20 extends TopiaMigrationCallbackByClass.MigrationCallBackForVersion {

    public MigrationV16V20(Version version, TopiaMigrationCallbackByClass callBack) {
        super(version, callBack);
    }

    @Override
    protected void prepareMigrationScript(TopiaContextImplementor tx, List<String> queries, boolean showSql, boolean showProgression) throws TopiaException {
        InputStream migrationScript = MigrationV16V20.class.getResourceAsStream("/migration/migrationV16V20.sql");
        try {
            List<String> sqlLines = IOUtils.readLines(migrationScript);
            queries.add(StringUtils.join(sqlLines, "\n"));
        } catch (IOException eee) {
            throw new TopiaException("Failed to read migration script 'migrationV16V20.sql'", eee);
        }
    }
}
