package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.entities.InfoChargement;
import com.cybelia.sandra.entities.InfoChargementDAO;
import com.cybelia.sandra.ibu.ModifsCollector;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import org.nuiton.topia.TopiaException;

public class InjectorInfoChargement implements Injector {

    protected InfoChargement infoChargement;
    private boolean infoChargementChanged;

    public InfoChargement getObject() {
        return infoChargement;
    }

    public boolean isInfoChargementChanged() {
        return infoChargementChanged;
    }

    public void clear() {
        infoChargement = null;
        infoChargementChanged = false;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        InfoChargementDAO chargementDAO = SandraDAOHelper.getInfoChargementDAO(manager.getTransaction());

        // Recherche
        infoChargement = manager.getLigneProduit().getInfoChargement();

        // Création
        if (infoChargement == null) {
            infoChargement = chargementDAO.create();
            manager.getLigneProduit().setInfoChargement(infoChargement);

            infoChargementChanged = true;
        }

        if (!infoChargementChanged) {
            // Check changed
            ModifsCollector modifsCollector = new ModifsCollector();
            modifsCollector.add(InfoChargement.class, InfoChargement.PROPERTY_DATE,  infoChargement.getDate(), ibu.getChargementDate());
            modifsCollector.add(InfoChargement.class, InfoChargement.PROPERTY_COMPARTIMENTS,  infoChargement.getCompartiments(), ibu.getChargementCompartiments());
            modifsCollector.add(InfoChargement.class, InfoChargement.PROPERTY_QUANTITE,  infoChargement.getQuantite(), ibu.getProduitQuantiteLivree());

            if (modifsCollector.isModified()){
                infoChargementChanged = true;
            }
        }

        infoChargement.setNotifier(infoChargementChanged);

        // Mise à jour
        infoChargement.setDate(ibu.getChargementDate());
        infoChargement.setCompartiments(ibu.getChargementCompartiments());
        infoChargement.setQuantite(ibu.getProduitQuantiteLivree());
    }
}
