package com.cybelia.sandra.ibu.injector;

import com.cybelia.sandra.SandraDAOHelper;
import com.cybelia.sandra.SandraHelper;
import com.cybelia.sandra.entities.Camion;
import com.cybelia.sandra.entities.CamionDAO;
import com.cybelia.sandra.entities.Societe;
import com.cybelia.sandra.entities.SocieteDAO;
import com.cybelia.sandra.entities.UserIndicateurs;
import com.cybelia.sandra.entities.UserIndicateursDAO;
import com.cybelia.sandra.ibu.csv.bean.Ibu;
import com.cybelia.sandra.ibu.csv.bean.IbuCamion;
import com.cybelia.sandra.ibu.manager.Injector;
import com.cybelia.sandra.ibu.manager.ManagerInjector;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaSecurityDAOHelper;
import org.nuiton.topia.taas.entities.TaasPrincipal;
import org.nuiton.topia.taas.entities.TaasPrincipalDAO;
import org.nuiton.topia.taas.entities.TaasUser;
import org.nuiton.topia.taas.entities.TaasUserDAO;

public class InjectorCamion implements Injector {

    private final Log log = LogFactory.getLog(InjectorCamion.class);

    protected Camion camion;

    public Camion getObject() {
        return camion;
    }

    public void clear() {
        camion = null;
    }

    public void inject(ManagerInjector manager, Ibu ibu) throws TopiaException {
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(manager
                .getTransaction());

        // Recherche
        String camionCodeSociete = ibu.getCamionCodeSociete();
        
        if (StringUtils.isNotEmpty(camionCodeSociete)) {
            String[] splited = camionCodeSociete.split("-");
            if (splited.length == 2) {

                SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(manager.getTransaction());
                String codeSociete = splited[0];
                String codeCamion = splited[1];
                Societe societe = societeDAO.findByCode(codeSociete);

                camion = camionDAO.findByNaturalId(codeCamion,
                                                   societe);
            }
        }
        if (camion == null) {
            String camionCode = ibu.getCamionCode();
            camion = camionDAO.findByNaturalId(camionCode,
                                               manager.getSociete());

        }
        if (camion == null) {
            camion = camionDAO.findByNaturalId("GUI",
                                               manager.getSociete());
        }
    }

    public void inject(ManagerInjector manager, IbuCamion ibuCamion)
            throws TopiaException {
        TopiaContext transaction = manager
                .getTransaction();
        CamionDAO camionDAO = SandraDAOHelper.getCamionDAO(transaction);
        SocieteDAO societeDAO = SandraDAOHelper.getSocieteDAO(transaction);

        // Recherche
        Societe societe = manager.getSociete();
        camion = camionDAO.findByNaturalId(ibuCamion.getCode(),
                                           societe);

        // Création
        if (camion == null) {
            camion = camionDAO.createByNaturalId(ibuCamion.getCode(), societe);

            // Create also taas user
            TaasUserDAO taasUserDAO = TopiaSecurityDAOHelper.getTaasUserDAO(transaction);
            TaasUser taasUser = taasUserDAO.create();
            taasUser.setLogin(societe.getCode() + "-" + camion.getCode());
            taasUser.setLink(societe.getTopiaId());
            taasUser.setEnabled(true);

            // Create synchro permission
            TaasPrincipalDAO taasPrincipalDAO = TopiaSecurityDAOHelper.getTaasPrincipalDAO(transaction);
            TaasPrincipal synchroPrincipal = taasPrincipalDAO.findByName("synchro");

            TaasPrincipal taasPrincipal = taasPrincipalDAO.create();
            taasPrincipal.setName(societe.getCode() + "-" + camion.getCode());
            taasPrincipalDAO.update(taasPrincipal);

            taasUser.addPrincipals(taasPrincipal);
            taasUser.addPrincipals(synchroPrincipal);

            taasUser = taasUserDAO.update(taasUser);

            // Create user indicator
            UserIndicateursDAO userIndicateursDAO = SandraDAOHelper.getUserIndicateursDAO(transaction);
            UserIndicateurs userIndicateurs = userIndicateursDAO.createByNaturalId(taasUser);
            userIndicateurs = SandraHelper.razUserIndicateurs(userIndicateurs);

            camion.setUserIndicateurs(userIndicateurs);
            camion.setActif(true);
        }

        // Mise à jour
        camion.setNombreCompartiments(ibuCamion.getNbCompartiment());
        camion.setTransporteur(manager.getTransporteur());

        // Camion associé
        String codePrincipal = ibuCamion.getCodePrincipal();
        if (StringUtils.isNotEmpty(codePrincipal)) {

            Societe societeAssocie = societeDAO.findByCode(codePrincipal.substring(0, 1));

            Camion principal = camionDAO.findByNaturalId(codePrincipal.substring(2),
                                                         societeAssocie);

            List<Camion> camionsAssocies = principal.getCamionsAssocies();
            if (camionsAssocies == null) {
                camionsAssocies = new ArrayList<Camion>();
                principal.setCamionsAssocies(camionsAssocies);
            }

            if (!camionsAssocies.contains(camion)) {
                camionsAssocies.add(camion);
            }
        }
    }
}
