/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.reflect;

import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.Wrapper;
import com.google.common.base.Predicate;
import java.util.Map;

public class MapGuard
implements Predicate<Object[]> {
    private final ObjectHandler oh;
    private final int scopeIndex;
    private final String name;
    private final boolean contains;
    private final Wrapper[] wrappers;

    public MapGuard(ObjectHandler oh, int scopeIndex, String name, boolean contains, Wrapper[] wrappers) {
        this.oh = oh;
        this.scopeIndex = scopeIndex;
        this.name = name;
        this.contains = contains;
        this.wrappers = wrappers;
    }

    public boolean apply(Object[] objects) {
        Object scope = ReflectionObjectHandler.unwrap(this.oh, this.scopeIndex, this.wrappers, objects);
        if (scope instanceof Map) {
            Map map = (Map)scope;
            if (this.contains) {
                return map.containsKey(this.name);
            }
            return !map.containsKey(this.name);
        }
        return true;
    }
}

