/*
 * Decompiled with CFR 0.152.
 */
package org.got5.tapestry5.jquery.components;

import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.OnEvent;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.PartialMarkupRenderer;
import org.apache.tapestry5.services.PartialMarkupRendererFilter;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ajax.AjaxResponseRenderer;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.apache.tapestry5.upload.services.MultipartDecoder;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.apache.tapestry5.util.TextStreamResponse;
import org.got5.tapestry5.jquery.base.AbstractExtendableComponent;
import org.got5.tapestry5.jquery.components.Dialog;
import org.got5.tapestry5.jquery.services.AjaxUploadDecoder;
import org.got5.tapestry5.jquery.utils.JQueryUtils;

@Import(stack={"AjaxUploadStack"})
public class AjaxUpload
extends AbstractExtendableComponent {
    public static final String UPDATE_ZONE_CALLBACK = "updateZone";
    private static final String[] UNITS = new String[]{"K", "M", "G"};
    @Parameter(value="false")
    private boolean multiple;
    @Parameter(defaultPrefix="literal")
    private String allowedExtensions;
    @Parameter(defaultPrefix="literal", value="0")
    private String sizeLimit;
    @Parameter(value="3")
    private int maxConnections;
    @Parameter
    private JSONObject params;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    @Inject
    private ComponentResources resources;
    @Inject
    private MultipartDecoder multipartDecoder;
    @Inject
    private AjaxUploadDecoder ajaxDecoder;
    @Inject
    private Request request;
    @Inject
    private Messages messages;
    @InjectComponent
    private Dialog uploadErrorMesages;
    @Inject
    private AjaxResponseRenderer ajaxResponseRenderer;

    @SetupRender
    void setup() {
        this.setDefaultMethod("uploadable");
    }

    void afterRender() {
        if (this.params == null) {
            this.params = new JSONObject();
        }
        JSONObject uploadMessages = new JSONObject().put("typeError", (Object)this.messages.get("typeError")).put("sizeError", (Object)this.messages.get("sizeError")).put("minSizeError", (Object)this.messages.get("minSizeError")).put("emptyError", (Object)this.messages.get("emptyError")).put("onLeave", (Object)this.messages.get("onLeave")).put("uploadLabel", (Object)this.messages.get("upload-label")).put("dropAreaLabel", (Object)this.messages.get("dropArea-label")).put("cancelLabel", (Object)this.messages.get("cancel-label")).put("failedLabel", (Object)this.messages.get("failed-label"));
        long sizeLimit = this.calculateSizeLimit();
        JSONObject parameter = new JSONObject().put("elementId", (Object)this.getClientId()).put("action", (Object)this.resources.createEventLink("upload", new Object[0]).toURI()).put("showMessagesDialog", (Object)this.uploadErrorMesages.getClientId()).put("messages", (Object)uploadMessages).put("multiple", (Object)this.multiple).put("sizeLimit", (Object)sizeLimit).put("maxConnections", (Object)this.maxConnections);
        if (this.allowedExtensions != null) {
            parameter.put("allowedExtensions", (Object)new JSONArray(this.allowedExtensions));
        }
        JQueryUtils.merge(parameter, this.params);
        this.javaScriptSupport.addInitializerCall(this.getInitMethod(), parameter);
    }

    private long calculateSizeLimit() {
        if (this.sizeLimit.matches("^[\\d]+$")) {
            return Long.valueOf(this.sizeLimit);
        }
        double size = Double.valueOf(this.sizeLimit.substring(0, this.sizeLimit.length() - 1));
        for (int i = 0; i < UNITS.length; ++i) {
            size *= 1024.0;
            if (!this.sizeLimit.endsWith(UNITS[i])) continue;
            return (long)size;
        }
        return 0L;
    }

    private UploadedFile getUploadedFile() {
        if (this.ajaxDecoder.isAjaxUploadRequest(this.request)) {
            return this.ajaxDecoder.getFileUpload();
        }
        return this.multipartDecoder.getFileUpload("qqfile");
    }

    @OnEvent(value="upload")
    Object onUpload() {
        boolean success;
        UploadedFile uploaded = this.getUploadedFile();
        if (uploaded != null && StringUtils.isEmpty((String)uploaded.getFileName())) {
            uploaded = null;
        }
        final Holder holder = Holder.create();
        ComponentEventCallback<Object> callback = new ComponentEventCallback<Object>(){

            public boolean handleResult(Object result) {
                holder.put(result);
                return true;
            }
        };
        boolean bl = success = uploaded != null;
        if (!this.ajaxDecoder.isAjaxUploadRequest(this.request)) {
            this.resources.triggerEvent("fileUpload", new Object[]{uploaded}, (ComponentEventCallback)callback);
            return this.processNonXHRResult(success, holder.get());
        }
        this.resources.triggerEvent("ajaxFileUpload", new Object[]{uploaded}, (ComponentEventCallback)callback);
        return this.processXHRResult(success, holder.get());
    }

    private Object processXHRResult(boolean success, Object triggerResult) {
        final JSONObject result = new JSONObject().put("success", (Object)success);
        if (triggerResult != null && triggerResult instanceof JSONObject) {
            JQueryUtils.merge(result, (JSONObject)triggerResult);
            return result;
        }
        this.ajaxResponseRenderer.addFilter(new PartialMarkupRendererFilter(){

            public void renderMarkup(MarkupWriter writer, JSONObject reply, PartialMarkupRenderer renderer) {
                renderer.renderMarkup(writer, reply);
                JQueryUtils.merge(reply, result);
            }
        });
        return triggerResult;
    }

    private Object processNonXHRResult(boolean success, Object triggerResult) {
        JSONObject result = new JSONObject().put("success", (Object)success);
        if (triggerResult != null && triggerResult instanceof JSONObject) {
            JQueryUtils.merge(result, (JSONObject)triggerResult);
        }
        return new TextStreamResponse("text/html", result.toCompactString());
    }
}

