package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 - 2015 Mac-Groupe, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Generated;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityVisitor;
import org.nuiton.topia.persistence.TopiaException;
import org.nuiton.topia.persistence.internal.AbstractTopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

@Generated(value = "org.nuiton.topia.templates.EntityTransformer", date = "Wed Sep 02 16:18:28 CEST 2015")
public abstract class MailFolderAbstract extends AbstractTopiaEntity implements MailFolder {

    /**
     * Nom de l'attribut en BD : name
     */
    protected String name;

    /**
     * Nom de l'attribut en BD : ediTransfer
     */
    protected Boolean ediTransfer;

    /**
     * Nom de l'attribut en BD : allowCreateDemandIntoFolder
     */
    protected Boolean allowCreateDemandIntoFolder;

    /**
     * Nom de l'attribut en BD : allowMoveDemandIntoFolder
     */
    protected Boolean allowMoveDemandIntoFolder;

    /**
     * Nom de l'attribut en BD : rejectUnknownSender
     */
    protected Boolean rejectUnknownSender;

    /**
     * Nom de l'attribut en BD : rejectResponseMailAddress
     */
    protected String rejectResponseMailAddress;

    /**
     * Nom de l'attribut en BD : rejectResponseMessage
     */
    protected String rejectResponseMessage;

    /**
     * Nom de l'attribut en BD : replyAddresses
     */
    protected Collection<String> replyAddresses;

    /**
     * Nom de l'attribut en BD : replyDomains
     */
    protected Collection<String> replyDomains;

    /**
     * Nom de l'attribut en BD : openAttachmentReportNoTaken
     */
    protected Boolean openAttachmentReportNoTaken;

    /**
     * Nom de l'attribut en BD : printActionEqualTakeAction
     */
    protected Boolean printActionEqualTakeAction;

    /**
     * Nom de l'attribut en BD : ediFolder
     */
    protected String ediFolder;

    /**
     * Nom de l'attribut en BD : faxDomain
     */
    protected String faxDomain;

    /**
     * Nom de l'attribut en BD : useCurrentLevelWaitingState
     */
    protected boolean useCurrentLevelWaitingState;

    /**
     * Nom de l'attribut en BD : useCurrentLevelTableColumns
     */
    protected boolean useCurrentLevelTableColumns;

    /**
     * Nom de l'attribut en BD : useCurrentLevelFaxDomain
     */
    protected boolean useCurrentLevelFaxDomain;

    /**
     * Nom de l'attribut en BD : useCurrentLevelEdiFolder
     */
    protected boolean useCurrentLevelEdiFolder;

    /**
     * Nom de l'attribut en BD : useCurrentLevelRejectResponseMailAddress
     */
    protected boolean useCurrentLevelRejectResponseMailAddress;

    /**
     * Nom de l'attribut en BD : useCurrentLevelRejectResponseMessage
     */
    protected boolean useCurrentLevelRejectResponseMessage;

    /**
     * Nom de l'attribut en BD : useCurrentLevelDemandType
     */
    protected boolean useCurrentLevelDemandType;

    /**
     * Nom de l'attribut en BD : useCurrentLevelRange
     */
    protected boolean useCurrentLevelRange;

    /**
     * Nom de l'attribut en BD : archiveFolder
     */
    protected boolean archiveFolder;

    /**
     * Nom de l'attribut en BD : folderTableColumns
     */
    protected List<MailField> folderTableColumns;

    /**
     * Nom de l'attribut en BD : company
     */
    protected String company;

    /**
     * Nom de l'attribut en BD : useCurrentLevelCompany
     */
    protected boolean useCurrentLevelCompany;

    /**
     * Nom de l'attribut en BD : waitingStates
     */
    protected Collection<WaitingState> waitingStates;

    /**
     * Nom de l'attribut en BD : children
     */
    protected Collection<MailFolder> children;

    /**
     * Nom de l'attribut en BD : parent
     */
    protected MailFolder parent;

    /**
     * Nom de l'attribut en BD : customerResponsibles
     */
    protected Collection<FaxToMailUser> customerResponsibles;

    /**
     * Nom de l'attribut en BD : readRightUsers
     */
    protected Collection<FaxToMailUser> readRightUsers;

    /**
     * Nom de l'attribut en BD : moveRightUsers
     */
    protected Collection<FaxToMailUser> moveRightUsers;

    /**
     * Nom de l'attribut en BD : writeRightGroups
     */
    protected Collection<FaxToMailUserGroup> writeRightGroups;

    /**
     * Nom de l'attribut en BD : moveRightGroups
     */
    protected Collection<FaxToMailUserGroup> moveRightGroups;

    /**
     * Nom de l'attribut en BD : readRightGroups
     */
    protected Collection<FaxToMailUserGroup> readRightGroups;

    /**
     * Nom de l'attribut en BD : demandTypes
     */
    protected Collection<DemandType> demandTypes;

    /**
     * Nom de l'attribut en BD : ranges
     */
    protected Collection<Range> ranges;

    /**
     * Nom de l'attribut en BD : writeRightUsers
     */
    protected Collection<FaxToMailUser> writeRightUsers;

    private static final long serialVersionUID = 3688556281690863664L;

    @Override
    public void accept(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        accept0(visitor);
        visitor.end(this);
    }

    protected void accept0(TopiaEntityVisitor visitor) throws TopiaException {
        visitor.visit(this, PROPERTY_NAME, String.class, name);
        visitor.visit(this, PROPERTY_EDI_TRANSFER, Boolean.class, ediTransfer);
        visitor.visit(this, PROPERTY_ALLOW_CREATE_DEMAND_INTO_FOLDER, Boolean.class, allowCreateDemandIntoFolder);
        visitor.visit(this, PROPERTY_ALLOW_MOVE_DEMAND_INTO_FOLDER, Boolean.class, allowMoveDemandIntoFolder);
        visitor.visit(this, PROPERTY_REJECT_UNKNOWN_SENDER, Boolean.class, rejectUnknownSender);
        visitor.visit(this, PROPERTY_REJECT_RESPONSE_MAIL_ADDRESS, String.class, rejectResponseMailAddress);
        visitor.visit(this, PROPERTY_REJECT_RESPONSE_MESSAGE, String.class, rejectResponseMessage);
        visitor.visit(this, PROPERTY_REPLY_ADDRESSES, Collection.class, String.class, replyAddresses);
        visitor.visit(this, PROPERTY_REPLY_DOMAINS, Collection.class, String.class, replyDomains);
        visitor.visit(this, PROPERTY_OPEN_ATTACHMENT_REPORT_NO_TAKEN, Boolean.class, openAttachmentReportNoTaken);
        visitor.visit(this, PROPERTY_PRINT_ACTION_EQUAL_TAKE_ACTION, Boolean.class, printActionEqualTakeAction);
        visitor.visit(this, PROPERTY_EDI_FOLDER, String.class, ediFolder);
        visitor.visit(this, PROPERTY_FAX_DOMAIN, String.class, faxDomain);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_WAITING_STATE, boolean.class, useCurrentLevelWaitingState);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_TABLE_COLUMNS, boolean.class, useCurrentLevelTableColumns);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_FAX_DOMAIN, boolean.class, useCurrentLevelFaxDomain);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_EDI_FOLDER, boolean.class, useCurrentLevelEdiFolder);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_REJECT_RESPONSE_MAIL_ADDRESS, boolean.class, useCurrentLevelRejectResponseMailAddress);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_REJECT_RESPONSE_MESSAGE, boolean.class, useCurrentLevelRejectResponseMessage);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_DEMAND_TYPE, boolean.class, useCurrentLevelDemandType);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_RANGE, boolean.class, useCurrentLevelRange);
        visitor.visit(this, PROPERTY_ARCHIVE_FOLDER, boolean.class, archiveFolder);
        visitor.visit(this, PROPERTY_FOLDER_TABLE_COLUMNS, List.class, folderTableColumns);
        visitor.visit(this, PROPERTY_COMPANY, String.class, company);
        visitor.visit(this, PROPERTY_USE_CURRENT_LEVEL_COMPANY, boolean.class, useCurrentLevelCompany);
        visitor.visit(this, PROPERTY_WAITING_STATES, Collection.class, WaitingState.class, waitingStates);
        visitor.visit(this, PROPERTY_CHILDREN, Collection.class, MailFolder.class, children);
        visitor.visit(this, PROPERTY_PARENT, MailFolder.class, parent);
        visitor.visit(this, PROPERTY_CUSTOMER_RESPONSIBLES, Collection.class, FaxToMailUser.class, customerResponsibles);
        visitor.visit(this, PROPERTY_READ_RIGHT_USERS, Collection.class, FaxToMailUser.class, readRightUsers);
        visitor.visit(this, PROPERTY_MOVE_RIGHT_USERS, Collection.class, FaxToMailUser.class, moveRightUsers);
        visitor.visit(this, PROPERTY_WRITE_RIGHT_GROUPS, Collection.class, FaxToMailUserGroup.class, writeRightGroups);
        visitor.visit(this, PROPERTY_MOVE_RIGHT_GROUPS, Collection.class, FaxToMailUserGroup.class, moveRightGroups);
        visitor.visit(this, PROPERTY_READ_RIGHT_GROUPS, Collection.class, FaxToMailUserGroup.class, readRightGroups);
        visitor.visit(this, PROPERTY_DEMAND_TYPES, Collection.class, DemandType.class, demandTypes);
        visitor.visit(this, PROPERTY_RANGES, Collection.class, Range.class, ranges);
        visitor.visit(this, PROPERTY_WRITE_RIGHT_USERS, Collection.class, FaxToMailUser.class, writeRightUsers);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        String result = this.name;
        return result;
    }

    @Override
    public void setEdiTransfer(Boolean ediTransfer) {
        this.ediTransfer = ediTransfer;
    }

    @Override
    public Boolean getEdiTransfer() {
        Boolean result = this.ediTransfer;
        return result;
    }

    @Override
    public void setAllowCreateDemandIntoFolder(Boolean allowCreateDemandIntoFolder) {
        this.allowCreateDemandIntoFolder = allowCreateDemandIntoFolder;
    }

    @Override
    public Boolean getAllowCreateDemandIntoFolder() {
        Boolean result = this.allowCreateDemandIntoFolder;
        return result;
    }

    @Override
    public void setAllowMoveDemandIntoFolder(Boolean allowMoveDemandIntoFolder) {
        this.allowMoveDemandIntoFolder = allowMoveDemandIntoFolder;
    }

    @Override
    public Boolean getAllowMoveDemandIntoFolder() {
        Boolean result = this.allowMoveDemandIntoFolder;
        return result;
    }

    @Override
    public void setRejectUnknownSender(Boolean rejectUnknownSender) {
        this.rejectUnknownSender = rejectUnknownSender;
    }

    @Override
    public Boolean getRejectUnknownSender() {
        Boolean result = this.rejectUnknownSender;
        return result;
    }

    @Override
    public void setRejectResponseMailAddress(String rejectResponseMailAddress) {
        this.rejectResponseMailAddress = rejectResponseMailAddress;
    }

    @Override
    public String getRejectResponseMailAddress() {
        String result = this.rejectResponseMailAddress;
        return result;
    }

    @Override
    public void setRejectResponseMessage(String rejectResponseMessage) {
        this.rejectResponseMessage = rejectResponseMessage;
    }

    @Override
    public String getRejectResponseMessage() {
        String result = this.rejectResponseMessage;
        return result;
    }

    @Override
    public void addReplyAddresses(String replyAddresses) {
        if (this.replyAddresses == null) {
            this.replyAddresses = new LinkedList<String>();
        }
        this.replyAddresses.add(replyAddresses);
    }

    @Override
    public void addAllReplyAddresses(Collection<String> replyAddresses) {
        if (replyAddresses == null) {
            return;
        }
        for (String item : replyAddresses) {
            addReplyAddresses(item);
        }
    }

    @Override
    public void setReplyAddresses(Collection<String> replyAddresses) {
        this.replyAddresses = replyAddresses;
    }

    @Override
    public void removeReplyAddresses(String replyAddresses) {
        if (this.replyAddresses == null || !this.replyAddresses.remove(replyAddresses)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearReplyAddresses() {
        if (this.replyAddresses == null) {
            return;
        }
        this.replyAddresses.clear();
    }

    @Override
    public Collection<String> getReplyAddresses() {
        return replyAddresses;
    }

    @Override
    public int sizeReplyAddresses() {
        if (replyAddresses == null) {
            return 0;
        }
        return replyAddresses.size();
    }

    @Override
    public boolean isReplyAddressesEmpty() {
        int size = sizeReplyAddresses();
        return size == 0;
    }

    @Override
    public boolean isReplyAddressesNotEmpty() {
        boolean empty = isReplyAddressesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReplyAddresses(String replyAddresses) {
        boolean contains = this.replyAddresses !=null && this.replyAddresses.contains(replyAddresses);
        return contains;
    }

    @Override
    public void addReplyDomains(String replyDomains) {
        if (this.replyDomains == null) {
            this.replyDomains = new LinkedList<String>();
        }
        this.replyDomains.add(replyDomains);
    }

    @Override
    public void addAllReplyDomains(Collection<String> replyDomains) {
        if (replyDomains == null) {
            return;
        }
        for (String item : replyDomains) {
            addReplyDomains(item);
        }
    }

    @Override
    public void setReplyDomains(Collection<String> replyDomains) {
        this.replyDomains = replyDomains;
    }

    @Override
    public void removeReplyDomains(String replyDomains) {
        if (this.replyDomains == null || !this.replyDomains.remove(replyDomains)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearReplyDomains() {
        if (this.replyDomains == null) {
            return;
        }
        this.replyDomains.clear();
    }

    @Override
    public Collection<String> getReplyDomains() {
        return replyDomains;
    }

    @Override
    public int sizeReplyDomains() {
        if (replyDomains == null) {
            return 0;
        }
        return replyDomains.size();
    }

    @Override
    public boolean isReplyDomainsEmpty() {
        int size = sizeReplyDomains();
        return size == 0;
    }

    @Override
    public boolean isReplyDomainsNotEmpty() {
        boolean empty = isReplyDomainsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReplyDomains(String replyDomains) {
        boolean contains = this.replyDomains !=null && this.replyDomains.contains(replyDomains);
        return contains;
    }

    @Override
    public void setOpenAttachmentReportNoTaken(Boolean openAttachmentReportNoTaken) {
        this.openAttachmentReportNoTaken = openAttachmentReportNoTaken;
    }

    @Override
    public Boolean getOpenAttachmentReportNoTaken() {
        Boolean result = this.openAttachmentReportNoTaken;
        return result;
    }

    @Override
    public void setPrintActionEqualTakeAction(Boolean printActionEqualTakeAction) {
        this.printActionEqualTakeAction = printActionEqualTakeAction;
    }

    @Override
    public Boolean getPrintActionEqualTakeAction() {
        Boolean result = this.printActionEqualTakeAction;
        return result;
    }

    @Override
    public void setEdiFolder(String ediFolder) {
        this.ediFolder = ediFolder;
    }

    @Override
    public String getEdiFolder() {
        String result = this.ediFolder;
        return result;
    }

    @Override
    public void setFaxDomain(String faxDomain) {
        this.faxDomain = faxDomain;
    }

    @Override
    public String getFaxDomain() {
        String result = this.faxDomain;
        return result;
    }

    @Override
    public void setUseCurrentLevelWaitingState(boolean useCurrentLevelWaitingState) {
        this.useCurrentLevelWaitingState = useCurrentLevelWaitingState;
    }

    @Override
    public boolean isUseCurrentLevelWaitingState() {
        boolean result = this.useCurrentLevelWaitingState;
        return result;
    }

    @Override
    public void setUseCurrentLevelTableColumns(boolean useCurrentLevelTableColumns) {
        this.useCurrentLevelTableColumns = useCurrentLevelTableColumns;
    }

    @Override
    public boolean isUseCurrentLevelTableColumns() {
        boolean result = this.useCurrentLevelTableColumns;
        return result;
    }

    @Override
    public void setUseCurrentLevelFaxDomain(boolean useCurrentLevelFaxDomain) {
        this.useCurrentLevelFaxDomain = useCurrentLevelFaxDomain;
    }

    @Override
    public boolean isUseCurrentLevelFaxDomain() {
        boolean result = this.useCurrentLevelFaxDomain;
        return result;
    }

    @Override
    public void setUseCurrentLevelEdiFolder(boolean useCurrentLevelEdiFolder) {
        this.useCurrentLevelEdiFolder = useCurrentLevelEdiFolder;
    }

    @Override
    public boolean isUseCurrentLevelEdiFolder() {
        boolean result = this.useCurrentLevelEdiFolder;
        return result;
    }

    @Override
    public void setUseCurrentLevelRejectResponseMailAddress(boolean useCurrentLevelRejectResponseMailAddress) {
        this.useCurrentLevelRejectResponseMailAddress = useCurrentLevelRejectResponseMailAddress;
    }

    @Override
    public boolean isUseCurrentLevelRejectResponseMailAddress() {
        boolean result = this.useCurrentLevelRejectResponseMailAddress;
        return result;
    }

    @Override
    public void setUseCurrentLevelRejectResponseMessage(boolean useCurrentLevelRejectResponseMessage) {
        this.useCurrentLevelRejectResponseMessage = useCurrentLevelRejectResponseMessage;
    }

    @Override
    public boolean isUseCurrentLevelRejectResponseMessage() {
        boolean result = this.useCurrentLevelRejectResponseMessage;
        return result;
    }

    @Override
    public void setUseCurrentLevelDemandType(boolean useCurrentLevelDemandType) {
        this.useCurrentLevelDemandType = useCurrentLevelDemandType;
    }

    @Override
    public boolean isUseCurrentLevelDemandType() {
        boolean result = this.useCurrentLevelDemandType;
        return result;
    }

    @Override
    public void setUseCurrentLevelRange(boolean useCurrentLevelRange) {
        this.useCurrentLevelRange = useCurrentLevelRange;
    }

    @Override
    public boolean isUseCurrentLevelRange() {
        boolean result = this.useCurrentLevelRange;
        return result;
    }

    @Override
    public void setArchiveFolder(boolean archiveFolder) {
        this.archiveFolder = archiveFolder;
    }

    @Override
    public boolean isArchiveFolder() {
        boolean result = this.archiveFolder;
        return result;
    }

    @Override
    public void setFolderTableColumns(List<MailField> folderTableColumns) {
        this.folderTableColumns = folderTableColumns;
    }

    @Override
    public List<MailField> getFolderTableColumns() {
        List<MailField> result = this.folderTableColumns;
        return result;
    }

    @Override
    public void setCompany(String company) {
        this.company = company;
    }

    @Override
    public String getCompany() {
        String result = this.company;
        return result;
    }

    @Override
    public void setUseCurrentLevelCompany(boolean useCurrentLevelCompany) {
        this.useCurrentLevelCompany = useCurrentLevelCompany;
    }

    @Override
    public boolean isUseCurrentLevelCompany() {
        boolean result = this.useCurrentLevelCompany;
        return result;
    }

    @Override
    public void addWaitingStates(WaitingState waitingStates) {
        if (this.waitingStates == null) {
            this.waitingStates = new LinkedList<WaitingState>();
        }
        this.waitingStates.add(waitingStates);
    }

    @Override
    public void addAllWaitingStates(Collection<WaitingState> waitingStates) {
        if (waitingStates == null) {
            return;
        }
        for (WaitingState item : waitingStates) {
            addWaitingStates(item);
        }
    }

    @Override
    public void setWaitingStates(Collection<WaitingState> waitingStates) {
        this.waitingStates = waitingStates;
    }

    @Override
    public void removeWaitingStates(WaitingState waitingStates) {
        if (this.waitingStates == null || !this.waitingStates.remove(waitingStates)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearWaitingStates() {
        if (this.waitingStates == null) {
            return;
        }
        this.waitingStates.clear();
    }

    @Override
    public Collection<WaitingState> getWaitingStates() {
        return waitingStates;
    }

    @Override
    public WaitingState getWaitingStatesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(waitingStates, topiaId);
    }

    @Override
    public Collection<String> getWaitingStatesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.WaitingState> tmp = getWaitingStates();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeWaitingStates() {
        if (waitingStates == null) {
            return 0;
        }
        return waitingStates.size();
    }

    @Override
    public boolean isWaitingStatesEmpty() {
        int size = sizeWaitingStates();
        return size == 0;
    }

    @Override
    public boolean isWaitingStatesNotEmpty() {
        boolean empty = isWaitingStatesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsWaitingStates(WaitingState waitingStates) {
        boolean contains = this.waitingStates !=null && this.waitingStates.contains(waitingStates);
        return contains;
    }

    @Override
    public void addChildren(MailFolder children) {
        if (this.children == null) {
            this.children = new LinkedList<MailFolder>();
        }
        children.setParent(this);
        this.children.add(children);
    }

    @Override
    public void addAllChildren(Collection<MailFolder> children) {
        if (children == null) {
            return;
        }
        for (MailFolder item : children) {
            addChildren(item);
        }
    }

    @Override
    public void setChildren(Collection<MailFolder> children) {
        this.children = children;
    }

    @Override
    public void removeChildren(MailFolder children) {
        if (this.children == null || !this.children.remove(children)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        children.setParent(null);
    }

    @Override
    public void clearChildren() {
        if (this.children == null) {
            return;
        }
        for (MailFolder item : this.children) {
            item.setParent(null);
        }
        this.children.clear();
    }

    @Override
    public Collection<MailFolder> getChildren() {
        return children;
    }

    @Override
    public MailFolder getChildrenByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(children, topiaId);
    }

    @Override
    public Collection<String> getChildrenTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.MailFolder> tmp = getChildren();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeChildren() {
        if (children == null) {
            return 0;
        }
        return children.size();
    }

    @Override
    public boolean isChildrenEmpty() {
        int size = sizeChildren();
        return size == 0;
    }

    @Override
    public boolean isChildrenNotEmpty() {
        boolean empty = isChildrenEmpty();
        return ! empty;
    }

    @Override
    public boolean containsChildren(MailFolder children) {
        boolean contains = this.children !=null && this.children.contains(children);
        return contains;
    }

    @Override
    public void setParent(MailFolder parent) {
        this.parent = parent;
    }

    @Override
    public MailFolder getParent() {
        MailFolder result = this.parent;
        return result;
    }

    @Override
    public void addCustomerResponsibles(FaxToMailUser customerResponsibles) {
        if (this.customerResponsibles == null) {
            this.customerResponsibles = new LinkedList<FaxToMailUser>();
        }
        this.customerResponsibles.add(customerResponsibles);
    }

    @Override
    public void addAllCustomerResponsibles(Collection<FaxToMailUser> customerResponsibles) {
        if (customerResponsibles == null) {
            return;
        }
        for (FaxToMailUser item : customerResponsibles) {
            addCustomerResponsibles(item);
        }
    }

    @Override
    public void setCustomerResponsibles(Collection<FaxToMailUser> customerResponsibles) {
        this.customerResponsibles = customerResponsibles;
    }

    @Override
    public void removeCustomerResponsibles(FaxToMailUser customerResponsibles) {
        if (this.customerResponsibles == null || !this.customerResponsibles.remove(customerResponsibles)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearCustomerResponsibles() {
        if (this.customerResponsibles == null) {
            return;
        }
        this.customerResponsibles.clear();
    }

    @Override
    public Collection<FaxToMailUser> getCustomerResponsibles() {
        return customerResponsibles;
    }

    @Override
    public FaxToMailUser getCustomerResponsiblesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(customerResponsibles, topiaId);
    }

    @Override
    public Collection<String> getCustomerResponsiblesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getCustomerResponsibles();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeCustomerResponsibles() {
        if (customerResponsibles == null) {
            return 0;
        }
        return customerResponsibles.size();
    }

    @Override
    public boolean isCustomerResponsiblesEmpty() {
        int size = sizeCustomerResponsibles();
        return size == 0;
    }

    @Override
    public boolean isCustomerResponsiblesNotEmpty() {
        boolean empty = isCustomerResponsiblesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsCustomerResponsibles(FaxToMailUser customerResponsibles) {
        boolean contains = this.customerResponsibles !=null && this.customerResponsibles.contains(customerResponsibles);
        return contains;
    }

    @Override
    public void addReadRightUsers(FaxToMailUser readRightUsers) {
        if (this.readRightUsers == null) {
            this.readRightUsers = new LinkedList<FaxToMailUser>();
        }
        this.readRightUsers.add(readRightUsers);
    }

    @Override
    public void addAllReadRightUsers(Collection<FaxToMailUser> readRightUsers) {
        if (readRightUsers == null) {
            return;
        }
        for (FaxToMailUser item : readRightUsers) {
            addReadRightUsers(item);
        }
    }

    @Override
    public void setReadRightUsers(Collection<FaxToMailUser> readRightUsers) {
        this.readRightUsers = readRightUsers;
    }

    @Override
    public void removeReadRightUsers(FaxToMailUser readRightUsers) {
        if (this.readRightUsers == null || !this.readRightUsers.remove(readRightUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearReadRightUsers() {
        if (this.readRightUsers == null) {
            return;
        }
        this.readRightUsers.clear();
    }

    @Override
    public Collection<FaxToMailUser> getReadRightUsers() {
        return readRightUsers;
    }

    @Override
    public FaxToMailUser getReadRightUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(readRightUsers, topiaId);
    }

    @Override
    public Collection<String> getReadRightUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getReadRightUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeReadRightUsers() {
        if (readRightUsers == null) {
            return 0;
        }
        return readRightUsers.size();
    }

    @Override
    public boolean isReadRightUsersEmpty() {
        int size = sizeReadRightUsers();
        return size == 0;
    }

    @Override
    public boolean isReadRightUsersNotEmpty() {
        boolean empty = isReadRightUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReadRightUsers(FaxToMailUser readRightUsers) {
        boolean contains = this.readRightUsers !=null && this.readRightUsers.contains(readRightUsers);
        return contains;
    }

    @Override
    public void addMoveRightUsers(FaxToMailUser moveRightUsers) {
        if (this.moveRightUsers == null) {
            this.moveRightUsers = new LinkedList<FaxToMailUser>();
        }
        this.moveRightUsers.add(moveRightUsers);
    }

    @Override
    public void addAllMoveRightUsers(Collection<FaxToMailUser> moveRightUsers) {
        if (moveRightUsers == null) {
            return;
        }
        for (FaxToMailUser item : moveRightUsers) {
            addMoveRightUsers(item);
        }
    }

    @Override
    public void setMoveRightUsers(Collection<FaxToMailUser> moveRightUsers) {
        this.moveRightUsers = moveRightUsers;
    }

    @Override
    public void removeMoveRightUsers(FaxToMailUser moveRightUsers) {
        if (this.moveRightUsers == null || !this.moveRightUsers.remove(moveRightUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearMoveRightUsers() {
        if (this.moveRightUsers == null) {
            return;
        }
        this.moveRightUsers.clear();
    }

    @Override
    public Collection<FaxToMailUser> getMoveRightUsers() {
        return moveRightUsers;
    }

    @Override
    public FaxToMailUser getMoveRightUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(moveRightUsers, topiaId);
    }

    @Override
    public Collection<String> getMoveRightUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getMoveRightUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMoveRightUsers() {
        if (moveRightUsers == null) {
            return 0;
        }
        return moveRightUsers.size();
    }

    @Override
    public boolean isMoveRightUsersEmpty() {
        int size = sizeMoveRightUsers();
        return size == 0;
    }

    @Override
    public boolean isMoveRightUsersNotEmpty() {
        boolean empty = isMoveRightUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMoveRightUsers(FaxToMailUser moveRightUsers) {
        boolean contains = this.moveRightUsers !=null && this.moveRightUsers.contains(moveRightUsers);
        return contains;
    }

    @Override
    public void addWriteRightGroups(FaxToMailUserGroup writeRightGroups) {
        if (this.writeRightGroups == null) {
            this.writeRightGroups = new LinkedList<FaxToMailUserGroup>();
        }
        this.writeRightGroups.add(writeRightGroups);
    }

    @Override
    public void addAllWriteRightGroups(Collection<FaxToMailUserGroup> writeRightGroups) {
        if (writeRightGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : writeRightGroups) {
            addWriteRightGroups(item);
        }
    }

    @Override
    public void setWriteRightGroups(Collection<FaxToMailUserGroup> writeRightGroups) {
        this.writeRightGroups = writeRightGroups;
    }

    @Override
    public void removeWriteRightGroups(FaxToMailUserGroup writeRightGroups) {
        if (this.writeRightGroups == null || !this.writeRightGroups.remove(writeRightGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearWriteRightGroups() {
        if (this.writeRightGroups == null) {
            return;
        }
        this.writeRightGroups.clear();
    }

    @Override
    public Collection<FaxToMailUserGroup> getWriteRightGroups() {
        return writeRightGroups;
    }

    @Override
    public FaxToMailUserGroup getWriteRightGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(writeRightGroups, topiaId);
    }

    @Override
    public Collection<String> getWriteRightGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getWriteRightGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeWriteRightGroups() {
        if (writeRightGroups == null) {
            return 0;
        }
        return writeRightGroups.size();
    }

    @Override
    public boolean isWriteRightGroupsEmpty() {
        int size = sizeWriteRightGroups();
        return size == 0;
    }

    @Override
    public boolean isWriteRightGroupsNotEmpty() {
        boolean empty = isWriteRightGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsWriteRightGroups(FaxToMailUserGroup writeRightGroups) {
        boolean contains = this.writeRightGroups !=null && this.writeRightGroups.contains(writeRightGroups);
        return contains;
    }

    @Override
    public void addMoveRightGroups(FaxToMailUserGroup moveRightGroups) {
        if (this.moveRightGroups == null) {
            this.moveRightGroups = new LinkedList<FaxToMailUserGroup>();
        }
        this.moveRightGroups.add(moveRightGroups);
    }

    @Override
    public void addAllMoveRightGroups(Collection<FaxToMailUserGroup> moveRightGroups) {
        if (moveRightGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : moveRightGroups) {
            addMoveRightGroups(item);
        }
    }

    @Override
    public void setMoveRightGroups(Collection<FaxToMailUserGroup> moveRightGroups) {
        this.moveRightGroups = moveRightGroups;
    }

    @Override
    public void removeMoveRightGroups(FaxToMailUserGroup moveRightGroups) {
        if (this.moveRightGroups == null || !this.moveRightGroups.remove(moveRightGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearMoveRightGroups() {
        if (this.moveRightGroups == null) {
            return;
        }
        this.moveRightGroups.clear();
    }

    @Override
    public Collection<FaxToMailUserGroup> getMoveRightGroups() {
        return moveRightGroups;
    }

    @Override
    public FaxToMailUserGroup getMoveRightGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(moveRightGroups, topiaId);
    }

    @Override
    public Collection<String> getMoveRightGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getMoveRightGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeMoveRightGroups() {
        if (moveRightGroups == null) {
            return 0;
        }
        return moveRightGroups.size();
    }

    @Override
    public boolean isMoveRightGroupsEmpty() {
        int size = sizeMoveRightGroups();
        return size == 0;
    }

    @Override
    public boolean isMoveRightGroupsNotEmpty() {
        boolean empty = isMoveRightGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsMoveRightGroups(FaxToMailUserGroup moveRightGroups) {
        boolean contains = this.moveRightGroups !=null && this.moveRightGroups.contains(moveRightGroups);
        return contains;
    }

    @Override
    public void addReadRightGroups(FaxToMailUserGroup readRightGroups) {
        if (this.readRightGroups == null) {
            this.readRightGroups = new LinkedList<FaxToMailUserGroup>();
        }
        this.readRightGroups.add(readRightGroups);
    }

    @Override
    public void addAllReadRightGroups(Collection<FaxToMailUserGroup> readRightGroups) {
        if (readRightGroups == null) {
            return;
        }
        for (FaxToMailUserGroup item : readRightGroups) {
            addReadRightGroups(item);
        }
    }

    @Override
    public void setReadRightGroups(Collection<FaxToMailUserGroup> readRightGroups) {
        this.readRightGroups = readRightGroups;
    }

    @Override
    public void removeReadRightGroups(FaxToMailUserGroup readRightGroups) {
        if (this.readRightGroups == null || !this.readRightGroups.remove(readRightGroups)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearReadRightGroups() {
        if (this.readRightGroups == null) {
            return;
        }
        this.readRightGroups.clear();
    }

    @Override
    public Collection<FaxToMailUserGroup> getReadRightGroups() {
        return readRightGroups;
    }

    @Override
    public FaxToMailUserGroup getReadRightGroupsByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(readRightGroups, topiaId);
    }

    @Override
    public Collection<String> getReadRightGroupsTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUserGroup> tmp = getReadRightGroups();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeReadRightGroups() {
        if (readRightGroups == null) {
            return 0;
        }
        return readRightGroups.size();
    }

    @Override
    public boolean isReadRightGroupsEmpty() {
        int size = sizeReadRightGroups();
        return size == 0;
    }

    @Override
    public boolean isReadRightGroupsNotEmpty() {
        boolean empty = isReadRightGroupsEmpty();
        return ! empty;
    }

    @Override
    public boolean containsReadRightGroups(FaxToMailUserGroup readRightGroups) {
        boolean contains = this.readRightGroups !=null && this.readRightGroups.contains(readRightGroups);
        return contains;
    }

    @Override
    public void addDemandTypes(DemandType demandTypes) {
        if (this.demandTypes == null) {
            this.demandTypes = new LinkedList<DemandType>();
        }
        this.demandTypes.add(demandTypes);
    }

    @Override
    public void addAllDemandTypes(Collection<DemandType> demandTypes) {
        if (demandTypes == null) {
            return;
        }
        for (DemandType item : demandTypes) {
            addDemandTypes(item);
        }
    }

    @Override
    public void setDemandTypes(Collection<DemandType> demandTypes) {
        this.demandTypes = demandTypes;
    }

    @Override
    public void removeDemandTypes(DemandType demandTypes) {
        if (this.demandTypes == null || !this.demandTypes.remove(demandTypes)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearDemandTypes() {
        if (this.demandTypes == null) {
            return;
        }
        this.demandTypes.clear();
    }

    @Override
    public Collection<DemandType> getDemandTypes() {
        return demandTypes;
    }

    @Override
    public DemandType getDemandTypesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(demandTypes, topiaId);
    }

    @Override
    public Collection<String> getDemandTypesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.DemandType> tmp = getDemandTypes();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeDemandTypes() {
        if (demandTypes == null) {
            return 0;
        }
        return demandTypes.size();
    }

    @Override
    public boolean isDemandTypesEmpty() {
        int size = sizeDemandTypes();
        return size == 0;
    }

    @Override
    public boolean isDemandTypesNotEmpty() {
        boolean empty = isDemandTypesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsDemandTypes(DemandType demandTypes) {
        boolean contains = this.demandTypes !=null && this.demandTypes.contains(demandTypes);
        return contains;
    }

    @Override
    public void addRanges(Range ranges) {
        if (this.ranges == null) {
            this.ranges = new LinkedList<Range>();
        }
        this.ranges.add(ranges);
    }

    @Override
    public void addAllRanges(Collection<Range> ranges) {
        if (ranges == null) {
            return;
        }
        for (Range item : ranges) {
            addRanges(item);
        }
    }

    @Override
    public void setRanges(Collection<Range> ranges) {
        this.ranges = ranges;
    }

    @Override
    public void removeRanges(Range ranges) {
        if (this.ranges == null || !this.ranges.remove(ranges)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearRanges() {
        if (this.ranges == null) {
            return;
        }
        this.ranges.clear();
    }

    @Override
    public Collection<Range> getRanges() {
        return ranges;
    }

    @Override
    public Range getRangesByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(ranges, topiaId);
    }

    @Override
    public Collection<String> getRangesTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.Range> tmp = getRanges();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeRanges() {
        if (ranges == null) {
            return 0;
        }
        return ranges.size();
    }

    @Override
    public boolean isRangesEmpty() {
        int size = sizeRanges();
        return size == 0;
    }

    @Override
    public boolean isRangesNotEmpty() {
        boolean empty = isRangesEmpty();
        return ! empty;
    }

    @Override
    public boolean containsRanges(Range ranges) {
        boolean contains = this.ranges !=null && this.ranges.contains(ranges);
        return contains;
    }

    @Override
    public void addWriteRightUsers(FaxToMailUser writeRightUsers) {
        if (this.writeRightUsers == null) {
            this.writeRightUsers = new LinkedList<FaxToMailUser>();
        }
        this.writeRightUsers.add(writeRightUsers);
    }

    @Override
    public void addAllWriteRightUsers(Collection<FaxToMailUser> writeRightUsers) {
        if (writeRightUsers == null) {
            return;
        }
        for (FaxToMailUser item : writeRightUsers) {
            addWriteRightUsers(item);
        }
    }

    @Override
    public void setWriteRightUsers(Collection<FaxToMailUser> writeRightUsers) {
        this.writeRightUsers = writeRightUsers;
    }

    @Override
    public void removeWriteRightUsers(FaxToMailUser writeRightUsers) {
        if (this.writeRightUsers == null || !this.writeRightUsers.remove(writeRightUsers)) {
            throw new IllegalArgumentException("List does not contain given element");
        }
    }

    @Override
    public void clearWriteRightUsers() {
        if (this.writeRightUsers == null) {
            return;
        }
        this.writeRightUsers.clear();
    }

    @Override
    public Collection<FaxToMailUser> getWriteRightUsers() {
        return writeRightUsers;
    }

    @Override
    public FaxToMailUser getWriteRightUsersByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(writeRightUsers, topiaId);
    }

    @Override
    public Collection<String> getWriteRightUsersTopiaIds() {
        Collection<String> topiaIds = new LinkedList<String>();
        Collection<com.franciaflex.faxtomail.persistence.entities.FaxToMailUser> tmp = getWriteRightUsers();
        if (tmp != null) {
            for (TopiaEntity topiaEntity : tmp) {
                topiaIds.add(topiaEntity.getTopiaId());
            }
        }
        return topiaIds;
    }

    @Override
    public int sizeWriteRightUsers() {
        if (writeRightUsers == null) {
            return 0;
        }
        return writeRightUsers.size();
    }

    @Override
    public boolean isWriteRightUsersEmpty() {
        int size = sizeWriteRightUsers();
        return size == 0;
    }

    @Override
    public boolean isWriteRightUsersNotEmpty() {
        boolean empty = isWriteRightUsersEmpty();
        return ! empty;
    }

    @Override
    public boolean containsWriteRightUsers(FaxToMailUser writeRightUsers) {
        boolean contains = this.writeRightUsers !=null && this.writeRightUsers.contains(writeRightUsers);
        return contains;
    }

} //MailFolderAbstract
