package com.franciaflex.faxtomail.persistence.entities;

/*
 * #%L
 * FaxToMail :: Persistence
 * $Id: DemandStatus.java 48 2014-04-25 13:43:04Z echatellier $
 * $HeadURL: http://svn.codelutin.com/faxtomail/tags/faxtomail-0.2/faxtomail-persistence/src/main/java/com/franciaflex/faxtomail/persistence/entities/DemandStatus.java $
 * %%
 * Copyright (C) 2014 Franciaflex, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin (Code Lutin)
 * @since x.x
 */
public enum DemandStatus implements HasLabel {

    UNTREATED(n("faxtomail.demandStatus.untreated")),
    IN_PROGRESS(n("faxtomail.demandStatus.inProgress")),
    TRANSMITTED_TO_EDI(n("faxtomail.demandStatus.transmittedToEdi")),
    QUALIFIED(n("faxtomail.demandStatus.qualified")),
    ARCHIVED(n("faxtomail.demandStatus.archive"));

    protected String labelKey;

    private DemandStatus(String labelKey) {
        this.labelKey = labelKey;
    }

    public String getLabelKey() {
        return labelKey;
    }

    public String getLabel() {
        return t(labelKey);
    }
}
