package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

/** FolderItem */
public class FolderItem {
  @JsonProperty("completedDateTime")
  private String completedDateTime = null;

  @JsonProperty("createdDateTime")
  private String createdDateTime = null;

  @JsonProperty("customFields")
  private java.util.List<CustomFieldV2> customFields = new java.util.ArrayList<CustomFieldV2>();

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("envelopeId")
  private String envelopeId = null;

  @JsonProperty("envelopeUri")
  private String envelopeUri = null;

  @JsonProperty("is21CFRPart11")
  private String is21CFRPart11 = null;

  @JsonProperty("isSignatureProviderEnvelope")
  private String isSignatureProviderEnvelope = null;

  @JsonProperty("lastModified")
  private String lastModified = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("ownerName")
  private String ownerName = null;

  @JsonProperty("pageCount")
  private Integer pageCount = null;

  @JsonProperty("password")
  private String password = null;

  @JsonProperty("senderEmail")
  private String senderEmail = null;

  @JsonProperty("senderName")
  private String senderName = null;

  @JsonProperty("sentDateTime")
  private String sentDateTime = null;

  @JsonProperty("shared")
  private String shared = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("subject")
  private String subject = null;

  @JsonProperty("templateId")
  private String templateId = null;

  @JsonProperty("uri")
  private String uri = null;

  public FolderItem completedDateTime(String completedDateTime) {
    this.completedDateTime = completedDateTime;
    return this;
  }

  /**
   * Specifies the date and time this item was completed.
   *
   * @return completedDateTime
   */
  @Schema(example = "null", description = "Specifies the date and time this item was completed.")
  public String getCompletedDateTime() {
    return completedDateTime;
  }

  public void setCompletedDateTime(String completedDateTime) {
    this.completedDateTime = completedDateTime;
  }

  public FolderItem createdDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
    return this;
  }

  /**
   * Indicates the date and time the item was created.
   *
   * @return createdDateTime
   */
  @Schema(example = "null", description = "Indicates the date and time the item was created.")
  public String getCreatedDateTime() {
    return createdDateTime;
  }

  public void setCreatedDateTime(String createdDateTime) {
    this.createdDateTime = createdDateTime;
  }

  public FolderItem customFields(java.util.List<CustomFieldV2> customFields) {
    this.customFields = customFields;
    return this;
  }

  public FolderItem addCustomFieldsItem(CustomFieldV2 customFieldsItem) {
    this.customFields.add(customFieldsItem);
    return this;
  }

  /**
   * An optional array of strings that allows the sender to provide custom data about the recipient.
   * This information is returned in the envelope status but otherwise not used by DocuSign. Each
   * customField string can be a maximum of 100 characters.
   *
   * @return customFields
   */
  @Schema(
      example = "null",
      description =
          "An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.")
  public java.util.List<CustomFieldV2> getCustomFields() {
    return customFields;
  }

  public void setCustomFields(java.util.List<CustomFieldV2> customFields) {
    this.customFields = customFields;
  }

  public FolderItem description(String description) {
    this.description = description;
    return this;
  }

  /** @return description */
  @Schema(example = "null", description = "")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public FolderItem envelopeId(String envelopeId) {
    this.envelopeId = envelopeId;
    return this;
  }

  /**
   * The envelope ID of the envelope status that failed to post.
   *
   * @return envelopeId
   */
  @Schema(
      example = "null",
      description = "The envelope ID of the envelope status that failed to post.")
  public String getEnvelopeId() {
    return envelopeId;
  }

  public void setEnvelopeId(String envelopeId) {
    this.envelopeId = envelopeId;
  }

  public FolderItem envelopeUri(String envelopeUri) {
    this.envelopeUri = envelopeUri;
    return this;
  }

  /**
   * Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.
   *
   * @return envelopeUri
   */
  @Schema(
      example = "null",
      description =
          "Contains a URI for an endpoint that you can use to retrieve the envelope or envelopes.")
  public String getEnvelopeUri() {
    return envelopeUri;
  }

  public void setEnvelopeUri(String envelopeUri) {
    this.envelopeUri = envelopeUri;
  }

  public FolderItem is21CFRPart11(String is21CFRPart11) {
    this.is21CFRPart11 = is21CFRPart11;
    return this;
  }

  /**
   * When set to **true**, indicates that this module is enabled on the account.
   *
   * @return is21CFRPart11
   */
  @Schema(
      example = "null",
      description = "When set to **true**, indicates that this module is enabled on the account.")
  public String getIs21CFRPart11() {
    return is21CFRPart11;
  }

  public void setIs21CFRPart11(String is21CFRPart11) {
    this.is21CFRPart11 = is21CFRPart11;
  }

  public FolderItem isSignatureProviderEnvelope(String isSignatureProviderEnvelope) {
    this.isSignatureProviderEnvelope = isSignatureProviderEnvelope;
    return this;
  }

  /** @return isSignatureProviderEnvelope */
  @Schema(example = "null", description = "")
  public String getIsSignatureProviderEnvelope() {
    return isSignatureProviderEnvelope;
  }

  public void setIsSignatureProviderEnvelope(String isSignatureProviderEnvelope) {
    this.isSignatureProviderEnvelope = isSignatureProviderEnvelope;
  }

  public FolderItem lastModified(String lastModified) {
    this.lastModified = lastModified;
    return this;
  }

  /** @return lastModified */
  @Schema(example = "null", description = "")
  public String getLastModified() {
    return lastModified;
  }

  public void setLastModified(String lastModified) {
    this.lastModified = lastModified;
  }

  public FolderItem name(String name) {
    this.name = name;
    return this;
  }

  /** @return name */
  @Schema(example = "null", description = "")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public FolderItem ownerName(String ownerName) {
    this.ownerName = ownerName;
    return this;
  }

  /**
   * Name of the envelope owner.
   *
   * @return ownerName
   */
  @Schema(example = "null", description = "Name of the envelope owner.")
  public String getOwnerName() {
    return ownerName;
  }

  public void setOwnerName(String ownerName) {
    this.ownerName = ownerName;
  }

  public FolderItem pageCount(Integer pageCount) {
    this.pageCount = pageCount;
    return this;
  }

  /** @return pageCount */
  @Schema(example = "null", description = "")
  public Integer getPageCount() {
    return pageCount;
  }

  public void setPageCount(Integer pageCount) {
    this.pageCount = pageCount;
  }

  public FolderItem password(String password) {
    this.password = password;
    return this;
  }

  /** @return password */
  @Schema(example = "null", description = "")
  public String getPassword() {
    return password;
  }

  public void setPassword(String password) {
    this.password = password;
  }

  public FolderItem senderEmail(String senderEmail) {
    this.senderEmail = senderEmail;
    return this;
  }

  /** @return senderEmail */
  @Schema(example = "null", description = "")
  public String getSenderEmail() {
    return senderEmail;
  }

  public void setSenderEmail(String senderEmail) {
    this.senderEmail = senderEmail;
  }

  public FolderItem senderName(String senderName) {
    this.senderName = senderName;
    return this;
  }

  /**
   * Name of the envelope sender.
   *
   * @return senderName
   */
  @Schema(example = "null", description = "Name of the envelope sender.")
  public String getSenderName() {
    return senderName;
  }

  public void setSenderName(String senderName) {
    this.senderName = senderName;
  }

  public FolderItem sentDateTime(String sentDateTime) {
    this.sentDateTime = sentDateTime;
    return this;
  }

  /**
   * The date and time the envelope was sent.
   *
   * @return sentDateTime
   */
  @Schema(example = "null", description = "The date and time the envelope was sent.")
  public String getSentDateTime() {
    return sentDateTime;
  }

  public void setSentDateTime(String sentDateTime) {
    this.sentDateTime = sentDateTime;
  }

  public FolderItem shared(String shared) {
    this.shared = shared;
    return this;
  }

  /**
   * When set to **true**, this custom tab is shared.
   *
   * @return shared
   */
  @Schema(example = "null", description = "When set to **true**, this custom tab is shared.")
  public String getShared() {
    return shared;
  }

  public void setShared(String shared) {
    this.shared = shared;
  }

  public FolderItem status(String status) {
    this.status = status;
    return this;
  }

  /**
   * Indicates the envelope status. Valid values are: * sent - The envelope is sent to the
   * recipients. * created - The envelope is saved as a draft and can be modified and sent later.
   *
   * @return status
   */
  @Schema(
      example = "null",
      description =
          "Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  public FolderItem subject(String subject) {
    this.subject = subject;
    return this;
  }

  /** @return subject */
  @Schema(example = "null", description = "")
  public String getSubject() {
    return subject;
  }

  public void setSubject(String subject) {
    this.subject = subject;
  }

  public FolderItem templateId(String templateId) {
    this.templateId = templateId;
    return this;
  }

  /**
   * The unique identifier of the template. If this is not provided, DocuSign will generate a value.
   *
   * @return templateId
   */
  @Schema(
      example = "null",
      description =
          "The unique identifier of the template. If this is not provided, DocuSign will generate a value. ")
  public String getTemplateId() {
    return templateId;
  }

  public void setTemplateId(String templateId) {
    this.templateId = templateId;
  }

  public FolderItem uri(String uri) {
    this.uri = uri;
    return this;
  }

  /** @return uri */
  @Schema(example = "null", description = "")
  public String getUri() {
    return uri;
  }

  public void setUri(String uri) {
    this.uri = uri;
  }

  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FolderItem folderItem = (FolderItem) o;
    return Objects.equals(this.completedDateTime, folderItem.completedDateTime)
        && Objects.equals(this.createdDateTime, folderItem.createdDateTime)
        && Objects.equals(this.customFields, folderItem.customFields)
        && Objects.equals(this.description, folderItem.description)
        && Objects.equals(this.envelopeId, folderItem.envelopeId)
        && Objects.equals(this.envelopeUri, folderItem.envelopeUri)
        && Objects.equals(this.is21CFRPart11, folderItem.is21CFRPart11)
        && Objects.equals(this.isSignatureProviderEnvelope, folderItem.isSignatureProviderEnvelope)
        && Objects.equals(this.lastModified, folderItem.lastModified)
        && Objects.equals(this.name, folderItem.name)
        && Objects.equals(this.ownerName, folderItem.ownerName)
        && Objects.equals(this.pageCount, folderItem.pageCount)
        && Objects.equals(this.password, folderItem.password)
        && Objects.equals(this.senderEmail, folderItem.senderEmail)
        && Objects.equals(this.senderName, folderItem.senderName)
        && Objects.equals(this.sentDateTime, folderItem.sentDateTime)
        && Objects.equals(this.shared, folderItem.shared)
        && Objects.equals(this.status, folderItem.status)
        && Objects.equals(this.subject, folderItem.subject)
        && Objects.equals(this.templateId, folderItem.templateId)
        && Objects.equals(this.uri, folderItem.uri);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        completedDateTime,
        createdDateTime,
        customFields,
        description,
        envelopeId,
        envelopeUri,
        is21CFRPart11,
        isSignatureProviderEnvelope,
        lastModified,
        name,
        ownerName,
        pageCount,
        password,
        senderEmail,
        senderName,
        sentDateTime,
        shared,
        status,
        subject,
        templateId,
        uri);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FolderItem {\n");

    sb.append("    completedDateTime: ").append(toIndentedString(completedDateTime)).append("\n");
    sb.append("    createdDateTime: ").append(toIndentedString(createdDateTime)).append("\n");
    sb.append("    customFields: ").append(toIndentedString(customFields)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    envelopeId: ").append(toIndentedString(envelopeId)).append("\n");
    sb.append("    envelopeUri: ").append(toIndentedString(envelopeUri)).append("\n");
    sb.append("    is21CFRPart11: ").append(toIndentedString(is21CFRPart11)).append("\n");
    sb.append("    isSignatureProviderEnvelope: ")
        .append(toIndentedString(isSignatureProviderEnvelope))
        .append("\n");
    sb.append("    lastModified: ").append(toIndentedString(lastModified)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    ownerName: ").append(toIndentedString(ownerName)).append("\n");
    sb.append("    pageCount: ").append(toIndentedString(pageCount)).append("\n");
    sb.append("    password: ").append(toIndentedString(password)).append("\n");
    sb.append("    senderEmail: ").append(toIndentedString(senderEmail)).append("\n");
    sb.append("    senderName: ").append(toIndentedString(senderName)).append("\n");
    sb.append("    sentDateTime: ").append(toIndentedString(sentDateTime)).append("\n");
    sb.append("    shared: ").append(toIndentedString(shared)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    subject: ").append(toIndentedString(subject)).append("\n");
    sb.append("    templateId: ").append(toIndentedString(templateId)).append("\n");
    sb.append("    uri: ").append(toIndentedString(uri)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
