package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

/** This object configures a recipient&#39;s read/write access to a document.. */
@Schema(description = "This object configures a recipient's read/write access to a document.")
public class DocumentVisibility implements Serializable {
  private static final long serialVersionUID = 1L;

  @JsonProperty("documentId")
  private String documentId = null;

  @JsonProperty("errorDetails")
  private ErrorDetails errorDetails = null;

  @JsonProperty("recipientId")
  private String recipientId = null;

  @JsonProperty("rights")
  private String rights = null;

  @JsonProperty("visible")
  private String visible = null;

  /**
   * documentId.
   *
   * @return DocumentVisibility
   */
  public DocumentVisibility documentId(String documentId) {
    this.documentId = documentId;
    return this;
  }

  /**
   * Specifies the document ID number that the tab is placed on. This must refer to an existing
   * Document's ID attribute..
   *
   * @return documentId
   */
  @Schema(
      description =
          "Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
  public String getDocumentId() {
    return documentId;
  }

  /** setDocumentId. */
  public void setDocumentId(String documentId) {
    this.documentId = documentId;
  }

  /**
   * errorDetails.
   *
   * @return DocumentVisibility
   */
  public DocumentVisibility errorDetails(ErrorDetails errorDetails) {
    this.errorDetails = errorDetails;
    return this;
  }

  /**
   * Array or errors..
   *
   * @return errorDetails
   */
  @Schema(description = "Array or errors.")
  public ErrorDetails getErrorDetails() {
    return errorDetails;
  }

  /** setErrorDetails. */
  public void setErrorDetails(ErrorDetails errorDetails) {
    this.errorDetails = errorDetails;
  }

  /**
   * recipientId.
   *
   * @return DocumentVisibility
   */
  public DocumentVisibility recipientId(String recipientId) {
    this.recipientId = recipientId;
    return this;
  }

  /**
   * Unique for the recipient. It is used by the tab element to indicate which recipient is to sign
   * the Document..
   *
   * @return recipientId
   */
  @Schema(
      description =
          "Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
  public String getRecipientId() {
    return recipientId;
  }

  /** setRecipientId. */
  public void setRecipientId(String recipientId) {
    this.recipientId = recipientId;
  }

  /**
   * rights.
   *
   * @return DocumentVisibility
   */
  public DocumentVisibility rights(String rights) {
    this.rights = rights;
    return this;
  }

  /**
   * .
   *
   * @return rights
   */
  @Schema(description = "")
  public String getRights() {
    return rights;
  }

  /** setRights. */
  public void setRights(String rights) {
    this.rights = rights;
  }

  /**
   * visible.
   *
   * @return DocumentVisibility
   */
  public DocumentVisibility visible(String visible) {
    this.visible = visible;
    return this;
  }

  /**
   * .
   *
   * @return visible
   */
  @Schema(description = "")
  public String getVisible() {
    return visible;
  }

  /** setVisible. */
  public void setVisible(String visible) {
    this.visible = visible;
  }

  /**
   * Compares objects.
   *
   * @return true or false depending on comparison result.
   */
  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DocumentVisibility documentVisibility = (DocumentVisibility) o;
    return Objects.equals(this.documentId, documentVisibility.documentId)
        && Objects.equals(this.errorDetails, documentVisibility.errorDetails)
        && Objects.equals(this.recipientId, documentVisibility.recipientId)
        && Objects.equals(this.rights, documentVisibility.rights)
        && Objects.equals(this.visible, documentVisibility.visible);
  }

  /** Returns the HashCode. */
  @Override
  public int hashCode() {
    return Objects.hash(documentId, errorDetails, recipientId, rights, visible);
  }

  /** Converts the given object to string. */
  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DocumentVisibility {\n");

    sb.append("    documentId: ").append(toIndentedString(documentId)).append("\n");
    sb.append("    errorDetails: ").append(toIndentedString(errorDetails)).append("\n");
    sb.append("    recipientId: ").append(toIndentedString(recipientId)).append("\n");
    sb.append("    rights: ").append(toIndentedString(rights)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
