/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ConditionalRecipientRuleCondition;
import com.docusign.esign.model.RecipientGroup;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A rule that defines a set of recipients and the conditions under which they will be used for the envelope.")
public class ConditionalRecipientRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="conditions")
    private List<ConditionalRecipientRuleCondition> conditions = null;
    @JsonProperty(value="order")
    private String order = null;
    @JsonProperty(value="recipientGroup")
    private RecipientGroup recipientGroup = null;
    @JsonProperty(value="recipientId")
    private String recipientId = null;

    public ConditionalRecipientRule conditions(List<ConditionalRecipientRuleCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public ConditionalRecipientRule addConditionsItem(ConditionalRecipientRuleCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<ConditionalRecipientRuleCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Schema(description="")
    public List<ConditionalRecipientRuleCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<ConditionalRecipientRuleCondition> conditions) {
        this.conditions = conditions;
    }

    public ConditionalRecipientRule order(String order) {
        this.order = order;
        return this;
    }

    @Schema(description="")
    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public ConditionalRecipientRule recipientGroup(RecipientGroup recipientGroup) {
        this.recipientGroup = recipientGroup;
        return this;
    }

    @Schema(description="A set of recipients that may be used for the envelope, depending on the `conditions` defined.")
    public RecipientGroup getRecipientGroup() {
        return this.recipientGroup;
    }

    public void setRecipientGroup(RecipientGroup recipientGroup) {
        this.recipientGroup = recipientGroup;
    }

    public ConditionalRecipientRule recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @Schema(description="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConditionalRecipientRule conditionalRecipientRule = (ConditionalRecipientRule)o;
        return Objects.equals(this.conditions, conditionalRecipientRule.conditions) && Objects.equals(this.order, conditionalRecipientRule.order) && Objects.equals(this.recipientGroup, conditionalRecipientRule.recipientGroup) && Objects.equals(this.recipientId, conditionalRecipientRule.recipientId);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.order, this.recipientGroup, this.recipientId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConditionalRecipientRule {\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    order: ").append(this.toIndentedString(this.order)).append("\n");
        sb.append("    recipientGroup: ").append(this.toIndentedString(this.recipientGroup)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

