/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Document;
import com.docusign.esign.model.InlineTemplate;
import com.docusign.esign.model.ServerTemplate;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="This object contains information about a [composite template][composite], which you can use to to apply multiple templates to a single envelope, combine templates with PDF forms, and combine templates with documents from cloud sources.  [composite]: /docs/esign-rest-api/esign101/concepts/templates/composite/")
public class CompositeTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="compositeTemplateId")
    private String compositeTemplateId = null;
    @JsonProperty(value="document")
    private Document document = null;
    @JsonProperty(value="inlineTemplates")
    private List<InlineTemplate> inlineTemplates = null;
    @JsonProperty(value="pdfMetaDataTemplateSequence")
    private String pdfMetaDataTemplateSequence = null;
    @JsonProperty(value="serverTemplates")
    private List<ServerTemplate> serverTemplates = null;

    public CompositeTemplate compositeTemplateId(String compositeTemplateId) {
        this.compositeTemplateId = compositeTemplateId;
        return this;
    }

    @Schema(description="The identify of this composite template. It is used as a reference when adding document object information. If used, the document's `content-disposition` must include the composite template ID to which the document should be added. If a composite template ID is not specified in the content-disposition, the document is applied based on the value of the `documentId` property only. If no document object is specified, the composite template inherits the first document.")
    public String getCompositeTemplateId() {
        return this.compositeTemplateId;
    }

    public void setCompositeTemplateId(String compositeTemplateId) {
        this.compositeTemplateId = compositeTemplateId;
    }

    public CompositeTemplate document(Document document) {
        this.document = document;
        return this;
    }

    @Schema(description="An optional document object that will act as the primary document in the composite template object. If the document node is present, it will take precedence over any server template or inline template documents. It always comes first. Only use this when you want to supply the document dynamically.")
    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public CompositeTemplate inlineTemplates(List<InlineTemplate> inlineTemplates) {
        this.inlineTemplates = inlineTemplates;
        return this;
    }

    public CompositeTemplate addInlineTemplatesItem(InlineTemplate inlineTemplatesItem) {
        if (this.inlineTemplates == null) {
            this.inlineTemplates = new ArrayList<InlineTemplate>();
        }
        this.inlineTemplates.add(inlineTemplatesItem);
        return this;
    }

    @Schema(description=" Zero or more inline templates and their position in the overlay. If supplied, they are overlaid into the envelope in the order of their Sequence value.")
    public List<InlineTemplate> getInlineTemplates() {
        return this.inlineTemplates;
    }

    public void setInlineTemplates(List<InlineTemplate> inlineTemplates) {
        this.inlineTemplates = inlineTemplates;
    }

    public CompositeTemplate pdfMetaDataTemplateSequence(String pdfMetaDataTemplateSequence) {
        this.pdfMetaDataTemplateSequence = pdfMetaDataTemplateSequence;
        return this;
    }

    @Schema(description="")
    public String getPdfMetaDataTemplateSequence() {
        return this.pdfMetaDataTemplateSequence;
    }

    public void setPdfMetaDataTemplateSequence(String pdfMetaDataTemplateSequence) {
        this.pdfMetaDataTemplateSequence = pdfMetaDataTemplateSequence;
    }

    public CompositeTemplate serverTemplates(List<ServerTemplate> serverTemplates) {
        this.serverTemplates = serverTemplates;
        return this;
    }

    public CompositeTemplate addServerTemplatesItem(ServerTemplate serverTemplatesItem) {
        if (this.serverTemplates == null) {
            this.serverTemplates = new ArrayList<ServerTemplate>();
        }
        this.serverTemplates.add(serverTemplatesItem);
        return this;
    }

    @Schema(description="0 or more server-side templates and their position in the overlay. If supplied, they are overlaid into the envelope in the order of their Sequence value")
    public List<ServerTemplate> getServerTemplates() {
        return this.serverTemplates;
    }

    public void setServerTemplates(List<ServerTemplate> serverTemplates) {
        this.serverTemplates = serverTemplates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeTemplate compositeTemplate = (CompositeTemplate)o;
        return Objects.equals(this.compositeTemplateId, compositeTemplate.compositeTemplateId) && Objects.equals(this.document, compositeTemplate.document) && Objects.equals(this.inlineTemplates, compositeTemplate.inlineTemplates) && Objects.equals(this.pdfMetaDataTemplateSequence, compositeTemplate.pdfMetaDataTemplateSequence) && Objects.equals(this.serverTemplates, compositeTemplate.serverTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.compositeTemplateId, this.document, this.inlineTemplates, this.pdfMetaDataTemplateSequence, this.serverTemplates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompositeTemplate {\n");
        sb.append("    compositeTemplateId: ").append(this.toIndentedString(this.compositeTemplateId)).append("\n");
        sb.append("    document: ").append(this.toIndentedString(this.document)).append("\n");
        sb.append("    inlineTemplates: ").append(this.toIndentedString(this.inlineTemplates)).append("\n");
        sb.append("    pdfMetaDataTemplateSequence: ").append(this.toIndentedString(this.pdfMetaDataTemplateSequence)).append("\n");
        sb.append("    serverTemplates: ").append(this.toIndentedString(this.serverTemplates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

