/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This object configures a recipient's read/write access to a document.")
public class DocumentVisibility {
    @JsonProperty(value="documentId")
    private String documentId = null;
    @JsonProperty(value="errorDetails")
    private ErrorDetails errorDetails = null;
    @JsonProperty(value="recipientId")
    private String recipientId = null;
    @JsonProperty(value="rights")
    private String rights = null;
    @JsonProperty(value="visible")
    private String visible = null;

    public DocumentVisibility documentId(String documentId) {
        this.documentId = documentId;
        return this;
    }

    @ApiModelProperty(value="Specifies the document ID number that the tab is placed on. This must refer to an existing Document's ID attribute.")
    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public DocumentVisibility errorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    @ApiModelProperty(value="This object describes errors that occur. It is only valid for responses and ignored in requests.")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    public DocumentVisibility recipientId(String recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @ApiModelProperty(value="Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.")
    public String getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(String recipientId) {
        this.recipientId = recipientId;
    }

    public DocumentVisibility rights(String rights) {
        this.rights = rights;
        return this;
    }

    @ApiModelProperty(value="")
    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public DocumentVisibility visible(String visible) {
        this.visible = visible;
        return this;
    }

    @ApiModelProperty(value="")
    public String getVisible() {
        return this.visible;
    }

    public void setVisible(String visible) {
        this.visible = visible;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentVisibility documentVisibility = (DocumentVisibility)o;
        return Objects.equals(this.documentId, documentVisibility.documentId) && Objects.equals(this.errorDetails, documentVisibility.errorDetails) && Objects.equals(this.recipientId, documentVisibility.recipientId) && Objects.equals(this.rights, documentVisibility.rights) && Objects.equals(this.visible, documentVisibility.visible);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.errorDetails, this.recipientId, this.rights, this.visible);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentVisibility {\n");
        sb.append("    documentId: ").append(this.toIndentedString(this.documentId)).append("\n");
        sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    rights: ").append(this.toIndentedString(this.rights)).append("\n");
        sb.append("    visible: ").append(this.toIndentedString(this.visible)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

