/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.ApiResponse;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.ApiRequestLogsResult;
import com.docusign.esign.model.DiagnosticsSettingsInformation;
import com.docusign.esign.model.ResourceInformation;
import com.docusign.esign.model.ServiceInformation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.GenericType;

public class DiagnosticsApi {
    private ApiClient apiClient;

    public DiagnosticsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DiagnosticsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void deleteRequestLogs() throws ApiException {
        this.deleteRequestLogsWithHttpInfo();
    }

    public ApiResponse<Object> deleteRequestLogsWithHttpInfo() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/diagnostics/request_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
        return new ApiResponse<Object>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), null);
    }

    public byte[] getRequestLog(String requestLogId) throws ApiException {
        ApiResponse<byte[]> localVarResponse = this.getRequestLogWithHttpInfo(requestLogId);
        return localVarResponse.getData();
    }

    public ApiResponse<byte[]> getRequestLogWithHttpInfo(String requestLogId) throws ApiException {
        String localVarPostBody = "{}";
        if (requestLogId == null) {
            throw new ApiException(400, "Missing the required parameter 'requestLogId' when calling getRequestLog");
        }
        String localVarPath = "/v2.1/diagnostics/request_logs/{requestLogId}".replaceAll("\\{requestLogId\\}", this.apiClient.escapeString(requestLogId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"text/plain"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<byte[]> localVarReturnType = new GenericType<byte[]>(){};
        byte[] localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<byte[]>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DiagnosticsSettingsInformation getRequestLogSettings() throws ApiException {
        ApiResponse<DiagnosticsSettingsInformation> localVarResponse = this.getRequestLogSettingsWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<DiagnosticsSettingsInformation> getRequestLogSettingsWithHttpInfo() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/diagnostics/settings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DiagnosticsSettingsInformation> localVarReturnType = new GenericType<DiagnosticsSettingsInformation>(){};
        DiagnosticsSettingsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DiagnosticsSettingsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ResourceInformation getResources() throws ApiException {
        ApiResponse<ResourceInformation> localVarResponse = this.getResourcesWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<ResourceInformation> getResourcesWithHttpInfo() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ResourceInformation> localVarReturnType = new GenericType<ResourceInformation>(){};
        ResourceInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ResourceInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ServiceInformation getService() throws ApiException {
        ApiResponse<ServiceInformation> localVarResponse = this.getServiceWithHttpInfo();
        return localVarResponse.getData();
    }

    public ApiResponse<ServiceInformation> getServiceWithHttpInfo() throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/service_information";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ServiceInformation> localVarReturnType = new GenericType<ServiceInformation>(){};
        ServiceInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ServiceInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public ApiRequestLogsResult listRequestLogs() throws ApiException {
        return this.listRequestLogs(null);
    }

    public ApiRequestLogsResult listRequestLogs(ListRequestLogsOptions options) throws ApiException {
        ApiResponse<ApiRequestLogsResult> localVarResponse = this.listRequestLogsWithHttpInfo(options);
        return localVarResponse.getData();
    }

    public ApiResponse<ApiRequestLogsResult> listRequestLogsWithHttpInfo(ListRequestLogsOptions options) throws ApiException {
        String localVarPostBody = "{}";
        String localVarPath = "/v2.1/diagnostics/request_logs";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (options != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("encoding", options.encoding));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<ApiRequestLogsResult> localVarReturnType = new GenericType<ApiRequestLogsResult>(){};
        ApiRequestLogsResult localVarResponse = this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<ApiRequestLogsResult>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public DiagnosticsSettingsInformation updateRequestLogSettings(DiagnosticsSettingsInformation diagnosticsSettingsInformation) throws ApiException {
        ApiResponse<DiagnosticsSettingsInformation> localVarResponse = this.updateRequestLogSettingsWithHttpInfo(diagnosticsSettingsInformation);
        return localVarResponse.getData();
    }

    public ApiResponse<DiagnosticsSettingsInformation> updateRequestLogSettingsWithHttpInfo(DiagnosticsSettingsInformation diagnosticsSettingsInformation) throws ApiException {
        DiagnosticsSettingsInformation localVarPostBody = diagnosticsSettingsInformation;
        String localVarPath = "/v2.1/diagnostics/settings";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"docusignAccessCode"};
        GenericType<DiagnosticsSettingsInformation> localVarReturnType = new GenericType<DiagnosticsSettingsInformation>(){};
        DiagnosticsSettingsInformation localVarResponse = this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
        return new ApiResponse<DiagnosticsSettingsInformation>(this.apiClient.getStatusCode(), this.apiClient.getResponseHeaders(), localVarResponse);
    }

    public class ListRequestLogsOptions {
        private String encoding = null;

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

