/*
 * Decompiled with CFR 0.152.
 */
package com.btmatthews.maven.plugins.crx;

import com.btmatthews.maven.plugins.crx.ArchiveHelper;
import com.btmatthews.maven.plugins.crx.CRXArchive;
import com.btmatthews.maven.plugins.crx.CRXArchiver;
import com.btmatthews.maven.plugins.crx.CRXPasswordFinder;
import com.btmatthews.maven.plugins.crx.SignatureHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.ResourceIterator;
import org.codehaus.plexus.archiver.zip.AbstractZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipOutputStream;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;

@Component(role=CRXArchiver.class, hint="crx", instantiationStrategy="per-lookup")
public class CRXArchiverImpl
extends AbstractZipArchiver
implements CRXArchiver {
    private File pemFile;
    private String pemPassword;
    @Requirement(hint="crx")
    private SignatureHelper signatureHelper;
    @Requirement(hint="crx")
    private ArchiveHelper archiveHelper;

    public void setPemFile(File file) {
        this.pemFile = file;
    }

    public final void setPemPassword(String password) {
        this.pemPassword = password;
    }

    public void setSignatureHelper(SignatureHelper helper) {
        this.signatureHelper = helper;
    }

    public void setArchiveHelper(ArchiveHelper helper) {
        this.archiveHelper = helper;
    }

    protected String getArchiveType() {
        return "crx";
    }

    protected void execute() {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            byte[] zipData = this.createZipFile();
            KeyPair keyPair = this.getKeyPair();
            byte[] publicKey = keyPair.getPublic().getEncoded();
            byte[] signature = this.signatureHelper.sign(zipData, keyPair.getPrivate());
            CRXArchive archive = new CRXArchive(publicKey, signature, zipData);
            this.archiveHelper.writeArchive(this.getDestFile(), archive);
        }
        catch (GeneralSecurityException e) {
            throw new ArchiverException("Could not generate the signature for the CRX file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Could not read resources or output the CRX file", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyPair getKeyPair() {
        try {
            FileReader pemFileReader = new FileReader(this.pemFile);
            try {
                PEMReader pemReader;
                if (this.pemPassword == null) {
                    pemReader = new PEMReader((Reader)pemFileReader);
                } else {
                    CRXPasswordFinder passwordFinder = new CRXPasswordFinder(this.pemPassword);
                    pemReader = new PEMReader((Reader)pemFileReader, (PasswordFinder)passwordFinder);
                }
                try {
                    Object pemObject = pemReader.readObject();
                    if (pemObject instanceof KeyPair) {
                        KeyPair keyPair = (KeyPair)pemObject;
                        return keyPair;
                    }
                    if (!(pemObject instanceof RSAPrivateCrtKey)) throw new ArchiverException("Could not load the public/private key from invalid PEM file");
                    RSAPrivateCrtKey privateCrtKey = (RSAPrivateCrtKey)pemObject;
                    BigInteger exponent = privateCrtKey.getPublicExponent();
                    BigInteger modulus = privateCrtKey.getModulus();
                    RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
                    KeyFactory keyFactory = KeyFactory.getInstance("RSA", "BC");
                    PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
                    KeyPair keyPair = new KeyPair(publicKey, privateCrtKey);
                    return keyPair;
                }
                finally {
                    pemReader.close();
                }
            }
            finally {
                ((Reader)pemFileReader).close();
            }
        }
        catch (InvalidKeySpecException e) {
            throw new ArchiverException("Cannot generate RSA public key", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ArchiverException("RSA Private key algorithm is not supported", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            throw new ArchiverException("Bouncy Castle not registered correctly", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArchiverException("Could not load the public/private key from the PEM file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createZipFile() throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ZipOutputStream out = new ZipOutputStream((OutputStream)buffer);
        try {
            out.setMethod(8);
            out.setLevel(9);
            ResourceIterator resourceIterator = this.getResources();
            this.addResources(resourceIterator, out);
        }
        finally {
            out.close();
        }
        return buffer.toByteArray();
    }
}

