// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.appconfiguration.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.data.appconfiguration.models.ConfigurationSnapshotStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters used to update a snapshot.
 */
@Fluent
public final class SnapshotUpdateParameters implements JsonSerializable<SnapshotUpdateParameters> {
    /*
     * The desired status of the snapshot.
     */
    private ConfigurationSnapshotStatus status;

    /**
     * Creates an instance of SnapshotUpdateParameters class.
     */
    public SnapshotUpdateParameters() {
    }

    /**
     * Get the status property: The desired status of the snapshot.
     * 
     * @return the status value.
     */
    public ConfigurationSnapshotStatus getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The desired status of the snapshot.
     * 
     * @param status the status value to set.
     * @return the SnapshotUpdateParameters object itself.
     */
    public SnapshotUpdateParameters setStatus(ConfigurationSnapshotStatus status) {
        this.status = status;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SnapshotUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SnapshotUpdateParameters if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SnapshotUpdateParameters.
     */
    public static SnapshotUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotUpdateParameters deserializedSnapshotUpdateParameters = new SnapshotUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedSnapshotUpdateParameters.status
                        = ConfigurationSnapshotStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSnapshotUpdateParameters;
        });
    }
}
