/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.appconfiguration.implementation;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.data.appconfiguration.implementation.ConfigurationClientCredentials;
import java.nio.ByteBuffer;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConfigurationCredentialsPolicy
implements HttpPipelinePolicy {
    private final ConfigurationClientCredentials credentials;

    public ConfigurationCredentialsPolicy(ConfigurationClientCredentials credentials) {
        Objects.requireNonNull(credentials, "'credential' can not be a null value.");
        this.credentials = credentials;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Flux contents = context.getHttpRequest().getBody() == null ? Flux.just((Object)this.getEmptyBuffer()) : context.getHttpRequest().getBody();
        return this.credentials.getAuthorizationHeadersAsync(context.getHttpRequest().getUrl(), context.getHttpRequest().getHttpMethod().toString(), (Flux<ByteBuffer>)contents.defaultIfEmpty((Object)this.getEmptyBuffer())).flatMapMany(headers -> Flux.fromIterable(headers.entrySet())).map(header -> context.getHttpRequest().setHeader((String)header.getKey(), (String)header.getValue())).last().flatMap(request -> next.process());
    }

    private ByteBuffer getEmptyBuffer() {
        return ByteBuffer.allocate(0);
    }
}

