/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.transform;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.ast.libs.org.parboiled.asm.Opcodes;
import lombok.ast.libs.org.parboiled.asm.Type;
import lombok.ast.libs.org.parboiled.asm.tree.AbstractInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.MethodInsnNode;
import lombok.ast.libs.org.parboiled.asm.tree.TypeInsnNode;
import lombok.ast.libs.org.parboiled.google.base.Preconditions;
import lombok.ast.libs.org.parboiled.transform.AsmUtils;
import lombok.ast.libs.org.parboiled.transform.InstructionGraphNode;
import lombok.ast.libs.org.parboiled.transform.ParserClassNode;
import lombok.ast.libs.org.parboiled.transform.RuleMethod;
import lombok.ast.libs.org.parboiled.transform.RuleMethodProcessor;
import lombok.ast.libs.org.parboiled.transform.Types;
import org.jetbrains.annotations.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImplicitActionsConverter
implements Opcodes,
RuleMethodProcessor,
Types {
    private final Set<InstructionGraphNode> covered = new HashSet<InstructionGraphNode>();
    private RuleMethod method;

    ImplicitActionsConverter() {
    }

    @Override
    public boolean appliesTo(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ImplicitActionsConverter.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.ImplicitActionsConverter.appliesTo(...) corresponds to @NotNull parameter and must not be null");
        }
        return method.containsImplicitActions();
    }

    @Override
    public void process(@NotNull ParserClassNode classNode, @NotNull RuleMethod method) throws Exception {
        if (classNode == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.transform.ImplicitActionsConverter.process(...) corresponds to @NotNull parameter and must not be null");
        }
        if (method == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.transform.ImplicitActionsConverter.process(...) corresponds to @NotNull parameter and must not be null");
        }
        this.method = method;
        this.covered.clear();
        this.walkNode(method.getReturnInstructionNode());
        method.setContainsImplicitActions(false);
    }

    private void walkNode(InstructionGraphNode node) {
        if (this.covered.contains(node)) {
            return;
        }
        this.covered.add(node);
        if (this.isImplicitAction(node)) {
            this.replaceWithActionWrapper(node);
            this.method.setContainsExplicitActions(true);
            return;
        }
        if (node.isContextSwitch()) {
            this.insertNewActionWrapperAfterContextSwitch(node);
            this.method.setContainsExplicitActions(true);
            return;
        }
        if (!node.isActionRoot() && !node.isCaptureRoot()) {
            for (InstructionGraphNode predecessor : node.getPredecessors()) {
                this.walkNode(predecessor);
            }
        }
    }

    private void replaceWithActionWrapper(InstructionGraphNode node) {
        MethodInsnNode insn = this.createActionWrappingInsn();
        this.method.instructions.set(node.getInstruction(), insn);
        node.setIsActionRoot();
        node.setInstruction(insn);
    }

    private void insertNewActionWrapperAfterContextSwitch(InstructionGraphNode node) {
        MethodInsnNode bvInsn = new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z");
        this.method.instructions.insert(node.getInstruction(), bvInsn);
        InstructionGraphNode bvNode = new InstructionGraphNode(bvInsn, null);
        MethodInsnNode wrapperInsn = this.createActionWrappingInsn();
        this.method.instructions.insert(bvInsn, wrapperInsn);
        InstructionGraphNode wrapperNode = new InstructionGraphNode(wrapperInsn, null);
        for (InstructionGraphNode dependent : this.getDependents(node)) {
            dependent.getPredecessors().set(dependent.getPredecessors().indexOf(node), wrapperNode);
        }
        List<InstructionGraphNode> graphNodes = this.method.getGraphNodes();
        int nodeIndex = graphNodes.indexOf(node);
        graphNodes.add(nodeIndex + 1, bvNode);
        graphNodes.add(nodeIndex + 2, wrapperNode);
        bvNode.getPredecessors().add(node);
        wrapperNode.getPredecessors().add(bvNode);
    }

    private boolean isImplicitAction(InstructionGraphNode node) {
        if (!AsmUtils.isBooleanValueOfZ(node.getInstruction())) {
            return false;
        }
        List<InstructionGraphNode> dependents = this.getDependents(node);
        if (dependents.size() != 1) {
            return false;
        }
        InstructionGraphNode dependent = dependents.get(0);
        return this.isObjectArgumentToRuleCreatingMethodCall(node, dependent) || this.isStoredIntoObjectArray(dependent);
    }

    private boolean isObjectArgumentToRuleCreatingMethodCall(InstructionGraphNode instructionGraphNode, InstructionGraphNode instructionGraphNode2) {
        AbstractInsnNode abstractInsnNode = instructionGraphNode2.getInstruction();
        if (abstractInsnNode.getType() != 5) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        if (!RULE.equals(Type.getReturnType(methodInsnNode.desc))) {
            return false;
        }
        Type[] typeArray = Type.getArgumentTypes(methodInsnNode.desc);
        int n = this.getArgumentIndex(instructionGraphNode2, instructionGraphNode);
        Preconditions.checkState(n < typeArray.length);
        return "java/lang/Object".equals(typeArray[n].getInternalName());
    }

    private boolean isStoredIntoObjectArray(InstructionGraphNode instructionGraphNode) {
        AbstractInsnNode abstractInsnNode = instructionGraphNode.getInstruction();
        if (abstractInsnNode.getOpcode() != 83) {
            return false;
        }
        List<InstructionGraphNode> list = this.getDependents(instructionGraphNode);
        Preconditions.checkState(list.size() == 1);
        AbstractInsnNode abstractInsnNode2 = list.get(0).getInstruction();
        Preconditions.checkState(abstractInsnNode2.getOpcode() == 189);
        return "java/lang/Object".equals(((TypeInsnNode)abstractInsnNode2).desc);
    }

    private int getArgumentIndex(InstructionGraphNode callNode, InstructionGraphNode predecessor) {
        int startIndex;
        for (int i = startIndex = callNode.getInstruction().getOpcode() == 184 ? 0 : 1; i < callNode.getPredecessors().size(); ++i) {
            InstructionGraphNode argumentNode = callNode.getPredecessors().get(i);
            if (!predecessor.equals(argumentNode)) continue;
            return i - startIndex;
        }
        throw new IllegalStateException();
    }

    private List<InstructionGraphNode> getDependents(InstructionGraphNode predecessor) {
        ArrayList<InstructionGraphNode> dependents = new ArrayList<InstructionGraphNode>();
        for (InstructionGraphNode node : this.method.getGraphNodes()) {
            if (!node.getPredecessors().contains(predecessor)) continue;
            dependents.add(node);
        }
        return dependents;
    }

    private MethodInsnNode createActionWrappingInsn() {
        return new MethodInsnNode(184, BASE_PARSER.getInternalName(), "ACTION", "(Z)" + ACTION_DESC);
    }
}

