/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.support;

import java.util.Arrays;
import lombok.ast.libs.org.parboiled.common.StringUtils;
import org.jetbrains.annotations.NotNull;

public class Characters {
    private static final char[] NO_CHARS = new char[0];
    public static final Characters NONE = new Characters(false, NO_CHARS);
    public static final Characters ALL = new Characters(true, NO_CHARS);
    public static final char EOI = '\uffff';
    public static final char DEL_ERROR = '\ufdef';
    public static final char INS_ERROR = '\ufdee';
    public static final char RESYNC = '\ufded';
    private final boolean subtractive;
    private final char[] chars;

    private Characters(boolean subtractive, @NotNull char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.Characters.<init>(...) corresponds to @NotNull parameter and must not be null");
        }
        this.subtractive = subtractive;
        this.chars = chars;
    }

    public boolean isSubtractive() {
        return this.subtractive;
    }

    public char[] getChars() {
        return this.chars;
    }

    @NotNull
    public Characters add(char c) {
        Characters characters = this.subtractive ? this.removeFromChars(c) : this.addToChars(c);
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.add must not return null");
        }
        return characters;
    }

    @NotNull
    public Characters remove(char c) {
        Characters characters = this.subtractive ? this.addToChars(c) : this.removeFromChars(c);
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.remove must not return null");
        }
        return characters;
    }

    public boolean contains(char c) {
        return Characters.indexOf(this.chars, c) == -1 ? this.subtractive : !this.subtractive;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Characters add(@NotNull Characters other) {
        Characters characters;
        if (other == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.Characters.add(...) corresponds to @NotNull parameter and must not be null");
        }
        if (!this.subtractive && !other.subtractive) {
            characters = this.addToChars(other.chars);
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.add must not return null");
            return characters;
        }
        if (this.subtractive && other.subtractive) {
            characters = this.retainAllChars(other.chars);
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.add must not return null");
            return characters;
        }
        characters = this.subtractive ? this.removeFromChars(other.chars) : other.removeFromChars(this.chars);
        if (characters != null) return characters;
        throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.add must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Characters remove(@NotNull Characters other) {
        Characters characters;
        if (other == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.Characters.remove(...) corresponds to @NotNull parameter and must not be null");
        }
        if (!this.subtractive && !other.subtractive) {
            characters = this.removeFromChars(other.chars);
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.remove must not return null");
            return characters;
        }
        if (this.subtractive && other.subtractive) {
            characters = new Characters(false, other.removeFromChars((char[])this.chars).chars);
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.remove must not return null");
            return characters;
        }
        characters = this.subtractive ? this.addToChars(other.chars) : this.retainAllChars(other.chars);
        if (characters != null) return characters;
        throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.remove must not return null");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subtractive ? "![" : "[");
        for (char c : this.chars) {
            sb.append(StringUtils.escape(c));
        }
        sb.append(']');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Characters)) {
            return false;
        }
        Characters that = (Characters)o;
        return this.subtractive == that.subtractive && Characters.equivalent(this.chars, that.chars);
    }

    public int hashCode() {
        int result = this.subtractive ? 1 : 0;
        result = 31 * result + Arrays.hashCode(this.chars);
        return result;
    }

    @NotNull
    private Characters addToChars(char[] chs) {
        Characters characters = this;
        for (char c : chs) {
            characters = characters.addToChars(c);
        }
        Characters characters2 = characters;
        if (characters2 == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.addToChars must not return null");
        }
        return characters2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Characters addToChars(char c) {
        Characters characters;
        if (Characters.indexOf(this.chars, c) != -1) {
            characters = this;
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.addToChars must not return null");
            return characters;
        }
        char[] newChars = new char[this.chars.length + 1];
        System.arraycopy(this.chars, 0, newChars, 0, this.chars.length);
        newChars[this.chars.length] = c;
        characters = new Characters(this.subtractive, newChars);
        if (characters != null) return characters;
        throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.addToChars must not return null");
    }

    @NotNull
    private Characters removeFromChars(char[] chs) {
        Characters characters = this;
        for (char c : chs) {
            characters = characters.removeFromChars(c);
        }
        Characters characters2 = characters;
        if (characters2 == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.removeFromChars must not return null");
        }
        return characters2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private Characters removeFromChars(char c) {
        Characters characters;
        int ix = Characters.indexOf(this.chars, c);
        if (ix == -1) {
            characters = this;
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.removeFromChars must not return null");
            return characters;
        }
        if (this.chars.length == 1) {
            characters = this.subtractive ? ALL : NONE;
            if (characters == null) throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.removeFromChars must not return null");
            return characters;
        }
        char[] newChars = new char[this.chars.length - 1];
        System.arraycopy(this.chars, 0, newChars, 0, ix);
        System.arraycopy(this.chars, ix + 1, newChars, ix, this.chars.length - ix - 1);
        characters = new Characters(this.subtractive, newChars);
        if (characters != null) return characters;
        throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.removeFromChars must not return null");
    }

    @NotNull
    private Characters retainAllChars(char[] chs) {
        Characters characters = this;
        for (char c : this.chars) {
            if (Characters.indexOf(chs, c) != -1) continue;
            characters = characters.removeFromChars(c);
        }
        Characters characters2 = characters;
        if (characters2 == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.retainAllChars must not return null");
        }
        return characters2;
    }

    private static int indexOf(char[] chars, char c) {
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static boolean equivalent(@NotNull char[] a, @NotNull char[] b) {
        if (a == null) {
            throw new IllegalArgumentException("1st argument of method org.parboiled.support.Characters.equivalent(...) corresponds to @NotNull parameter and must not be null");
        }
        if (b == null) {
            throw new IllegalArgumentException("2nd argument of method org.parboiled.support.Characters.equivalent(...) corresponds to @NotNull parameter and must not be null");
        }
        if (a == b) {
            return true;
        }
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        block0: for (int i = 0; i < length; ++i) {
            char ac = a[i];
            for (int j = 0; j < length; ++j) {
                if (ac == b[j]) continue block0;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public static Characters of(char c) {
        Characters characters = new Characters(false, new char[]{c});
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.of must not return null");
        }
        return characters;
    }

    @NotNull
    public static Characters of(char ... chars) {
        Characters characters = chars.length == 0 ? NONE : new Characters(false, (char[])chars.clone());
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.of must not return null");
        }
        return characters;
    }

    @NotNull
    public static Characters of(String chars) {
        Characters characters = StringUtils.isEmpty(chars) ? NONE : new Characters(false, chars.toCharArray());
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.of must not return null");
        }
        return characters;
    }

    @NotNull
    public static Characters allBut(char c) {
        Characters characters = new Characters(true, new char[]{c});
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.allBut must not return null");
        }
        return characters;
    }

    @NotNull
    public static Characters allBut(char ... chars) {
        Characters characters = chars.length == 0 ? ALL : new Characters(true, (char[])chars.clone());
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.allBut must not return null");
        }
        return characters;
    }

    @NotNull
    public static Characters allBut(String chars) {
        Characters characters = StringUtils.isEmpty(chars) ? ALL : new Characters(true, chars.toCharArray());
        if (characters == null) {
            throw new IllegalStateException("@NotNull method org.parboiled.support.Characters.allBut must not return null");
        }
        return characters;
    }
}

