/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.testing;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.testing.CustomTestRunListener;
import com.android.builder.testing.TestData;
import com.android.builder.testing.api.DeviceConnector;
import com.android.builder.testing.api.DeviceException;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.RemoteAndroidTestRunner;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.android.ddmlib.testrunner.TestRunResult;
import com.android.utils.ILogger;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class SimpleTestCallable
implements Callable<Boolean> {
    public static final String FILE_COVERAGE_EC = "coverage.ec";
    @NonNull
    private final String projectName;
    @NonNull
    private final DeviceConnector device;
    @NonNull
    private final String flavorName;
    @NonNull
    private final TestData testData;
    @NonNull
    private final File resultsDir;
    @NonNull
    private final File coverageDir;
    @NonNull
    private final File testApk;
    @NonNull
    private final List<File> testedApks;
    @NonNull
    private final File adbExec;
    @NonNull
    private final Collection<String> installOptions;
    private final int timeoutInMs;
    @NonNull
    private final ILogger logger;

    public SimpleTestCallable(@NonNull DeviceConnector device, @NonNull String projectName, @NonNull String flavorName, @NonNull File testApk, @NonNull List<File> testedApks, @NonNull File adbExec, @NonNull TestData testData, @NonNull File resultsDir, @NonNull File coverageDir, int timeoutInMs, @NonNull Collection<String> installOptions, @NonNull ILogger logger) {
        this.projectName = projectName;
        this.device = device;
        this.flavorName = flavorName;
        this.resultsDir = resultsDir;
        this.coverageDir = coverageDir;
        this.testApk = testApk;
        this.testedApks = testedApks;
        this.testData = testData;
        this.adbExec = adbExec;
        this.timeoutInMs = timeoutInMs;
        this.installOptions = installOptions;
        this.logger = logger;
    }

    @Override
    public Boolean call() throws Exception {
        Boolean fakeRunListener2;
        block23: {
            String deviceName;
            block24: {
                String temporaryCoverageCopy;
                TestRunResult testRunResult;
                String coverageFile;
                boolean success;
                long time;
                CustomTestRunListener runListener;
                boolean isInstalled;
                block20: {
                    Boolean bl;
                    block21: {
                        block22: {
                            deviceName = this.device.getName();
                            isInstalled = false;
                            runListener = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
                            runListener.setReportDir(this.resultsDir);
                            time = System.currentTimeMillis();
                            success = false;
                            coverageFile = "/data/data/" + this.testData.getTestedApplicationId() + "/" + FILE_COVERAGE_EC;
                            this.device.connect(this.timeoutInMs, this.logger);
                            if (!this.testedApks.isEmpty()) {
                                this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, Joiner.on((char)',').join(this.testedApks)});
                                if (this.testedApks.size() > 1 && this.device.getApiLevel() < 21) {
                                    throw new InstallException("Internal error, file a bug, multi-apk applications require a device with API level 21+");
                                }
                                if (this.device.getApiLevel() >= 21) {
                                    this.device.installPackages(this.testedApks, (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                                } else {
                                    this.device.installPackage(this.testedApks.get(0), (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                                }
                            }
                            this.logger.verbose("DeviceConnector '%s': installing %s", new Object[]{deviceName, this.testApk});
                            if (this.device.getApiLevel() >= 21) {
                                this.device.installPackages((List)ImmutableList.of((Object)this.testApk), (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                            } else {
                                this.device.installPackage(this.testApk, (Collection)ImmutableList.of(), this.timeoutInMs, this.logger);
                            }
                            isInstalled = true;
                            RemoteAndroidTestRunner runner = new RemoteAndroidTestRunner(this.testData.getApplicationId(), this.testData.getInstrumentationRunner(), (IShellEnabledDevice)this.device);
                            if (this.testData.isTestCoverageEnabled()) {
                                runner.addInstrumentationArg("coverage", "true");
                                runner.addInstrumentationArg("coverageFile", coverageFile);
                            }
                            runner.setRunName(deviceName);
                            runner.setMaxtimeToOutputResponse(this.timeoutInMs);
                            runner.run(new ITestRunListener[]{runListener});
                            testRunResult = runListener.getRunResult();
                            success = true;
                            if (testRunResult.getNumTests() != 0) break block20;
                            CustomTestRunListener fakeRunListener2 = new CustomTestRunListener(deviceName, this.projectName, this.flavorName, this.logger);
                            fakeRunListener2.setReportDir(this.resultsDir);
                            Map<String, String> emptyMetrics = Collections.emptyMap();
                            TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "No tests found.");
                            fakeRunListener2.testStarted(fakeTest);
                            fakeRunListener2.testFailed(fakeTest, "No tests found. This usually means that your test classes are not in the form that your test runner expects (e.g. don't inherit from TestCase or lack @Test annotations).");
                            fakeRunListener2.testEnded(fakeTest, emptyMetrics);
                            fakeRunListener2.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
                            bl = false;
                            if (!isInstalled) break block21;
                            if (!success || !this.testData.isTestCoverageEnabled()) break block22;
                            String temporaryCoverageCopy2 = "/data/local/tmp/" + this.testData.getTestedApplicationId() + "." + FILE_COVERAGE_EC;
                            MultiLineReceiver outputReceiver = new MultiLineReceiver(){

                                public void processNewLines(String[] lines) {
                                    for (String line : lines) {
                                        SimpleTestCallable.this.logger.info(line, new Object[0]);
                                    }
                                }

                                public boolean isCancelled() {
                                    return false;
                                }
                            };
                            this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
                            this.device.executeShellCommand("run-as " + this.testData.getTestedApplicationId() + " cat " + coverageFile + " | cat > " + temporaryCoverageCopy2, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                            this.device.pullFile(temporaryCoverageCopy2, new File(this.coverageDir, FILE_COVERAGE_EC).getPath());
                            this.device.executeShellCommand("rm " + temporaryCoverageCopy2, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                        }
                        this.uninstall(this.testApk, this.testData.getApplicationId(), deviceName);
                        if (!this.testedApks.isEmpty()) {
                            for (File testedApk : this.testedApks) {
                                this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                            }
                        }
                    }
                    this.device.disconnect(this.timeoutInMs, this.logger);
                    return bl;
                }
                try {
                    fakeRunListener2 = !testRunResult.hasFailedTests();
                    if (!isInstalled) break block23;
                    if (!success || !this.testData.isTestCoverageEnabled()) break block24;
                    temporaryCoverageCopy = "/data/local/tmp/" + this.testData.getTestedApplicationId() + "." + FILE_COVERAGE_EC;
                }
                catch (Exception e) {
                    try {
                        Map<String, String> emptyMetrics = Collections.emptyMap();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        PrintWriter pw = new PrintWriter(baos, true);
                        e.printStackTrace(pw);
                        TestIdentifier fakeTest = new TestIdentifier(this.device.getClass().getName(), "runTests");
                        runListener.testStarted(fakeTest);
                        runListener.testFailed(fakeTest, baos.toString());
                        runListener.testEnded(fakeTest, emptyMetrics);
                        runListener.testRunEnded(System.currentTimeMillis() - time, emptyMetrics);
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (isInstalled) {
                            if (success && this.testData.isTestCoverageEnabled()) {
                                String temporaryCoverageCopy3 = "/data/local/tmp/" + this.testData.getTestedApplicationId() + "." + FILE_COVERAGE_EC;
                                MultiLineReceiver outputReceiver = new /* invalid duplicate definition of identical inner class */;
                                this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
                                this.device.executeShellCommand("run-as " + this.testData.getTestedApplicationId() + " cat " + coverageFile + " | cat > " + temporaryCoverageCopy3, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                                this.device.pullFile(temporaryCoverageCopy3, new File(this.coverageDir, FILE_COVERAGE_EC).getPath());
                                this.device.executeShellCommand("rm " + temporaryCoverageCopy3, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                            }
                            this.uninstall(this.testApk, this.testData.getApplicationId(), deviceName);
                            if (!this.testedApks.isEmpty()) {
                                for (File testedApk : this.testedApks) {
                                    this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                                }
                            }
                        }
                        this.device.disconnect(this.timeoutInMs, this.logger);
                        throw throwable;
                    }
                }
                MultiLineReceiver outputReceiver = new /* invalid duplicate definition of identical inner class */;
                this.logger.verbose("DeviceConnector '%s': fetching coverage data from %s", new Object[]{deviceName, coverageFile});
                this.device.executeShellCommand("run-as " + this.testData.getTestedApplicationId() + " cat " + coverageFile + " | cat > " + temporaryCoverageCopy, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
                this.device.pullFile(temporaryCoverageCopy, new File(this.coverageDir, FILE_COVERAGE_EC).getPath());
                this.device.executeShellCommand("rm " + temporaryCoverageCopy, (IShellOutputReceiver)outputReceiver, 30L, TimeUnit.SECONDS);
            }
            this.uninstall(this.testApk, this.testData.getApplicationId(), deviceName);
            if (!this.testedApks.isEmpty()) {
                for (File testedApk : this.testedApks) {
                    this.uninstall(testedApk, this.testData.getTestedApplicationId(), deviceName);
                }
            }
        }
        this.device.disconnect(this.timeoutInMs, this.logger);
        return fakeRunListener2;
    }

    private void uninstall(@NonNull File apkFile, @Nullable String packageName, @NonNull String deviceName) throws DeviceException {
        if (packageName != null) {
            this.logger.verbose("DeviceConnector '%s': uninstalling %s", new Object[]{deviceName, packageName});
            this.device.uninstallPackage(packageName, this.timeoutInMs, this.logger);
        } else {
            this.logger.verbose("DeviceConnector '%s': unable to uninstall %s: unable to get package name", new Object[]{deviceName, apkFile});
        }
    }
}

