/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.DefaultBuildType;
import com.android.builder.DefaultManifestParser;
import com.android.builder.DefaultProductFlavor;
import com.android.builder.ManifestParser;
import com.android.builder.dependency.DependencyContainer;
import com.android.builder.dependency.JarDependency;
import com.android.builder.dependency.LibraryDependency;
import com.android.builder.model.SourceProvider;
import com.android.builder.signing.SigningConfig;
import com.android.builder.testing.TestData;
import com.android.ide.common.res2.AssetSet;
import com.android.ide.common.res2.ResourceSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VariantConfiguration
implements TestData {
    private static final ManifestParser sManifestParser = new DefaultManifestParser();
    private final DefaultProductFlavor mDefaultConfig;
    private final SourceProvider mDefaultSourceProvider;
    private final DefaultBuildType mBuildType;
    private final SourceProvider mBuildTypeSourceProvider;
    private final List<DefaultProductFlavor> mFlavorConfigs = Lists.newArrayList();
    private final List<SourceProvider> mFlavorSourceProviders = Lists.newArrayList();
    private final Type mType;
    private final VariantConfiguration mTestedConfig;
    private final String mDebugName;
    private LibraryDependency mOutput;
    private DefaultProductFlavor mMergedFlavor;
    private final Set<JarDependency> mJars = Sets.newHashSet();
    private final List<LibraryDependency> mDirectLibraries = Lists.newArrayList();
    private final List<LibraryDependency> mFlatLibraries = Lists.newArrayList();
    private static final String DEFAULT_TEST_RUNNER = "android.test.InstrumentationTestRunner";

    @Nullable
    public static String getManifestPackage(@NonNull File manifestFile) {
        return sManifestParser.getPackage(manifestFile);
    }

    public VariantConfiguration(@NonNull DefaultProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull DefaultBuildType buildType, @NonNull SourceProvider buildTypeSourceProvider, @Nullable String debugName) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, Type.DEFAULT, null, debugName);
    }

    public VariantConfiguration(@NonNull DefaultProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull DefaultBuildType buildType, @NonNull SourceProvider buildTypeSourceProvider, @NonNull Type type, @Nullable String debugName) {
        this(defaultConfig, defaultSourceProvider, buildType, buildTypeSourceProvider, type, null, debugName);
    }

    public VariantConfiguration(@NonNull DefaultProductFlavor defaultConfig, @NonNull SourceProvider defaultSourceProvider, @NonNull DefaultBuildType buildType, SourceProvider buildTypeSourceProvider, @NonNull Type type, @Nullable VariantConfiguration testedConfig, @Nullable String debugName) {
        this.mDefaultConfig = (DefaultProductFlavor)Preconditions.checkNotNull((Object)defaultConfig);
        this.mDefaultSourceProvider = (SourceProvider)Preconditions.checkNotNull((Object)defaultSourceProvider);
        this.mBuildType = (DefaultBuildType)Preconditions.checkNotNull((Object)buildType);
        this.mBuildTypeSourceProvider = buildTypeSourceProvider;
        this.mType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.mTestedConfig = testedConfig;
        this.mDebugName = debugName;
        Preconditions.checkState((this.mType != Type.TEST || this.mTestedConfig != null ? 1 : 0) != 0);
        this.mMergedFlavor = this.mDefaultConfig;
        if (testedConfig != null && testedConfig.mType == Type.LIBRARY && testedConfig.mOutput != null) {
            this.mDirectLibraries.add(testedConfig.mOutput);
        }
        this.validate();
    }

    @NonNull
    public VariantConfiguration addProductFlavor(@NonNull DefaultProductFlavor productFlavor, @NonNull SourceProvider sourceProvider) {
        this.mFlavorConfigs.add(productFlavor);
        this.mFlavorSourceProviders.add(sourceProvider);
        this.mMergedFlavor = productFlavor.mergeOver(this.mMergedFlavor);
        return this;
    }

    @NonNull
    public VariantConfiguration setDependencies(@NonNull List<? extends DependencyContainer> containers) {
        for (DependencyContainer dependencyContainer : containers) {
            this.mDirectLibraries.addAll(dependencyContainer.getAndroidDependencies());
            this.mJars.addAll(dependencyContainer.getJarDependencies());
            this.mJars.addAll(dependencyContainer.getLocalDependencies());
        }
        this.resolveIndirectLibraryDependencies(this.mDirectLibraries, this.mFlatLibraries);
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            this.mJars.addAll(libraryDependency.getLocalDependencies());
        }
        return this;
    }

    @NonNull
    public Collection<JarDependency> getJars() {
        return this.mJars;
    }

    @NonNull
    public VariantConfiguration setOutput(LibraryDependency output) {
        this.mOutput = output;
        return this;
    }

    @NonNull
    public DefaultProductFlavor getDefaultConfig() {
        return this.mDefaultConfig;
    }

    @NonNull
    public SourceProvider getDefaultSourceSet() {
        return this.mDefaultSourceProvider;
    }

    @NonNull
    public DefaultProductFlavor getMergedFlavor() {
        return this.mMergedFlavor;
    }

    @NonNull
    public DefaultBuildType getBuildType() {
        return this.mBuildType;
    }

    @Nullable
    public SourceProvider getBuildTypeSourceSet() {
        return this.mBuildTypeSourceProvider;
    }

    public boolean hasFlavors() {
        return !this.mFlavorConfigs.isEmpty();
    }

    @NonNull
    public List<DefaultProductFlavor> getFlavorConfigs() {
        return this.mFlavorConfigs;
    }

    @NonNull
    public Iterable<SourceProvider> getFlavorSourceSets() {
        return this.mFlavorSourceProviders;
    }

    public boolean hasLibraries() {
        return !this.mDirectLibraries.isEmpty();
    }

    @NonNull
    public List<LibraryDependency> getDirectLibraries() {
        return this.mDirectLibraries;
    }

    @NonNull
    public List<LibraryDependency> getAllLibraries() {
        return this.mFlatLibraries;
    }

    @NonNull
    public Type getType() {
        return this.mType;
    }

    @Nullable
    public VariantConfiguration getTestedConfig() {
        return this.mTestedConfig;
    }

    void resolveIndirectLibraryDependencies(List<LibraryDependency> directDependencies, List<LibraryDependency> outFlatDependencies) {
        if (directDependencies == null) {
            return;
        }
        for (int i = directDependencies.size() - 1; i >= 0; --i) {
            LibraryDependency library = directDependencies.get(i);
            List<LibraryDependency> dependencies = library.getDependencies();
            this.resolveIndirectLibraryDependencies(dependencies, outFlatDependencies);
            if (outFlatDependencies.contains(library)) continue;
            outFlatDependencies.add(0, library);
        }
    }

    @Nullable
    public String getOriginalPackageName() {
        if (this.mType == Type.TEST) {
            return this.getPackageName();
        }
        return this.getPackageFromManifest();
    }

    @Override
    @Nullable
    public String getPackageName() {
        String packageName;
        if (this.mType == Type.TEST) {
            packageName = this.mMergedFlavor.getTestPackageName();
            if (packageName == null) {
                String testedPackage = this.mTestedConfig.getPackageName();
                packageName = testedPackage + ".test";
            }
        } else {
            packageName = this.getPackageOverride();
            if (packageName == null) {
                packageName = this.getPackageFromManifest();
            }
        }
        return packageName;
    }

    @Override
    @Nullable
    public String getTestedPackageName() {
        if (this.mType == Type.TEST) {
            if (this.mTestedConfig.mType == Type.LIBRARY) {
                return this.getPackageName();
            }
            return this.mTestedConfig.getPackageName();
        }
        return null;
    }

    @Nullable
    public String getPackageOverride() {
        String packageName = this.mMergedFlavor.getPackageName();
        String packageSuffix = this.mBuildType.getPackageNameSuffix();
        if (packageSuffix != null && packageSuffix.length() > 0) {
            if (packageName == null) {
                packageName = this.getPackageFromManifest();
            }
            packageName = packageSuffix.charAt(0) == '.' ? packageName + packageSuffix : packageName + '.' + packageSuffix;
        }
        return packageName;
    }

    @Nullable
    public String getVersionName() {
        String versionName = this.mMergedFlavor.getVersionName();
        String versionSuffix = this.mBuildType.getVersionNameSuffix();
        if (versionSuffix != null && versionSuffix.length() > 0) {
            if (versionName == null) {
                versionName = this.getVersionNameFromManifest();
            }
            versionName = versionName + versionSuffix;
        }
        return versionName;
    }

    @Override
    @NonNull
    public String getInstrumentationRunner() {
        String runner;
        VariantConfiguration config = this;
        if (this.mType == Type.TEST) {
            config = this.getTestedConfig();
        }
        return (runner = config.mMergedFlavor.getTestInstrumentationRunner()) != null ? runner : DEFAULT_TEST_RUNNER;
    }

    @Nullable
    public String getPackageFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getPackage(manifestLocation);
    }

    @Nullable
    public String getVersionNameFromManifest() {
        File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
        return sManifestParser.getVersionName(manifestLocation);
    }

    @Override
    public int getMinSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getMinSdkVersion();
        }
        int minSdkVersion = this.mMergedFlavor.getMinSdkVersion();
        if (minSdkVersion == -1) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            minSdkVersion = sManifestParser.getMinSdkVersion(manifestLocation);
        }
        return minSdkVersion;
    }

    public int getTargetSdkVersion() {
        if (this.mTestedConfig != null) {
            return this.mTestedConfig.getTargetSdkVersion();
        }
        int targetSdkVersion = this.mMergedFlavor.getTargetSdkVersion();
        if (targetSdkVersion == -1) {
            File manifestLocation = this.mDefaultSourceProvider.getManifestFile();
            targetSdkVersion = sManifestParser.getTargetSdkVersion(manifestLocation);
        }
        return targetSdkVersion;
    }

    @Nullable
    public File getMainManifest() {
        File defaultManifest = this.mDefaultSourceProvider.getManifestFile();
        if (defaultManifest.isFile()) {
            return defaultManifest;
        }
        return null;
    }

    @NonNull
    public List<File> getManifestOverlays() {
        File typeLocation;
        ArrayList inputs = Lists.newArrayList();
        if (this.mBuildTypeSourceProvider != null && (typeLocation = this.mBuildTypeSourceProvider.getManifestFile()).isFile()) {
            inputs.add(typeLocation);
        }
        for (SourceProvider sourceProvider : this.mFlavorSourceProviders) {
            File f = sourceProvider.getManifestFile();
            if (!f.isFile()) continue;
            inputs.add(f);
        }
        return inputs;
    }

    @NonNull
    public List<ResourceSet> getResourceSets(@Nullable File generatedResFolder) {
        ArrayList resourceSets = Lists.newArrayList();
        for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
            LibraryDependency dependency = this.mFlatLibraries.get(n);
            File resFolder = dependency.getResFolder();
            if (!resFolder.isDirectory()) continue;
            ResourceSet resourceSet = new ResourceSet(dependency.getFolder().getName());
            resourceSet.addSource(resFolder);
            resourceSets.add(resourceSet);
        }
        Set mainResDirs = this.mDefaultSourceProvider.getResDirectories();
        ResourceSet resourceSet = new ResourceSet("main");
        resourceSet.addSources((Collection)mainResDirs);
        if (generatedResFolder != null) {
            resourceSet.addSource(generatedResFolder);
        }
        resourceSets.add(resourceSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Set flavorResDirs = sourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.mFlavorConfigs.get(n).getName());
            resourceSet.addSources((Collection)flavorResDirs);
            resourceSets.add(resourceSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Set typeResDirs = this.mBuildTypeSourceProvider.getResDirectories();
            resourceSet = new ResourceSet(this.mBuildType.getName());
            resourceSet.addSources((Collection)typeResDirs);
            resourceSets.add(resourceSet);
        }
        return resourceSets;
    }

    @NonNull
    public List<AssetSet> getAssetSets() {
        ArrayList assetSets = Lists.newArrayList();
        for (int n = this.mFlatLibraries.size() - 1; n >= 0; --n) {
            LibraryDependency dependency = this.mFlatLibraries.get(n);
            File assetFolder = dependency.getAssetsFolder();
            if (!assetFolder.isDirectory()) continue;
            AssetSet assetSet = new AssetSet(dependency.getFolder().getName());
            assetSet.addSource(assetFolder);
            assetSets.add(assetSet);
        }
        Set mainResDirs = this.mDefaultSourceProvider.getAssetsDirectories();
        AssetSet assetSet = new AssetSet("main");
        assetSet.addSources((Collection)mainResDirs);
        assetSets.add(assetSet);
        for (int n = this.mFlavorSourceProviders.size() - 1; n >= 0; --n) {
            SourceProvider sourceProvider = this.mFlavorSourceProviders.get(n);
            Set flavorResDirs = sourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mFlavorConfigs.get(n).getName());
            assetSet.addSources((Collection)flavorResDirs);
            assetSets.add(assetSet);
        }
        if (this.mBuildTypeSourceProvider != null) {
            Set typeResDirs = this.mBuildTypeSourceProvider.getAssetsDirectories();
            assetSet = new AssetSet(this.mBuildType.getName());
            assetSet.addSources((Collection)typeResDirs);
            assetSets.add(assetSet);
        }
        return assetSets;
    }

    @NonNull
    public List<File> getRenderscriptImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File rsLib = lib.getRenderscriptFolder();
            if (!rsLib.isDirectory()) continue;
            list.add(rsLib);
        }
        return list;
    }

    @NonNull
    public List<File> getRenderscriptSourceList() {
        ArrayList sourceList = Lists.newArrayList();
        sourceList.addAll(this.mDefaultSourceProvider.getRenderscriptDirectories());
        if (this.mType != Type.TEST) {
            sourceList.addAll(this.mBuildTypeSourceProvider.getRenderscriptDirectories());
        }
        if (this.hasFlavors()) {
            for (SourceProvider flavorSourceSet : this.mFlavorSourceProviders) {
                sourceList.addAll(flavorSourceSet.getRenderscriptDirectories());
            }
        }
        return sourceList;
    }

    @NonNull
    public List<File> getAidlImports() {
        ArrayList list = Lists.newArrayList();
        for (LibraryDependency lib : this.mFlatLibraries) {
            File aidlLib = lib.getAidlFolder();
            if (!aidlLib.isDirectory()) continue;
            list.add(aidlLib);
        }
        return list;
    }

    @NonNull
    public List<File> getAidlSourceList() {
        ArrayList sourceList = Lists.newArrayList();
        sourceList.addAll(this.mDefaultSourceProvider.getAidlDirectories());
        if (this.mType != Type.TEST) {
            sourceList.addAll(this.mBuildTypeSourceProvider.getAidlDirectories());
        }
        if (this.hasFlavors()) {
            for (SourceProvider flavorSourceSet : this.mFlavorSourceProviders) {
                sourceList.addAll(flavorSourceSet.getAidlDirectories());
            }
        }
        return sourceList;
    }

    @NonNull
    public Set<File> getCompileClasspath() {
        HashSet classpath = Sets.newHashSet();
        for (LibraryDependency lib : this.mFlatLibraries) {
            classpath.add(lib.getJarFile());
            for (File jarFile : lib.getLocalJars()) {
                classpath.add(jarFile);
            }
        }
        for (JarDependency jar : this.mJars) {
            if (!jar.isCompiled()) continue;
            classpath.add(jar.getJarFile());
        }
        return classpath;
    }

    @NonNull
    public List<File> getPackagedJars() {
        ArrayList jars = Lists.newArrayListWithCapacity((int)(this.mJars.size() + this.mFlatLibraries.size()));
        for (JarDependency jar : this.mJars) {
            File jarFile = jar.getJarFile();
            if (!jar.isPackaged() || !jarFile.exists()) continue;
            jars.add(jarFile);
        }
        for (LibraryDependency libraryDependency : this.mFlatLibraries) {
            File libJar = libraryDependency.getJarFile();
            if (libJar.exists()) {
                jars.add(libJar);
            }
            for (File jarFile : libraryDependency.getLocalJars()) {
                if (!jarFile.isFile()) continue;
                jars.add(jarFile);
            }
        }
        return jars;
    }

    @NonNull
    public List<String> getBuildConfigLines() {
        ArrayList fullList = Lists.newArrayList();
        List<String> list = this.mDefaultConfig.getBuildConfig();
        if (!list.isEmpty()) {
            fullList.add("// lines from default config.");
            fullList.addAll(list);
        }
        if (!(list = this.mBuildType.getBuildConfig()).isEmpty()) {
            fullList.add("// lines from build type: " + this.mBuildType.getName());
            fullList.addAll(list);
        }
        for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
            list = flavor.getBuildConfig();
            if (list.isEmpty()) continue;
            fullList.add("// lines from product flavor: " + flavor.getName());
            fullList.addAll(list);
        }
        return fullList;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        SigningConfig signingConfig = this.mBuildType.getSigningConfig();
        if (signingConfig != null) {
            return signingConfig;
        }
        return this.mMergedFlavor.getSigningConfig();
    }

    public boolean isSigningReady() {
        SigningConfig signingConfig = this.getSigningConfig();
        return signingConfig != null && signingConfig.isSigningReady();
    }

    @NonNull
    public List<Object> getProguardFiles(boolean includeLibraries) {
        ArrayList fullList = Lists.newArrayList();
        fullList.addAll(this.mDefaultConfig.getProguardFiles());
        fullList.addAll(this.mBuildType.getProguardFiles());
        for (DefaultProductFlavor flavor : this.mFlavorConfigs) {
            fullList.addAll(flavor.getProguardFiles());
        }
        if (includeLibraries) {
            for (LibraryDependency libraryDependency : this.mFlatLibraries) {
                File proguardRules = libraryDependency.getProguardRules();
                if (!proguardRules.exists()) continue;
                fullList.add(proguardRules);
            }
        }
        return fullList;
    }

    protected void validate() {
        File manifest;
        if (this.mType != Type.TEST && !(manifest = this.mDefaultSourceProvider.getManifestFile()).isFile()) {
            throw new IllegalArgumentException("Main Manifest missing from " + manifest.getAbsolutePath());
        }
    }

    @Override
    @Nullable
    public Set<String> getSupportedAbis() {
        return null;
    }

    public static enum Type {
        DEFAULT,
        LIBRARY,
        TEST;

    }
}

