/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.annotations.Nullable;
import com.android.ide.common.internal.WaitableExecutor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public class SourceSearcher {
    private final List<File> mSourceFolders;
    private final String[] mExtensions;
    @Nullable
    private WaitableExecutor<Void> mExecutor;

    public SourceSearcher(List<File> sourceFolders, String ... extensions) {
        this.mSourceFolders = sourceFolders;
        this.mExtensions = extensions;
    }

    public void setUseExecutor(boolean useExecutor) {
        this.mExecutor = useExecutor ? new WaitableExecutor() : null;
    }

    public void search(SourceFileProcessor processor) throws IOException, InterruptedException, ExecutionException {
        for (File file : this.mSourceFolders) {
            this.processFile(file, processor);
        }
        if (this.mExecutor != null) {
            try {
                this.mExecutor.waitForTasksWithQuickFail();
            }
            catch (InterruptedException e) {
                this.mExecutor.cancelAllTasks();
                throw e;
            }
            catch (ExecutionException e) {
                this.mExecutor.cancelAllTasks();
                throw e;
            }
        }
    }

    private void processFile(final File file, final SourceFileProcessor processor) throws IOException, InterruptedException {
        File[] children;
        if (file.isFile()) {
            if (this.checkExtension(file)) {
                if (this.mExecutor != null) {
                    this.mExecutor.execute((Callable)new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            processor.processFile(file);
                            return null;
                        }
                    });
                } else {
                    processor.processFile(file);
                }
            }
        } else if (file.isDirectory() && (children = file.listFiles()) != null) {
            for (File child : children) {
                this.processFile(child, processor);
            }
        }
    }

    private boolean checkExtension(File file) {
        if (this.mExtensions.length == 0) {
            return true;
        }
        String filename = file.getName();
        int pos = filename.indexOf(46);
        if (pos != -1) {
            String extension = filename.substring(pos + 1);
            for (String ext : this.mExtensions) {
                if (!ext.equalsIgnoreCase(extension)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface SourceFileProcessor {
        public void processFile(File var1) throws IOException, InterruptedException;
    }
}

