/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.png;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;

class TickException
extends Exception {
    private final int mPixelLocation;
    @Nullable
    private final Integer mPixelColor;

    static TickException createWithColor(@NonNull String message, int color) {
        return new TickException(message, -1, color);
    }

    TickException(@NonNull String message, int pixelLocation, @Nullable Integer pixelColor) {
        super(message);
        this.mPixelLocation = pixelLocation;
        this.mPixelColor = pixelColor;
    }

    TickException(@NonNull String message) {
        this(message, -1, null);
    }

    TickException(@NonNull TickException tickException, int pixelLocation) {
        this(tickException.getMessage(), pixelLocation, tickException.getPixelColor());
    }

    int getPixelLocation() {
        return this.mPixelLocation;
    }

    @Nullable
    Integer getPixelColor() {
        return this.mPixelColor;
    }
}

