/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.model.NdkConfig;
import com.google.common.collect.Sets;
import java.util.Set;

public class MergedNdkConfig
implements NdkConfig {
    private String moduleName;
    private String cFlags;
    private Set<String> ldLibs;
    private Set<String> abiFilters;
    private String stl;

    public void reset() {
        this.moduleName = null;
        this.cFlags = null;
        this.ldLibs = null;
        this.abiFilters = null;
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    @Nullable
    public String getcFlags() {
        return this.cFlags;
    }

    @Nullable
    public Set<String> getLdLibs() {
        return this.ldLibs;
    }

    @Nullable
    public Set<String> getAbiFilters() {
        return this.abiFilters;
    }

    @Nullable
    public String getStl() {
        return this.stl;
    }

    public void append(@NonNull NdkConfig ndkConfig) {
        if (ndkConfig.getModuleName() != null) {
            this.moduleName = ndkConfig.getModuleName();
        }
        if (ndkConfig.getStl() != null) {
            this.stl = ndkConfig.getStl();
        }
        if (ndkConfig.getAbiFilters() != null) {
            if (this.abiFilters == null) {
                this.abiFilters = Sets.newHashSetWithExpectedSize((int)ndkConfig.getAbiFilters().size());
            } else {
                this.abiFilters.clear();
            }
            this.abiFilters.addAll(ndkConfig.getAbiFilters());
        }
        if (this.cFlags == null) {
            this.cFlags = ndkConfig.getcFlags();
        } else if (ndkConfig.getcFlags() != null) {
            this.cFlags = this.cFlags + " " + ndkConfig.getcFlags();
        }
        if (ndkConfig.getLdLibs() != null) {
            if (this.ldLibs == null) {
                this.ldLibs = Sets.newHashSetWithExpectedSize((int)ndkConfig.getLdLibs().size());
            } else {
                this.ldLibs.clear();
            }
            this.ldLibs.addAll(ndkConfig.getLdLibs());
        }
    }
}

