/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.core.ManifestParser;
import com.android.io.FileWrapper;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.utils.XmlUtils;
import com.android.xml.AndroidManifest;
import com.android.xml.AndroidXPathFactory;
import java.io.File;
import java.io.IOException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.xml.sax.InputSource;

public class DefaultManifestParser
implements ManifestParser {
    @Override
    @Nullable
    public String getPackage(@NonNull File manifestFile) {
        return DefaultManifestParser.getStringValue(manifestFile, "/manifest/@package");
    }

    @Override
    @Nullable
    public String getVersionName(@NonNull File manifestFile) {
        return DefaultManifestParser.getStringValue(manifestFile, "/manifest/@android:versionName");
    }

    @Override
    public int getVersionCode(@NonNull File manifestFile) {
        try {
            String value = DefaultManifestParser.getStringValue(manifestFile, "/manifest/@android:versionCode");
            if (value != null) {
                return Integer.valueOf(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    @Override
    public Object getMinSdkVersion(@NonNull File manifestFile) {
        try {
            return AndroidManifest.getMinSdkVersion((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (XPathExpressionException e) {
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return 1;
    }

    @Override
    public Object getTargetSdkVersion(@NonNull File manifestFile) {
        try {
            return AndroidManifest.getTargetSdkVersion((IAbstractFile)new FileWrapper(manifestFile));
        }
        catch (XPathExpressionException e) {
        }
        catch (StreamException e) {
            throw new RuntimeException(e);
        }
        return -1;
    }

    private static String getStringValue(@NonNull File file, @NonNull String xPath) {
        XPath xpath = AndroidXPathFactory.newXPath();
        try {
            InputSource source = new InputSource(XmlUtils.getUtfReader((File)file));
            return xpath.evaluate(xPath, source);
        }
        catch (XPathExpressionException e) {
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

