/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.securityhub.model.transform.IntegerListConfigurationOptionsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IntegerListConfigurationOptions
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Integer> defaultValue;
    private Integer min;
    private Integer max;
    private Integer maxItems;

    public List<Integer> getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Collection<Integer> defaultValue) {
        if (defaultValue == null) {
            this.defaultValue = null;
            return;
        }
        this.defaultValue = new ArrayList<Integer>(defaultValue);
    }

    public IntegerListConfigurationOptions withDefaultValue(Integer ... defaultValue) {
        if (this.defaultValue == null) {
            this.setDefaultValue(new ArrayList<Integer>(defaultValue.length));
        }
        for (Integer ele : defaultValue) {
            this.defaultValue.add(ele);
        }
        return this;
    }

    public IntegerListConfigurationOptions withDefaultValue(Collection<Integer> defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public Integer getMin() {
        return this.min;
    }

    public IntegerListConfigurationOptions withMin(Integer min) {
        this.setMin(min);
        return this;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getMax() {
        return this.max;
    }

    public IntegerListConfigurationOptions withMax(Integer max) {
        this.setMax(max);
        return this;
    }

    public void setMaxItems(Integer maxItems) {
        this.maxItems = maxItems;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public IntegerListConfigurationOptions withMaxItems(Integer maxItems) {
        this.setMaxItems(maxItems);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getMin() != null) {
            sb.append("Min: ").append(this.getMin()).append(",");
        }
        if (this.getMax() != null) {
            sb.append("Max: ").append(this.getMax()).append(",");
        }
        if (this.getMaxItems() != null) {
            sb.append("MaxItems: ").append(this.getMaxItems());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerListConfigurationOptions)) {
            return false;
        }
        IntegerListConfigurationOptions other = (IntegerListConfigurationOptions)obj;
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getMin() == null ^ this.getMin() == null) {
            return false;
        }
        if (other.getMin() != null && !other.getMin().equals(this.getMin())) {
            return false;
        }
        if (other.getMax() == null ^ this.getMax() == null) {
            return false;
        }
        if (other.getMax() != null && !other.getMax().equals(this.getMax())) {
            return false;
        }
        if (other.getMaxItems() == null ^ this.getMaxItems() == null) {
            return false;
        }
        return other.getMaxItems() == null || other.getMaxItems().equals(this.getMaxItems());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getMin() == null ? 0 : this.getMin().hashCode());
        hashCode = 31 * hashCode + (this.getMax() == null ? 0 : this.getMax().hashCode());
        hashCode = 31 * hashCode + (this.getMaxItems() == null ? 0 : this.getMaxItems().hashCode());
        return hashCode;
    }

    public IntegerListConfigurationOptions clone() {
        try {
            return (IntegerListConfigurationOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IntegerListConfigurationOptionsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

