/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.DescribeUsageLimitsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeUsageLimitsRequestMarshaller
implements Marshaller<Request<DescribeUsageLimitsRequest>, DescribeUsageLimitsRequest> {
    public Request<DescribeUsageLimitsRequest> marshall(DescribeUsageLimitsRequest describeUsageLimitsRequest) {
        if (describeUsageLimitsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeUsageLimitsRequest, "AmazonRedshift");
        request.addParameter("Action", "DescribeUsageLimits");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeUsageLimitsRequest.getUsageLimitId() != null) {
            request.addParameter("UsageLimitId", StringUtils.fromString((String)describeUsageLimitsRequest.getUsageLimitId()));
        }
        if (describeUsageLimitsRequest.getClusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)describeUsageLimitsRequest.getClusterIdentifier()));
        }
        if (describeUsageLimitsRequest.getFeatureType() != null) {
            request.addParameter("FeatureType", StringUtils.fromString((String)describeUsageLimitsRequest.getFeatureType()));
        }
        if (describeUsageLimitsRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeUsageLimitsRequest.getMaxRecords()));
        }
        if (describeUsageLimitsRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeUsageLimitsRequest.getMarker()));
        }
        if (!describeUsageLimitsRequest.getTagKeys().isEmpty() || !((SdkInternalList)describeUsageLimitsRequest.getTagKeys()).isAutoConstruct()) {
            SdkInternalList tagKeysList = (SdkInternalList)describeUsageLimitsRequest.getTagKeys();
            int tagKeysListIndex = 1;
            for (String tagKeysListValue : tagKeysList) {
                if (tagKeysListValue != null) {
                    request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                }
                ++tagKeysListIndex;
            }
        }
        if (!describeUsageLimitsRequest.getTagValues().isEmpty() || !((SdkInternalList)describeUsageLimitsRequest.getTagValues()).isAutoConstruct()) {
            SdkInternalList tagValuesList = (SdkInternalList)describeUsageLimitsRequest.getTagValues();
            int tagValuesListIndex = 1;
            for (String tagValuesListValue : tagValuesList) {
                if (tagValuesListValue != null) {
                    request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                }
                ++tagValuesListIndex;
            }
        }
        return request;
    }
}

