/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.quicksight.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.quicksight.model.TopicIR;
import com.amazonaws.services.quicksight.model.VisualRole;
import com.amazonaws.services.quicksight.model.transform.TopicVisualMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TopicVisual
implements Serializable,
Cloneable,
StructuredPojo {
    private String visualId;
    private String role;
    private TopicIR ir;
    private List<TopicVisual> supportingVisuals;

    public void setVisualId(String visualId) {
        this.visualId = visualId;
    }

    public String getVisualId() {
        return this.visualId;
    }

    public TopicVisual withVisualId(String visualId) {
        this.setVisualId(visualId);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public TopicVisual withRole(String role) {
        this.setRole(role);
        return this;
    }

    public TopicVisual withRole(VisualRole role) {
        this.role = role.toString();
        return this;
    }

    public void setIr(TopicIR ir) {
        this.ir = ir;
    }

    public TopicIR getIr() {
        return this.ir;
    }

    public TopicVisual withIr(TopicIR ir) {
        this.setIr(ir);
        return this;
    }

    public List<TopicVisual> getSupportingVisuals() {
        return this.supportingVisuals;
    }

    public void setSupportingVisuals(Collection<TopicVisual> supportingVisuals) {
        if (supportingVisuals == null) {
            this.supportingVisuals = null;
            return;
        }
        this.supportingVisuals = new ArrayList<TopicVisual>(supportingVisuals);
    }

    public TopicVisual withSupportingVisuals(TopicVisual ... supportingVisuals) {
        if (this.supportingVisuals == null) {
            this.setSupportingVisuals(new ArrayList<TopicVisual>(supportingVisuals.length));
        }
        for (TopicVisual ele : supportingVisuals) {
            this.supportingVisuals.add(ele);
        }
        return this;
    }

    public TopicVisual withSupportingVisuals(Collection<TopicVisual> supportingVisuals) {
        this.setSupportingVisuals(supportingVisuals);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVisualId() != null) {
            sb.append("VisualId: ").append(this.getVisualId()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getIr() != null) {
            sb.append("Ir: ").append(this.getIr()).append(",");
        }
        if (this.getSupportingVisuals() != null) {
            sb.append("SupportingVisuals: ").append(this.getSupportingVisuals());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicVisual)) {
            return false;
        }
        TopicVisual other = (TopicVisual)obj;
        if (other.getVisualId() == null ^ this.getVisualId() == null) {
            return false;
        }
        if (other.getVisualId() != null && !other.getVisualId().equals(this.getVisualId())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getIr() == null ^ this.getIr() == null) {
            return false;
        }
        if (other.getIr() != null && !other.getIr().equals(this.getIr())) {
            return false;
        }
        if (other.getSupportingVisuals() == null ^ this.getSupportingVisuals() == null) {
            return false;
        }
        return other.getSupportingVisuals() == null || other.getSupportingVisuals().equals(this.getSupportingVisuals());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVisualId() == null ? 0 : this.getVisualId().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getIr() == null ? 0 : this.getIr().hashCode());
        hashCode = 31 * hashCode + (this.getSupportingVisuals() == null ? 0 : this.getSupportingVisuals().hashCode());
        return hashCode;
    }

    public TopicVisual clone() {
        try {
            return (TopicVisual)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicVisualMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

