/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.proton.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/proton-2020-07-20/GetEnvironmentAccountConnection"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetEnvironmentAccountConnectionResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable,
        Cloneable {

    /**
     * <p>
     * The detailed data of the requested environment account connection.
     * </p>
     */
    private EnvironmentAccountConnection environmentAccountConnection;

    /**
     * <p>
     * The detailed data of the requested environment account connection.
     * </p>
     * 
     * @param environmentAccountConnection
     *        The detailed data of the requested environment account connection.
     */

    public void setEnvironmentAccountConnection(EnvironmentAccountConnection environmentAccountConnection) {
        this.environmentAccountConnection = environmentAccountConnection;
    }

    /**
     * <p>
     * The detailed data of the requested environment account connection.
     * </p>
     * 
     * @return The detailed data of the requested environment account connection.
     */

    public EnvironmentAccountConnection getEnvironmentAccountConnection() {
        return this.environmentAccountConnection;
    }

    /**
     * <p>
     * The detailed data of the requested environment account connection.
     * </p>
     * 
     * @param environmentAccountConnection
     *        The detailed data of the requested environment account connection.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public GetEnvironmentAccountConnectionResult withEnvironmentAccountConnection(EnvironmentAccountConnection environmentAccountConnection) {
        setEnvironmentAccountConnection(environmentAccountConnection);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEnvironmentAccountConnection() != null)
            sb.append("EnvironmentAccountConnection: ").append(getEnvironmentAccountConnection());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof GetEnvironmentAccountConnectionResult == false)
            return false;
        GetEnvironmentAccountConnectionResult other = (GetEnvironmentAccountConnectionResult) obj;
        if (other.getEnvironmentAccountConnection() == null ^ this.getEnvironmentAccountConnection() == null)
            return false;
        if (other.getEnvironmentAccountConnection() != null && other.getEnvironmentAccountConnection().equals(this.getEnvironmentAccountConnection()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEnvironmentAccountConnection() == null) ? 0 : getEnvironmentAccountConnection().hashCode());
        return hashCode;
    }

    @Override
    public GetEnvironmentAccountConnectionResult clone() {
        try {
            return (GetEnvironmentAccountConnectionResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
