/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pricing.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.pricing.model.PriceList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListPriceListsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<PriceList> priceLists;
    private String nextToken;

    public List<PriceList> getPriceLists() {
        return this.priceLists;
    }

    public void setPriceLists(Collection<PriceList> priceLists) {
        if (priceLists == null) {
            this.priceLists = null;
            return;
        }
        this.priceLists = new ArrayList<PriceList>(priceLists);
    }

    public ListPriceListsResult withPriceLists(PriceList ... priceLists) {
        if (this.priceLists == null) {
            this.setPriceLists(new ArrayList<PriceList>(priceLists.length));
        }
        for (PriceList ele : priceLists) {
            this.priceLists.add(ele);
        }
        return this;
    }

    public ListPriceListsResult withPriceLists(Collection<PriceList> priceLists) {
        this.setPriceLists(priceLists);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListPriceListsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPriceLists() != null) {
            sb.append("PriceLists: ").append(this.getPriceLists()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPriceListsResult)) {
            return false;
        }
        ListPriceListsResult other = (ListPriceListsResult)obj;
        if (other.getPriceLists() == null ^ this.getPriceLists() == null) {
            return false;
        }
        if (other.getPriceLists() != null && !other.getPriceLists().equals(this.getPriceLists())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPriceLists() == null ? 0 : this.getPriceLists().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListPriceListsResult clone() {
        try {
            return (ListPriceListsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

