/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Welcome to the <i>AWS End User Messaging SMS and Voice, version 2 API Reference</i>. This guide provides information
 * about AWS End User Messaging SMS and Voice, version 2 API resources, including supported HTTP methods, parameters,
 * and schemas.
 * </p>
 * <p>
 * Amazon Pinpoint is an Amazon Web Services service that you can use to engage with your recipients across multiple
 * messaging channels. The AWS End User Messaging SMS and Voice, version 2 API provides programmatic access to options
 * that are unique to the SMS and voice channels. AWS End User Messaging SMS and Voice, version 2 resources such as
 * phone numbers, sender IDs, and opt-out lists can be used by the Amazon Pinpoint API.
 * </p>
 * <p>
 * If you're new to AWS End User Messaging SMS and Voice, it's also helpful to review the <a
 * href="https://docs.aws.amazon.com/sms-voice/latest/userguide/what-is-service.html"> AWS End User Messaging SMS User
 * Guide</a>. The <i>AWS End User Messaging SMS User Guide </i> provides tutorials, code samples, and procedures that
 * demonstrate how to use AWS End User Messaging SMS and Voice features programmatically and how to integrate
 * functionality into mobile apps and other types of applications. The guide also provides key information, such as AWS
 * End User Messaging SMS and Voice integration with other Amazon Web Services services, and the quotas that apply to
 * use of the service.
 * </p>
 * <p>
 * <b>Regional availability</b>
 * </p>
 * <p>
 * The <i>AWS End User Messaging SMS and Voice version 2 API Reference</i> is available in several Amazon Web Services
 * Regions and it provides an endpoint for each of these Regions. For a list of all the Regions and endpoints where the
 * API is currently available, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande.html#pinpoint_region">Amazon Web Services Service
 * Endpoints</a> and <a href="https://docs.aws.amazon.com/general/latest/gr/pinpoint.html">Amazon Pinpoint endpoints and
 * quotas</a> in the Amazon Web Services General Reference. To learn more about Amazon Web Services Regions, see <a
 * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html">Managing Amazon Web Services Regions</a> in
 * the Amazon Web Services General Reference.
 * </p>
 * <p>
 * In each Region, Amazon Web Services maintains multiple Availability Zones. These Availability Zones are physically
 * isolated from each other, but are united by private, low-latency, high-throughput, and highly redundant network
 * connections. These Availability Zones enable us to provide very high levels of availability and redundancy, while
 * also minimizing latency. To learn more about the number of Availability Zones that are available in each Region, see
 * <a href="https://aws.amazon.com/about-aws/global-infrastructure/">Amazon Web Services Global Infrastructure.</a>
 * </p>
 */
package com.amazonaws.services.pinpointsmsvoicev2;

