/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.outposts.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.outposts.model.CatalogItem;
import java.util.List;

@SdkInternalApi
public class CatalogItemMarshaller {
    private static final MarshallingInfo<String> CATALOGITEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CatalogItemId").build();
    private static final MarshallingInfo<String> ITEMSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ItemStatus").build();
    private static final MarshallingInfo<List> EC2CAPACITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2Capacities").build();
    private static final MarshallingInfo<Float> POWERKVA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PowerKva").build();
    private static final MarshallingInfo<Integer> WEIGHTLBS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WeightLbs").build();
    private static final MarshallingInfo<List> SUPPORTEDUPLINKGBPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedUplinkGbps").build();
    private static final MarshallingInfo<List> SUPPORTEDSTORAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SupportedStorage").build();
    private static final CatalogItemMarshaller instance = new CatalogItemMarshaller();

    public static CatalogItemMarshaller getInstance() {
        return instance;
    }

    public void marshall(CatalogItem catalogItem, ProtocolMarshaller protocolMarshaller) {
        if (catalogItem == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)catalogItem.getCatalogItemId(), CATALOGITEMID_BINDING);
            protocolMarshaller.marshall((Object)catalogItem.getItemStatus(), ITEMSTATUS_BINDING);
            protocolMarshaller.marshall(catalogItem.getEC2Capacities(), EC2CAPACITIES_BINDING);
            protocolMarshaller.marshall((Object)catalogItem.getPowerKva(), POWERKVA_BINDING);
            protocolMarshaller.marshall((Object)catalogItem.getWeightLbs(), WEIGHTLBS_BINDING);
            protocolMarshaller.marshall(catalogItem.getSupportedUplinkGbps(), SUPPORTEDUPLINKGBPS_BINDING);
            protocolMarshaller.marshall(catalogItem.getSupportedStorage(), SUPPORTEDSTORAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

