/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.mq.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.mq.model.transform.BrokerInstanceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BrokerInstance
implements Serializable,
Cloneable,
StructuredPojo {
    private String consoleURL;
    private List<String> endpoints;
    private String ipAddress;

    public void setConsoleURL(String consoleURL) {
        this.consoleURL = consoleURL;
    }

    public String getConsoleURL() {
        return this.consoleURL;
    }

    public BrokerInstance withConsoleURL(String consoleURL) {
        this.setConsoleURL(consoleURL);
        return this;
    }

    public List<String> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(Collection<String> endpoints) {
        if (endpoints == null) {
            this.endpoints = null;
            return;
        }
        this.endpoints = new ArrayList<String>(endpoints);
    }

    public BrokerInstance withEndpoints(String ... endpoints) {
        if (this.endpoints == null) {
            this.setEndpoints(new ArrayList<String>(endpoints.length));
        }
        for (String ele : endpoints) {
            this.endpoints.add(ele);
        }
        return this;
    }

    public BrokerInstance withEndpoints(Collection<String> endpoints) {
        this.setEndpoints(endpoints);
        return this;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public BrokerInstance withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getConsoleURL() != null) {
            sb.append("ConsoleURL: ").append(this.getConsoleURL()).append(",");
        }
        if (this.getEndpoints() != null) {
            sb.append("Endpoints: ").append(this.getEndpoints()).append(",");
        }
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerInstance)) {
            return false;
        }
        BrokerInstance other = (BrokerInstance)obj;
        if (other.getConsoleURL() == null ^ this.getConsoleURL() == null) {
            return false;
        }
        if (other.getConsoleURL() != null && !other.getConsoleURL().equals(this.getConsoleURL())) {
            return false;
        }
        if (other.getEndpoints() == null ^ this.getEndpoints() == null) {
            return false;
        }
        if (other.getEndpoints() != null && !other.getEndpoints().equals(this.getEndpoints())) {
            return false;
        }
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        return other.getIpAddress() == null || other.getIpAddress().equals(this.getIpAddress());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getConsoleURL() == null ? 0 : this.getConsoleURL().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoints() == null ? 0 : this.getEndpoints().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        return hashCode;
    }

    public BrokerInstance clone() {
        try {
            return (BrokerInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BrokerInstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

