/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.memorydb.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.memorydb.model.EngineVersionInfo;

@SdkInternalApi
public class EngineVersionInfoMarshaller {
    private static final MarshallingInfo<String> ENGINEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EngineVersion").build();
    private static final MarshallingInfo<String> ENGINEPATCHVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EnginePatchVersion").build();
    private static final MarshallingInfo<String> PARAMETERGROUPFAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParameterGroupFamily").build();
    private static final EngineVersionInfoMarshaller instance = new EngineVersionInfoMarshaller();

    public static EngineVersionInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(EngineVersionInfo engineVersionInfo, ProtocolMarshaller protocolMarshaller) {
        if (engineVersionInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)engineVersionInfo.getEngineVersion(), ENGINEVERSION_BINDING);
            protocolMarshaller.marshall((Object)engineVersionInfo.getEnginePatchVersion(), ENGINEPATCHVERSION_BINDING);
            protocolMarshaller.marshall((Object)engineVersionInfo.getParameterGroupFamily(), PARAMETERGROUPFAMILY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

