/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A set of filter conditions to include and/or exclude emails.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ArchiveFilters" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ArchiveFilters implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The filter conditions for emails to include.
     * </p>
     */
    private java.util.List<ArchiveFilterCondition> include;
    /**
     * <p>
     * The filter conditions for emails to exclude.
     * </p>
     */
    private java.util.List<ArchiveFilterCondition> unless;

    /**
     * <p>
     * The filter conditions for emails to include.
     * </p>
     * 
     * @return The filter conditions for emails to include.
     */

    public java.util.List<ArchiveFilterCondition> getInclude() {
        return include;
    }

    /**
     * <p>
     * The filter conditions for emails to include.
     * </p>
     * 
     * @param include
     *        The filter conditions for emails to include.
     */

    public void setInclude(java.util.Collection<ArchiveFilterCondition> include) {
        if (include == null) {
            this.include = null;
            return;
        }

        this.include = new java.util.ArrayList<ArchiveFilterCondition>(include);
    }

    /**
     * <p>
     * The filter conditions for emails to include.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setInclude(java.util.Collection)} or {@link #withInclude(java.util.Collection)} if you want to override
     * the existing values.
     * </p>
     * 
     * @param include
     *        The filter conditions for emails to include.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ArchiveFilters withInclude(ArchiveFilterCondition... include) {
        if (this.include == null) {
            setInclude(new java.util.ArrayList<ArchiveFilterCondition>(include.length));
        }
        for (ArchiveFilterCondition ele : include) {
            this.include.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The filter conditions for emails to include.
     * </p>
     * 
     * @param include
     *        The filter conditions for emails to include.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ArchiveFilters withInclude(java.util.Collection<ArchiveFilterCondition> include) {
        setInclude(include);
        return this;
    }

    /**
     * <p>
     * The filter conditions for emails to exclude.
     * </p>
     * 
     * @return The filter conditions for emails to exclude.
     */

    public java.util.List<ArchiveFilterCondition> getUnless() {
        return unless;
    }

    /**
     * <p>
     * The filter conditions for emails to exclude.
     * </p>
     * 
     * @param unless
     *        The filter conditions for emails to exclude.
     */

    public void setUnless(java.util.Collection<ArchiveFilterCondition> unless) {
        if (unless == null) {
            this.unless = null;
            return;
        }

        this.unless = new java.util.ArrayList<ArchiveFilterCondition>(unless);
    }

    /**
     * <p>
     * The filter conditions for emails to exclude.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setUnless(java.util.Collection)} or {@link #withUnless(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param unless
     *        The filter conditions for emails to exclude.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ArchiveFilters withUnless(ArchiveFilterCondition... unless) {
        if (this.unless == null) {
            setUnless(new java.util.ArrayList<ArchiveFilterCondition>(unless.length));
        }
        for (ArchiveFilterCondition ele : unless) {
            this.unless.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The filter conditions for emails to exclude.
     * </p>
     * 
     * @param unless
     *        The filter conditions for emails to exclude.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ArchiveFilters withUnless(java.util.Collection<ArchiveFilterCondition> unless) {
        setUnless(unless);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInclude() != null)
            sb.append("Include: ").append(getInclude()).append(",");
        if (getUnless() != null)
            sb.append("Unless: ").append(getUnless());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ArchiveFilters == false)
            return false;
        ArchiveFilters other = (ArchiveFilters) obj;
        if (other.getInclude() == null ^ this.getInclude() == null)
            return false;
        if (other.getInclude() != null && other.getInclude().equals(this.getInclude()) == false)
            return false;
        if (other.getUnless() == null ^ this.getUnless() == null)
            return false;
        if (other.getUnless() != null && other.getUnless().equals(this.getUnless()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInclude() == null) ? 0 : getInclude().hashCode());
        hashCode = prime * hashCode + ((getUnless() == null) ? 0 : getUnless().hashCode());
        return hashCode;
    }

    @Override
    public ArchiveFilters clone() {
        try {
            return (ArchiveFilters) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.ArchiveFiltersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
