/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A filter condition used to include or exclude emails when exporting from or searching an archive.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/mailmanager-2023-10-17/ArchiveFilterCondition" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ArchiveFilterCondition implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     */
    private ArchiveBooleanExpression booleanExpression;
    /**
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     */
    private ArchiveStringExpression stringExpression;

    /**
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     * 
     * @param booleanExpression
     *        A boolean expression to evaluate against email attributes.
     */

    public void setBooleanExpression(ArchiveBooleanExpression booleanExpression) {
        this.booleanExpression = booleanExpression;
    }

    /**
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     * 
     * @return A boolean expression to evaluate against email attributes.
     */

    public ArchiveBooleanExpression getBooleanExpression() {
        return this.booleanExpression;
    }

    /**
     * <p>
     * A boolean expression to evaluate against email attributes.
     * </p>
     * 
     * @param booleanExpression
     *        A boolean expression to evaluate against email attributes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ArchiveFilterCondition withBooleanExpression(ArchiveBooleanExpression booleanExpression) {
        setBooleanExpression(booleanExpression);
        return this;
    }

    /**
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     * 
     * @param stringExpression
     *        A string expression to evaluate against email attributes.
     */

    public void setStringExpression(ArchiveStringExpression stringExpression) {
        this.stringExpression = stringExpression;
    }

    /**
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     * 
     * @return A string expression to evaluate against email attributes.
     */

    public ArchiveStringExpression getStringExpression() {
        return this.stringExpression;
    }

    /**
     * <p>
     * A string expression to evaluate against email attributes.
     * </p>
     * 
     * @param stringExpression
     *        A string expression to evaluate against email attributes.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ArchiveFilterCondition withStringExpression(ArchiveStringExpression stringExpression) {
        setStringExpression(stringExpression);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getBooleanExpression() != null)
            sb.append("BooleanExpression: ").append(getBooleanExpression()).append(",");
        if (getStringExpression() != null)
            sb.append("StringExpression: ").append(getStringExpression());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ArchiveFilterCondition == false)
            return false;
        ArchiveFilterCondition other = (ArchiveFilterCondition) obj;
        if (other.getBooleanExpression() == null ^ this.getBooleanExpression() == null)
            return false;
        if (other.getBooleanExpression() != null && other.getBooleanExpression().equals(this.getBooleanExpression()) == false)
            return false;
        if (other.getStringExpression() == null ^ this.getStringExpression() == null)
            return false;
        if (other.getStringExpression() != null && other.getStringExpression().equals(this.getStringExpression()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getBooleanExpression() == null) ? 0 : getBooleanExpression().hashCode());
        hashCode = prime * hashCode + ((getStringExpression() == null) ? 0 : getStringExpression().hashCode());
        return hashCode;
    }

    @Override
    public ArchiveFilterCondition clone() {
        try {
            return (ArchiveFilterCondition) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.mailmanager.model.transform.ArchiveFilterConditionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
