/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.mailmanager;

import javax.annotation.Generated;

import com.amazonaws.services.mailmanager.model.*;

/**
 * Abstract implementation of {@code AWSMailManagerAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSMailManagerAsync extends AbstractAWSMailManager implements AWSMailManagerAsync {

    protected AbstractAWSMailManagerAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateAddonInstanceResult> createAddonInstanceAsync(CreateAddonInstanceRequest request) {

        return createAddonInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAddonInstanceResult> createAddonInstanceAsync(CreateAddonInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAddonInstanceRequest, CreateAddonInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateAddonSubscriptionResult> createAddonSubscriptionAsync(CreateAddonSubscriptionRequest request) {

        return createAddonSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateAddonSubscriptionResult> createAddonSubscriptionAsync(CreateAddonSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateAddonSubscriptionRequest, CreateAddonSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateArchiveResult> createArchiveAsync(CreateArchiveRequest request) {

        return createArchiveAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateArchiveResult> createArchiveAsync(CreateArchiveRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateArchiveRequest, CreateArchiveResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateIngressPointResult> createIngressPointAsync(CreateIngressPointRequest request) {

        return createIngressPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateIngressPointResult> createIngressPointAsync(CreateIngressPointRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateIngressPointRequest, CreateIngressPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRelayResult> createRelayAsync(CreateRelayRequest request) {

        return createRelayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRelayResult> createRelayAsync(CreateRelayRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRelayRequest, CreateRelayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateRuleSetResult> createRuleSetAsync(CreateRuleSetRequest request) {

        return createRuleSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateRuleSetResult> createRuleSetAsync(CreateRuleSetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateRuleSetRequest, CreateRuleSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTrafficPolicyResult> createTrafficPolicyAsync(CreateTrafficPolicyRequest request) {

        return createTrafficPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTrafficPolicyResult> createTrafficPolicyAsync(CreateTrafficPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTrafficPolicyRequest, CreateTrafficPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAddonInstanceResult> deleteAddonInstanceAsync(DeleteAddonInstanceRequest request) {

        return deleteAddonInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAddonInstanceResult> deleteAddonInstanceAsync(DeleteAddonInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAddonInstanceRequest, DeleteAddonInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteAddonSubscriptionResult> deleteAddonSubscriptionAsync(DeleteAddonSubscriptionRequest request) {

        return deleteAddonSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteAddonSubscriptionResult> deleteAddonSubscriptionAsync(DeleteAddonSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteAddonSubscriptionRequest, DeleteAddonSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteArchiveResult> deleteArchiveAsync(DeleteArchiveRequest request) {

        return deleteArchiveAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteArchiveResult> deleteArchiveAsync(DeleteArchiveRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteArchiveRequest, DeleteArchiveResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteIngressPointResult> deleteIngressPointAsync(DeleteIngressPointRequest request) {

        return deleteIngressPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteIngressPointResult> deleteIngressPointAsync(DeleteIngressPointRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteIngressPointRequest, DeleteIngressPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRelayResult> deleteRelayAsync(DeleteRelayRequest request) {

        return deleteRelayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRelayResult> deleteRelayAsync(DeleteRelayRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRelayRequest, DeleteRelayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteRuleSetResult> deleteRuleSetAsync(DeleteRuleSetRequest request) {

        return deleteRuleSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteRuleSetResult> deleteRuleSetAsync(DeleteRuleSetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteRuleSetRequest, DeleteRuleSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTrafficPolicyResult> deleteTrafficPolicyAsync(DeleteTrafficPolicyRequest request) {

        return deleteTrafficPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTrafficPolicyResult> deleteTrafficPolicyAsync(DeleteTrafficPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTrafficPolicyRequest, DeleteTrafficPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAddonInstanceResult> getAddonInstanceAsync(GetAddonInstanceRequest request) {

        return getAddonInstanceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAddonInstanceResult> getAddonInstanceAsync(GetAddonInstanceRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAddonInstanceRequest, GetAddonInstanceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetAddonSubscriptionResult> getAddonSubscriptionAsync(GetAddonSubscriptionRequest request) {

        return getAddonSubscriptionAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetAddonSubscriptionResult> getAddonSubscriptionAsync(GetAddonSubscriptionRequest request,
            com.amazonaws.handlers.AsyncHandler<GetAddonSubscriptionRequest, GetAddonSubscriptionResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetArchiveResult> getArchiveAsync(GetArchiveRequest request) {

        return getArchiveAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetArchiveResult> getArchiveAsync(GetArchiveRequest request,
            com.amazonaws.handlers.AsyncHandler<GetArchiveRequest, GetArchiveResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetArchiveExportResult> getArchiveExportAsync(GetArchiveExportRequest request) {

        return getArchiveExportAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetArchiveExportResult> getArchiveExportAsync(GetArchiveExportRequest request,
            com.amazonaws.handlers.AsyncHandler<GetArchiveExportRequest, GetArchiveExportResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetArchiveMessageResult> getArchiveMessageAsync(GetArchiveMessageRequest request) {

        return getArchiveMessageAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetArchiveMessageResult> getArchiveMessageAsync(GetArchiveMessageRequest request,
            com.amazonaws.handlers.AsyncHandler<GetArchiveMessageRequest, GetArchiveMessageResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetArchiveMessageContentResult> getArchiveMessageContentAsync(GetArchiveMessageContentRequest request) {

        return getArchiveMessageContentAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetArchiveMessageContentResult> getArchiveMessageContentAsync(GetArchiveMessageContentRequest request,
            com.amazonaws.handlers.AsyncHandler<GetArchiveMessageContentRequest, GetArchiveMessageContentResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetArchiveSearchResult> getArchiveSearchAsync(GetArchiveSearchRequest request) {

        return getArchiveSearchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetArchiveSearchResult> getArchiveSearchAsync(GetArchiveSearchRequest request,
            com.amazonaws.handlers.AsyncHandler<GetArchiveSearchRequest, GetArchiveSearchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetArchiveSearchResultsResult> getArchiveSearchResultsAsync(GetArchiveSearchResultsRequest request) {

        return getArchiveSearchResultsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetArchiveSearchResultsResult> getArchiveSearchResultsAsync(GetArchiveSearchResultsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetArchiveSearchResultsRequest, GetArchiveSearchResultsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetIngressPointResult> getIngressPointAsync(GetIngressPointRequest request) {

        return getIngressPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetIngressPointResult> getIngressPointAsync(GetIngressPointRequest request,
            com.amazonaws.handlers.AsyncHandler<GetIngressPointRequest, GetIngressPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRelayResult> getRelayAsync(GetRelayRequest request) {

        return getRelayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRelayResult> getRelayAsync(GetRelayRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRelayRequest, GetRelayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRuleSetResult> getRuleSetAsync(GetRuleSetRequest request) {

        return getRuleSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRuleSetResult> getRuleSetAsync(GetRuleSetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRuleSetRequest, GetRuleSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTrafficPolicyResult> getTrafficPolicyAsync(GetTrafficPolicyRequest request) {

        return getTrafficPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTrafficPolicyResult> getTrafficPolicyAsync(GetTrafficPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTrafficPolicyRequest, GetTrafficPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAddonInstancesResult> listAddonInstancesAsync(ListAddonInstancesRequest request) {

        return listAddonInstancesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAddonInstancesResult> listAddonInstancesAsync(ListAddonInstancesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAddonInstancesRequest, ListAddonInstancesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListAddonSubscriptionsResult> listAddonSubscriptionsAsync(ListAddonSubscriptionsRequest request) {

        return listAddonSubscriptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListAddonSubscriptionsResult> listAddonSubscriptionsAsync(ListAddonSubscriptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListAddonSubscriptionsRequest, ListAddonSubscriptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListArchiveExportsResult> listArchiveExportsAsync(ListArchiveExportsRequest request) {

        return listArchiveExportsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListArchiveExportsResult> listArchiveExportsAsync(ListArchiveExportsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListArchiveExportsRequest, ListArchiveExportsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListArchiveSearchesResult> listArchiveSearchesAsync(ListArchiveSearchesRequest request) {

        return listArchiveSearchesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListArchiveSearchesResult> listArchiveSearchesAsync(ListArchiveSearchesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListArchiveSearchesRequest, ListArchiveSearchesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListArchivesResult> listArchivesAsync(ListArchivesRequest request) {

        return listArchivesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListArchivesResult> listArchivesAsync(ListArchivesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListArchivesRequest, ListArchivesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListIngressPointsResult> listIngressPointsAsync(ListIngressPointsRequest request) {

        return listIngressPointsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListIngressPointsResult> listIngressPointsAsync(ListIngressPointsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListIngressPointsRequest, ListIngressPointsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRelaysResult> listRelaysAsync(ListRelaysRequest request) {

        return listRelaysAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRelaysResult> listRelaysAsync(ListRelaysRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRelaysRequest, ListRelaysResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListRuleSetsResult> listRuleSetsAsync(ListRuleSetsRequest request) {

        return listRuleSetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListRuleSetsResult> listRuleSetsAsync(ListRuleSetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListRuleSetsRequest, ListRuleSetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(ListTrafficPoliciesRequest request) {

        return listTrafficPoliciesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTrafficPoliciesResult> listTrafficPoliciesAsync(ListTrafficPoliciesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTrafficPoliciesRequest, ListTrafficPoliciesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartArchiveExportResult> startArchiveExportAsync(StartArchiveExportRequest request) {

        return startArchiveExportAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartArchiveExportResult> startArchiveExportAsync(StartArchiveExportRequest request,
            com.amazonaws.handlers.AsyncHandler<StartArchiveExportRequest, StartArchiveExportResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartArchiveSearchResult> startArchiveSearchAsync(StartArchiveSearchRequest request) {

        return startArchiveSearchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartArchiveSearchResult> startArchiveSearchAsync(StartArchiveSearchRequest request,
            com.amazonaws.handlers.AsyncHandler<StartArchiveSearchRequest, StartArchiveSearchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopArchiveExportResult> stopArchiveExportAsync(StopArchiveExportRequest request) {

        return stopArchiveExportAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopArchiveExportResult> stopArchiveExportAsync(StopArchiveExportRequest request,
            com.amazonaws.handlers.AsyncHandler<StopArchiveExportRequest, StopArchiveExportResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StopArchiveSearchResult> stopArchiveSearchAsync(StopArchiveSearchRequest request) {

        return stopArchiveSearchAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StopArchiveSearchResult> stopArchiveSearchAsync(StopArchiveSearchRequest request,
            com.amazonaws.handlers.AsyncHandler<StopArchiveSearchRequest, StopArchiveSearchResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateArchiveResult> updateArchiveAsync(UpdateArchiveRequest request) {

        return updateArchiveAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateArchiveResult> updateArchiveAsync(UpdateArchiveRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateArchiveRequest, UpdateArchiveResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateIngressPointResult> updateIngressPointAsync(UpdateIngressPointRequest request) {

        return updateIngressPointAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateIngressPointResult> updateIngressPointAsync(UpdateIngressPointRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateIngressPointRequest, UpdateIngressPointResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRelayResult> updateRelayAsync(UpdateRelayRequest request) {

        return updateRelayAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRelayResult> updateRelayAsync(UpdateRelayRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRelayRequest, UpdateRelayResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateRuleSetResult> updateRuleSetAsync(UpdateRuleSetRequest request) {

        return updateRuleSetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateRuleSetResult> updateRuleSetAsync(UpdateRuleSetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateRuleSetRequest, UpdateRuleSetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTrafficPolicyResult> updateTrafficPolicyAsync(UpdateTrafficPolicyRequest request) {

        return updateTrafficPolicyAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTrafficPolicyResult> updateTrafficPolicyAsync(UpdateTrafficPolicyRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTrafficPolicyRequest, UpdateTrafficPolicyResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
