/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lookoutequipment.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.lookoutequipment.model.S3Object;
import com.amazonaws.services.lookoutequipment.model.transform.IngestedFilesSummaryMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IngestedFilesSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer totalNumberOfFiles;
    private Integer ingestedNumberOfFiles;
    private List<S3Object> discardedFiles;

    public void setTotalNumberOfFiles(Integer totalNumberOfFiles) {
        this.totalNumberOfFiles = totalNumberOfFiles;
    }

    public Integer getTotalNumberOfFiles() {
        return this.totalNumberOfFiles;
    }

    public IngestedFilesSummary withTotalNumberOfFiles(Integer totalNumberOfFiles) {
        this.setTotalNumberOfFiles(totalNumberOfFiles);
        return this;
    }

    public void setIngestedNumberOfFiles(Integer ingestedNumberOfFiles) {
        this.ingestedNumberOfFiles = ingestedNumberOfFiles;
    }

    public Integer getIngestedNumberOfFiles() {
        return this.ingestedNumberOfFiles;
    }

    public IngestedFilesSummary withIngestedNumberOfFiles(Integer ingestedNumberOfFiles) {
        this.setIngestedNumberOfFiles(ingestedNumberOfFiles);
        return this;
    }

    public List<S3Object> getDiscardedFiles() {
        return this.discardedFiles;
    }

    public void setDiscardedFiles(Collection<S3Object> discardedFiles) {
        if (discardedFiles == null) {
            this.discardedFiles = null;
            return;
        }
        this.discardedFiles = new ArrayList<S3Object>(discardedFiles);
    }

    public IngestedFilesSummary withDiscardedFiles(S3Object ... discardedFiles) {
        if (this.discardedFiles == null) {
            this.setDiscardedFiles(new ArrayList<S3Object>(discardedFiles.length));
        }
        for (S3Object ele : discardedFiles) {
            this.discardedFiles.add(ele);
        }
        return this;
    }

    public IngestedFilesSummary withDiscardedFiles(Collection<S3Object> discardedFiles) {
        this.setDiscardedFiles(discardedFiles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTotalNumberOfFiles() != null) {
            sb.append("TotalNumberOfFiles: ").append(this.getTotalNumberOfFiles()).append(",");
        }
        if (this.getIngestedNumberOfFiles() != null) {
            sb.append("IngestedNumberOfFiles: ").append(this.getIngestedNumberOfFiles()).append(",");
        }
        if (this.getDiscardedFiles() != null) {
            sb.append("DiscardedFiles: ").append(this.getDiscardedFiles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestedFilesSummary)) {
            return false;
        }
        IngestedFilesSummary other = (IngestedFilesSummary)obj;
        if (other.getTotalNumberOfFiles() == null ^ this.getTotalNumberOfFiles() == null) {
            return false;
        }
        if (other.getTotalNumberOfFiles() != null && !other.getTotalNumberOfFiles().equals(this.getTotalNumberOfFiles())) {
            return false;
        }
        if (other.getIngestedNumberOfFiles() == null ^ this.getIngestedNumberOfFiles() == null) {
            return false;
        }
        if (other.getIngestedNumberOfFiles() != null && !other.getIngestedNumberOfFiles().equals(this.getIngestedNumberOfFiles())) {
            return false;
        }
        if (other.getDiscardedFiles() == null ^ this.getDiscardedFiles() == null) {
            return false;
        }
        return other.getDiscardedFiles() == null || other.getDiscardedFiles().equals(this.getDiscardedFiles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTotalNumberOfFiles() == null ? 0 : this.getTotalNumberOfFiles().hashCode());
        hashCode = 31 * hashCode + (this.getIngestedNumberOfFiles() == null ? 0 : this.getIngestedNumberOfFiles().hashCode());
        hashCode = 31 * hashCode + (this.getDiscardedFiles() == null ? 0 : this.getDiscardedFiles().hashCode());
        return hashCode;
    }

    public IngestedFilesSummary clone() {
        try {
            return (IngestedFilesSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IngestedFilesSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

