/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lambda.model.InvokeRequest;
import java.nio.ByteBuffer;

@SdkInternalApi
public class InvokeRequestMarshaller {
    private static final MarshallingInfo<String> FUNCTIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("FunctionName").build();
    private static final MarshallingInfo<String> INVOCATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Invocation-Type").build();
    private static final MarshallingInfo<String> LOGTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Log-Type").build();
    private static final MarshallingInfo<String> CLIENTCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("X-Amz-Client-Context").build();
    private static final MarshallingInfo<ByteBuffer> PAYLOAD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).isBinary(true).build();
    private static final MarshallingInfo<String> QUALIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("Qualifier").build();
    private static final InvokeRequestMarshaller instance = new InvokeRequestMarshaller();

    public static InvokeRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(InvokeRequest invokeRequest, ProtocolMarshaller protocolMarshaller) {
        if (invokeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)invokeRequest.getFunctionName(), FUNCTIONNAME_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.getInvocationType(), INVOCATIONTYPE_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.getLogType(), LOGTYPE_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.getClientContext(), CLIENTCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.getPayload(), PAYLOAD_BINDING);
            protocolMarshaller.marshall((Object)invokeRequest.getQualifier(), QUALIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

