/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.kms.model.CreateGrantRequest;
import com.amazonaws.services.kms.model.GrantConstraints;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class CreateGrantRequestMarshaller
implements Marshaller<Request<CreateGrantRequest>, CreateGrantRequest> {
    public Request<CreateGrantRequest> marshall(CreateGrantRequest createGrantRequest) {
        if (createGrantRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createGrantRequest, "AWSKMS");
        String target = "TrentService.CreateGrant";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            ListWithAutoConstructFlag grantTokensList;
            GrantConstraints constraints;
            ListWithAutoConstructFlag operationsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (createGrantRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value((Object)createGrantRequest.getKeyId());
            }
            if (createGrantRequest.getGranteePrincipal() != null) {
                jsonWriter.key("GranteePrincipal").value((Object)createGrantRequest.getGranteePrincipal());
            }
            if (createGrantRequest.getRetiringPrincipal() != null) {
                jsonWriter.key("RetiringPrincipal").value((Object)createGrantRequest.getRetiringPrincipal());
            }
            if (!((operationsList = (ListWithAutoConstructFlag)createGrantRequest.getOperations()) == null || operationsList.isAutoConstruct() && operationsList.isEmpty())) {
                jsonWriter.key("Operations");
                jsonWriter.array();
                for (String operationsListValue : operationsList) {
                    if (operationsListValue == null) continue;
                    jsonWriter.value((Object)operationsListValue);
                }
                jsonWriter.endArray();
            }
            if ((constraints = createGrantRequest.getConstraints()) != null) {
                jsonWriter.key("Constraints");
                jsonWriter.object();
                if (constraints.getEncryptionContextSubset() != null) {
                    jsonWriter.key("EncryptionContextSubset");
                    jsonWriter.object();
                    for (Map.Entry<String, String> encryptionContextSubsetListValue : constraints.getEncryptionContextSubset().entrySet()) {
                        if (encryptionContextSubsetListValue.getValue() == null) continue;
                        jsonWriter.key(encryptionContextSubsetListValue.getKey());
                        jsonWriter.value((Object)encryptionContextSubsetListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                if (constraints.getEncryptionContextEquals() != null) {
                    jsonWriter.key("EncryptionContextEquals");
                    jsonWriter.object();
                    for (Map.Entry<String, String> encryptionContextEqualsListValue : constraints.getEncryptionContextEquals().entrySet()) {
                        if (encryptionContextEqualsListValue.getValue() == null) continue;
                        jsonWriter.key(encryptionContextEqualsListValue.getKey());
                        jsonWriter.value((Object)encryptionContextEqualsListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endObject();
            }
            if (!((grantTokensList = (ListWithAutoConstructFlag)createGrantRequest.getGrantTokens()) == null || grantTokensList.isAutoConstruct() && grantTokensList.isEmpty())) {
                jsonWriter.key("GrantTokens");
                jsonWriter.array();
                for (String grantTokensListValue : grantTokensList) {
                    if (grantTokensListValue == null) continue;
                    jsonWriter.value((Object)grantTokensListValue);
                }
                jsonWriter.endArray();
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

