/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iotfleetwise;

import javax.annotation.Generated;

import com.amazonaws.services.iotfleetwise.model.*;

/**
 * Abstract implementation of {@code AWSIoTFleetWiseAsync}. Convenient method forms pass through to the corresponding
 * overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoTFleetWiseAsync extends AbstractAWSIoTFleetWise implements AWSIoTFleetWiseAsync {

    protected AbstractAWSIoTFleetWiseAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateVehicleFleetResult> associateVehicleFleetAsync(AssociateVehicleFleetRequest request) {

        return associateVehicleFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateVehicleFleetResult> associateVehicleFleetAsync(AssociateVehicleFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateVehicleFleetRequest, AssociateVehicleFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchCreateVehicleResult> batchCreateVehicleAsync(BatchCreateVehicleRequest request) {

        return batchCreateVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchCreateVehicleResult> batchCreateVehicleAsync(BatchCreateVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchCreateVehicleRequest, BatchCreateVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateVehicleResult> batchUpdateVehicleAsync(BatchUpdateVehicleRequest request) {

        return batchUpdateVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<BatchUpdateVehicleResult> batchUpdateVehicleAsync(BatchUpdateVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<BatchUpdateVehicleRequest, BatchUpdateVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateCampaignResult> createCampaignAsync(CreateCampaignRequest request) {

        return createCampaignAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCampaignResult> createCampaignAsync(CreateCampaignRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCampaignRequest, CreateCampaignResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateDecoderManifestResult> createDecoderManifestAsync(CreateDecoderManifestRequest request) {

        return createDecoderManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateDecoderManifestResult> createDecoderManifestAsync(CreateDecoderManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateDecoderManifestRequest, CreateDecoderManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request) {

        return createFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateModelManifestResult> createModelManifestAsync(CreateModelManifestRequest request) {

        return createModelManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateModelManifestResult> createModelManifestAsync(CreateModelManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateModelManifestRequest, CreateModelManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateSignalCatalogResult> createSignalCatalogAsync(CreateSignalCatalogRequest request) {

        return createSignalCatalogAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateSignalCatalogResult> createSignalCatalogAsync(CreateSignalCatalogRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateSignalCatalogRequest, CreateSignalCatalogResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateVehicleResult> createVehicleAsync(CreateVehicleRequest request) {

        return createVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateVehicleResult> createVehicleAsync(CreateVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateVehicleRequest, CreateVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCampaignResult> deleteCampaignAsync(DeleteCampaignRequest request) {

        return deleteCampaignAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCampaignResult> deleteCampaignAsync(DeleteCampaignRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCampaignRequest, DeleteCampaignResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteDecoderManifestResult> deleteDecoderManifestAsync(DeleteDecoderManifestRequest request) {

        return deleteDecoderManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteDecoderManifestResult> deleteDecoderManifestAsync(DeleteDecoderManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteDecoderManifestRequest, DeleteDecoderManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request) {

        return deleteFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteFleetRequest, DeleteFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteModelManifestResult> deleteModelManifestAsync(DeleteModelManifestRequest request) {

        return deleteModelManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteModelManifestResult> deleteModelManifestAsync(DeleteModelManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteModelManifestRequest, DeleteModelManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteSignalCatalogResult> deleteSignalCatalogAsync(DeleteSignalCatalogRequest request) {

        return deleteSignalCatalogAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteSignalCatalogResult> deleteSignalCatalogAsync(DeleteSignalCatalogRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteSignalCatalogRequest, DeleteSignalCatalogResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteVehicleResult> deleteVehicleAsync(DeleteVehicleRequest request) {

        return deleteVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteVehicleResult> deleteVehicleAsync(DeleteVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteVehicleRequest, DeleteVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateVehicleFleetResult> disassociateVehicleFleetAsync(DisassociateVehicleFleetRequest request) {

        return disassociateVehicleFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateVehicleFleetResult> disassociateVehicleFleetAsync(DisassociateVehicleFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateVehicleFleetRequest, DisassociateVehicleFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCampaignResult> getCampaignAsync(GetCampaignRequest request) {

        return getCampaignAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCampaignResult> getCampaignAsync(GetCampaignRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCampaignRequest, GetCampaignResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDecoderManifestResult> getDecoderManifestAsync(GetDecoderManifestRequest request) {

        return getDecoderManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDecoderManifestResult> getDecoderManifestAsync(GetDecoderManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDecoderManifestRequest, GetDecoderManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetEncryptionConfigurationResult> getEncryptionConfigurationAsync(GetEncryptionConfigurationRequest request) {

        return getEncryptionConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetEncryptionConfigurationResult> getEncryptionConfigurationAsync(GetEncryptionConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<GetEncryptionConfigurationRequest, GetEncryptionConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetFleetResult> getFleetAsync(GetFleetRequest request) {

        return getFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetFleetResult> getFleetAsync(GetFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<GetFleetRequest, GetFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetLoggingOptionsResult> getLoggingOptionsAsync(GetLoggingOptionsRequest request) {

        return getLoggingOptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetLoggingOptionsResult> getLoggingOptionsAsync(GetLoggingOptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<GetLoggingOptionsRequest, GetLoggingOptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetModelManifestResult> getModelManifestAsync(GetModelManifestRequest request) {

        return getModelManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetModelManifestResult> getModelManifestAsync(GetModelManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<GetModelManifestRequest, GetModelManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetRegisterAccountStatusResult> getRegisterAccountStatusAsync(GetRegisterAccountStatusRequest request) {

        return getRegisterAccountStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetRegisterAccountStatusResult> getRegisterAccountStatusAsync(GetRegisterAccountStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetRegisterAccountStatusRequest, GetRegisterAccountStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetSignalCatalogResult> getSignalCatalogAsync(GetSignalCatalogRequest request) {

        return getSignalCatalogAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetSignalCatalogResult> getSignalCatalogAsync(GetSignalCatalogRequest request,
            com.amazonaws.handlers.AsyncHandler<GetSignalCatalogRequest, GetSignalCatalogResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetVehicleResult> getVehicleAsync(GetVehicleRequest request) {

        return getVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetVehicleResult> getVehicleAsync(GetVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<GetVehicleRequest, GetVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetVehicleStatusResult> getVehicleStatusAsync(GetVehicleStatusRequest request) {

        return getVehicleStatusAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetVehicleStatusResult> getVehicleStatusAsync(GetVehicleStatusRequest request,
            com.amazonaws.handlers.AsyncHandler<GetVehicleStatusRequest, GetVehicleStatusResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ImportDecoderManifestResult> importDecoderManifestAsync(ImportDecoderManifestRequest request) {

        return importDecoderManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ImportDecoderManifestResult> importDecoderManifestAsync(ImportDecoderManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<ImportDecoderManifestRequest, ImportDecoderManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ImportSignalCatalogResult> importSignalCatalogAsync(ImportSignalCatalogRequest request) {

        return importSignalCatalogAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ImportSignalCatalogResult> importSignalCatalogAsync(ImportSignalCatalogRequest request,
            com.amazonaws.handlers.AsyncHandler<ImportSignalCatalogRequest, ImportSignalCatalogResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCampaignsResult> listCampaignsAsync(ListCampaignsRequest request) {

        return listCampaignsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCampaignsResult> listCampaignsAsync(ListCampaignsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCampaignsRequest, ListCampaignsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDecoderManifestNetworkInterfacesResult> listDecoderManifestNetworkInterfacesAsync(
            ListDecoderManifestNetworkInterfacesRequest request) {

        return listDecoderManifestNetworkInterfacesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDecoderManifestNetworkInterfacesResult> listDecoderManifestNetworkInterfacesAsync(
            ListDecoderManifestNetworkInterfacesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDecoderManifestNetworkInterfacesRequest, ListDecoderManifestNetworkInterfacesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDecoderManifestSignalsResult> listDecoderManifestSignalsAsync(ListDecoderManifestSignalsRequest request) {

        return listDecoderManifestSignalsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDecoderManifestSignalsResult> listDecoderManifestSignalsAsync(ListDecoderManifestSignalsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDecoderManifestSignalsRequest, ListDecoderManifestSignalsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListDecoderManifestsResult> listDecoderManifestsAsync(ListDecoderManifestsRequest request) {

        return listDecoderManifestsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListDecoderManifestsResult> listDecoderManifestsAsync(ListDecoderManifestsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListDecoderManifestsRequest, ListDecoderManifestsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request) {

        return listFleetsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFleetsResult> listFleetsAsync(ListFleetsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFleetsRequest, ListFleetsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListFleetsForVehicleResult> listFleetsForVehicleAsync(ListFleetsForVehicleRequest request) {

        return listFleetsForVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListFleetsForVehicleResult> listFleetsForVehicleAsync(ListFleetsForVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<ListFleetsForVehicleRequest, ListFleetsForVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListModelManifestNodesResult> listModelManifestNodesAsync(ListModelManifestNodesRequest request) {

        return listModelManifestNodesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListModelManifestNodesResult> listModelManifestNodesAsync(ListModelManifestNodesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListModelManifestNodesRequest, ListModelManifestNodesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListModelManifestsResult> listModelManifestsAsync(ListModelManifestsRequest request) {

        return listModelManifestsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListModelManifestsResult> listModelManifestsAsync(ListModelManifestsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListModelManifestsRequest, ListModelManifestsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSignalCatalogNodesResult> listSignalCatalogNodesAsync(ListSignalCatalogNodesRequest request) {

        return listSignalCatalogNodesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSignalCatalogNodesResult> listSignalCatalogNodesAsync(ListSignalCatalogNodesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSignalCatalogNodesRequest, ListSignalCatalogNodesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListSignalCatalogsResult> listSignalCatalogsAsync(ListSignalCatalogsRequest request) {

        return listSignalCatalogsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListSignalCatalogsResult> listSignalCatalogsAsync(ListSignalCatalogsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListSignalCatalogsRequest, ListSignalCatalogsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListVehiclesResult> listVehiclesAsync(ListVehiclesRequest request) {

        return listVehiclesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListVehiclesResult> listVehiclesAsync(ListVehiclesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListVehiclesRequest, ListVehiclesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListVehiclesInFleetResult> listVehiclesInFleetAsync(ListVehiclesInFleetRequest request) {

        return listVehiclesInFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListVehiclesInFleetResult> listVehiclesInFleetAsync(ListVehiclesInFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<ListVehiclesInFleetRequest, ListVehiclesInFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutEncryptionConfigurationResult> putEncryptionConfigurationAsync(PutEncryptionConfigurationRequest request) {

        return putEncryptionConfigurationAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutEncryptionConfigurationResult> putEncryptionConfigurationAsync(PutEncryptionConfigurationRequest request,
            com.amazonaws.handlers.AsyncHandler<PutEncryptionConfigurationRequest, PutEncryptionConfigurationResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request) {

        return putLoggingOptionsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<PutLoggingOptionsResult> putLoggingOptionsAsync(PutLoggingOptionsRequest request,
            com.amazonaws.handlers.AsyncHandler<PutLoggingOptionsRequest, PutLoggingOptionsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<RegisterAccountResult> registerAccountAsync(RegisterAccountRequest request) {

        return registerAccountAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<RegisterAccountResult> registerAccountAsync(RegisterAccountRequest request,
            com.amazonaws.handlers.AsyncHandler<RegisterAccountRequest, RegisterAccountResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateCampaignResult> updateCampaignAsync(UpdateCampaignRequest request) {

        return updateCampaignAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateCampaignResult> updateCampaignAsync(UpdateCampaignRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateCampaignRequest, UpdateCampaignResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateDecoderManifestResult> updateDecoderManifestAsync(UpdateDecoderManifestRequest request) {

        return updateDecoderManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateDecoderManifestResult> updateDecoderManifestAsync(UpdateDecoderManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateDecoderManifestRequest, UpdateDecoderManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateFleetResult> updateFleetAsync(UpdateFleetRequest request) {

        return updateFleetAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateFleetResult> updateFleetAsync(UpdateFleetRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateFleetRequest, UpdateFleetResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateModelManifestResult> updateModelManifestAsync(UpdateModelManifestRequest request) {

        return updateModelManifestAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateModelManifestResult> updateModelManifestAsync(UpdateModelManifestRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateModelManifestRequest, UpdateModelManifestResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateSignalCatalogResult> updateSignalCatalogAsync(UpdateSignalCatalogRequest request) {

        return updateSignalCatalogAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateSignalCatalogResult> updateSignalCatalogAsync(UpdateSignalCatalogRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateSignalCatalogRequest, UpdateSignalCatalogResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateVehicleResult> updateVehicleAsync(UpdateVehicleRequest request) {

        return updateVehicleAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateVehicleResult> updateVehicleAsync(UpdateVehicleRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateVehicleRequest, UpdateVehicleResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
